# 📖 Panduan Menjalankan Aplikasi Laravel di Localhost (XAMPP)

## 🔍 Masalah yang Ditemukan

Berdasarkan analisis, ada beberapa masalah yang menyebabkan aplikasi tidak bisa running:

1. ✅ **Route cache** - Sudah dibersihkan
2. ✅ **Config cache** - Sudah dibersihkan  
3. ✅ **View cache** - Sudah dibersihkan
4. ⚠️ **Konfigurasi .env** - Perlu disesuaikan untuk local development
5. ⚠️ **Database connection** - Perlu dicek

## 🚀 Langkah-langkah Menjalankan Aplikasi

### 1. Pastikan XAMPP Berjalan
- Buka **XAMPP Control Panel**
- Start **Apache** (harus hijau)
- Start **MySQL** (harus hijau)

### 2. Periksa Database
- Buka **phpMyAdmin**: http://localhost/phpmyadmin
- Pastikan database **`spm_db`** sudah ada
- Jika belum ada, buat database baru dengan nama `spm_db`
- Import file SQL jika ada (cek folder `database/`)

### 3. Update Konfigurasi .env
Jalankan script perbaikan:
```bash
php fix_local_setup.php
```

Atau manual update file `.env`:
```env
APP_ENV=local
APP_DEBUG=true
APP_URL=http://localhost

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=spm_db
DB_USERNAME=root
DB_PASSWORD=
```

### 4. Clear Cache (Jika Perlu)
```bash
php artisan config:clear
php artisan route:clear
php artisan view:clear
php artisan cache:clear
```

### 5. Generate Application Key (Jika Perlu)
```bash
php artisan key:generate
```

### 6. Jalankan Migrasi Database (Jika Perlu)
```bash
php artisan migrate
```

### 7. Akses Aplikasi

**Opsi 1: Via XAMPP (Recommended)**
```
http://localhost/Spm1/public
```

**Opsi 2: Via Artisan Serve**
```bash
php artisan serve
```
Kemudian akses: http://localhost:8000

## 🔧 Troubleshooting

### Error: Route [kontak] not defined
**Solusi:** Sudah diperbaiki dengan clear route cache

### Error: Database connection failed
**Solusi:**
1. Pastikan MySQL XAMPP running
2. Cek konfigurasi DB_HOST di `.env` (gunakan `localhost`)
3. Pastikan database `spm_db` ada di phpMyAdmin
4. Cek username/password database

### Error: Permission denied
**Solusi:**
```bash
# Windows (PowerShell as Administrator)
icacls storage /grant Users:F /T
icacls bootstrap\cache /grant Users:F /T
```

### Error: 500 Internal Server Error
**Solusi:**
1. Set `APP_DEBUG=true` di `.env`
2. Cek file `storage/logs/laravel.log` untuk detail error
3. Pastikan semua cache sudah di-clear

### Error: Class not found
**Solusi:**
```bash
composer dump-autoload
```

## 📝 Checklist

- [ ] XAMPP Apache running
- [ ] XAMPP MySQL running  
- [ ] Database `spm_db` sudah ada
- [ ] File `.env` sudah dikonfigurasi dengan benar
- [ ] Cache sudah dibersihkan
- [ ] Folder `storage/` dan `bootstrap/cache/` bisa di-write
- [ ] Aplikasi bisa diakses di browser

## 🆘 Masih Error?

Jika masih ada masalah, cek:
1. File log: `storage/logs/laravel.log`
2. Error di browser (aktifkan `APP_DEBUG=true`)
3. Pastikan PHP version >= 8.2
4. Pastikan semua extension PHP yang diperlukan sudah aktif

## 📞 Informasi Tambahan

- **Framework:** Laravel 12.0
- **PHP Version:** ^8.2
- **Database:** MySQL (via XAMPP)
- **Web Server:** Apache (XAMPP) atau PHP Built-in Server

