<?php

namespace App\Http\Controllers;

use App\Models\Article;
use App\Models\Profile;
use App\Models\Document;
use App\Models\Service;
use Illuminate\Http\Request;

class BpmController extends Controller
{
    public function home()
    {
        return view('pages.home', [
            'title' => 'Beranda - BADAN PENJAMINAN MUTU'
        ]);
    }

    public function profil()
    {
        // Redirect to first active profile or show general profile page
        $firstActiveProfile = Profile::active()->ordered()->first();

        if ($firstActiveProfile) {
            return redirect()->route('profile.show', $firstActiveProfile->slug);
        }

        // Fallback to default profile page if no active profiles
        return view('pages.profil', [
            'title' => 'Profil - BADAN PENJAMINAN MUTU'
        ]);
    }

    public function showProfile($slug)
    {
        $profile = Profile::where('slug', $slug)->where('is_active', true)->first();

        if (!$profile) {
            abort(404);
        }

        return view('pages.profile-detail', [
            'title' => $profile->title . ' - BADAN PENJAMINAN MUTU',
            'profile' => $profile
        ]);
    }

    public function layanan()
    {
        $services = Service::active()->ordered()->get();

        return view('pages.layanan', [
            'title' => 'Layanan - BADAN PENJAMINAN MUTU',
            'services' => $services
        ]);
    }

    public function artikel()
    {
        return view('pages.artikel', [
            'title' => 'Artikel - BADAN PENJAMINAN MUTU'
        ]);
    }

    public function download()
    {
        // Get active documents grouped by category
        $documents = Document::active()
            ->orderBy('category')
            ->orderBy('title')
            ->get()
            ->groupBy('category');

        return view('pages.download', [
            'title' => 'Download Dokumen - BADAN PENJAMINAN MUTU',
            'documents' => $documents
        ]);
    }

    public function dokumenMutu()
    {
        // Get all active documents grouped by category
        $documents = Document::active()
            ->orderBy('category')
            ->orderBy('title')
            ->get()
            ->groupBy('category');

        return view('pages.download', [
            'title' => 'Dokumen SPM - BADAN PENJAMINAN MUTU ATK',
            'documents' => $documents,
            'showAllCategories' => true
        ]);
    }

    public function akreditasi()
    {
        return view('pages.akreditasi', [
            'title' => 'Akreditasi - BADAN PENJAMINAN MUTU'
        ]);
    }

    public function peraturan()
    {
        return view('pages.peraturan', [
            'title' => 'Peraturan-Peraturan - BADAN PENJAMINAN MUTU'
        ]);
    }

    public function kontak()
    {
        return view('pages.kontak', [
            'title' => 'Kontak Kami - BADAN PENJAMINAN MUTU'
        ]);
    }

    public function pernyataanMutu()
    {
        // Get profile data from database
        $profile = Profile::where('slug', 'pernyataan-mutu')->first();

        if (!$profile) {
            // Fallback to default if not found in database
            return view('pages.pernyataan-mutu', [
                'title' => 'Pernyataan Mutu dan Kebijakan Mutu - BADAN PENJAMINAN MUTU'
            ]);
        }

        return view('pages.profile-detail', [
            'title' => $profile->title . ' - BADAN PENJAMINAN MUTU',
            'profile' => $profile
        ]);
    }

    public function showArticle($slug)
    {
        $article = Article::where('slug', $slug)->where('is_active', true)->first();

        if (!$article) {
            abort(404);
        }

        return view('pages.article-detail', [
            'title' => $article->title . ' - ARTIKEL & BERITA',
            'article' => $article
        ]);
    }
}
