<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('services', function (Blueprint $table) {
            $table->id();
            $table->string('title'); // judul layanan
            $table->string('slug')->unique(); // slug untuk URL
            $table->text('description'); // deskripsi layanan
            $table->string('icon')->nullable(); // emoji atau class icon
            $table->json('features')->nullable(); // array fitur-fitur layanan
            $table->integer('sort_order')->default(0); // urutan tampilan
            $table->boolean('is_active')->default(true); // status aktif
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
