<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    use WithoutModelEvents;

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User::factory(10)->create();

        User::factory()->create([
            'name' => 'Test User',
            'email' => 'test@example.com',
        ]);

        // Seed admin user
        $this->call([
            AdminUserSeeder::class,
        ]);

        // Seed profiles, articles, documents, and services
        $this->call([
            ProfileSeeder::class,
            ArticleSeeder::class,
            DocumentSeeder::class,
            ServiceSeeder::class,
        ]);
    }
}
