<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Profile;

class ProfileSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $profiles = [
            [
                'title' => 'Tentang Badan Penjaminan Mutu UII',
                'slug' => 'tentang-bpm-uii',
                'category' => 'tentang-bpm',
                'excerpt' => 'Badan Penjaminan Mutu Universitas Islam Indonesia (BPM UII) adalah unit yang bertanggung jawab atas penjaminan mutu akademik.',
                'content' => '<p>Badan Penjaminan Mutu Universitas Islam Indonesia (BPM UII) merupakan unit yang bertanggung jawab atas penjaminan mutu akademik di lingkungan Universitas Islam Indonesia. BPM UII didirikan dengan tujuan untuk menjamin dan meningkatkan mutu pendidikan tinggi melalui sistem penjaminan mutu yang komprehensif.</p>

                <p>Visi BPM UII adalah menjadi pusat unggulan penjaminan mutu pendidikan tinggi yang berbasis Islamic values dan berkontribusi pada pengembangan pendidikan tinggi nasional.</p>

                <p>Misi BPM UII:</p>
                <ul>
                    <li>Mengembangkan dan mengimplementasikan Sistem Penjaminan Mutu Internal (SPMI)</li>
                    <li>Melakukan audit dan evaluasi mutu akademik</li>
                    <li>Menyediakan pelatihan dan pendampingan mutu</li>
                    <li>Melakukan benchmarking dan studi banding mutu</li>
                </ul>',
                'order' => 1,
                'is_active' => true,
            ],
            [
                'title' => 'Pernyataan Mutu',
                'slug' => 'pernyataan-mutu',
                'category' => 'pernyataan-mutu',
                'excerpt' => 'Pernyataan komitmen Badan Penjaminan Mutu UII terhadap standar mutu yang tinggi.',
                'content' => '<p>Badan Penjaminan Mutu Universitas Islam Indonesia berkomitmen untuk:</p>

                <ol>
                    <li>Menyelenggarakan proses penjaminan mutu yang transparan, akuntabel, dan berkelanjutan</li>
                    <li>Menerapkan standar mutu yang sesuai dengan prinsip-prinsip Islamic values</li>
                    <li>Melakukan perbaikan berkelanjutan berdasarkan hasil evaluasi dan audit mutu</li>
                    <li>Menyediakan layanan prima kepada stakeholder internal dan eksternal</li>
                    <li>Mengembangkan kompetensi sumber daya manusia di bidang penjaminan mutu</li>
                </ol>

                <p>Pernyataan mutu ini menjadi pedoman bagi seluruh aktivitas BPM UII dalam menjalankan tugas dan fungsinya.</p>',
                'order' => 2,
                'is_active' => true,
            ],
            [
                'title' => 'Tujuan dan Peranan',
                'slug' => 'tujuan-dan-peranan',
                'category' => 'tujuan-peranan',
                'excerpt' => 'Tujuan dan peranan strategis Badan Penjaminan Mutu dalam pengembangan pendidikan tinggi.',
                'content' => '<h3>Tujuan BPM UII</h3>
                <ul>
                    <li>Memastikan terlaksananya SPMI yang efektif dan efisien</li>
                    <li>Meningkatkan mutu akademik secara berkelanjutan</li>
                    <li>Menjadi rujukan nasional dalam penjaminan mutu pendidikan tinggi</li>
                    <li>Mendorong budaya mutu di seluruh civitas akademika UII</li>
                </ul>

                <h3>Peranan BPM UII</h3>
                <ol>
                    <li>Sebagai fasilitator pengembangan sistem penjaminan mutu</li>
                    <li>Sebagai konsultan mutu bagi unit-unit di UII</li>
                    <li>Sebagai auditor internal untuk memastikan kepatuhan terhadap standar mutu</li>
                    <li>Sebagai penghubung antara UII dengan stakeholder eksternal</li>
                </ol>',
                'order' => 3,
                'is_active' => true,
            ],
            [
                'title' => 'Status dan Kedudukan',
                'slug' => 'status-dan-kedudukan',
                'category' => 'status-kedudukan',
                'excerpt' => 'Status dan kedudukan Badan Penjaminan Mutu dalam struktur organisasi Universitas Islam Indonesia.',
                'content' => '<p>Badan Penjaminan Mutu Universitas Islam Indonesia (BPM UII) merupakan unit kerja yang bersifat independen dan bertanggung jawab langsung kepada Rektor Universitas Islam Indonesia.</p>

                <h3>Status Organisasi</h3>
                <ul>
                    <li>Unit kerja non-akademik</li>
                    <li>Bertanggung jawab langsung kepada Rektor</li>
                    <li>Memiliki kewenangan untuk melakukan audit mutu</li>
                    <li>Bekerja sama dengan seluruh unit di lingkungan UII</li>
                </ul>

                <h3>Kedudukan dalam Struktur</h3>
                <p>BPM UII menempati posisi strategis dalam struktur organisasi UII sebagai unit yang mengkoordinasikan dan memfasilitasi implementasi sistem penjaminan mutu secara menyeluruh.</p>',
                'order' => 4,
                'is_active' => true,
            ],
            [
                'title' => 'SPM UII',
                'slug' => 'spm-uii',
                'category' => 'spm-uii',
                'excerpt' => 'Sistem Penjaminan Mutu Universitas Islam Indonesia yang terintegrasi.',
                'content' => '<p>Sistem Penjaminan Mutu Universitas Islam Indonesia (SPM UII) merupakan sistem terintegrasi yang mencakup seluruh aspek penjaminan mutu di lingkungan UII.</p>

                <h3>Komponen SPM UII</h3>
                <ol>
                    <li>Perencanaan Mutu</li>
                    <li>Pengendalian Mutu</li>
                    <li>Penjaminan Mutu</li>
                    <li>Peningkatan Mutu</li>
                    <li>Audit Mutu</li>
                </ol>

                <h3>Prinsip SPM UII</h3>
                <ul>
                    <li>Berbasis Islamic values</li>
                    <li>Orientasi pada stakeholders</li>
                    <li>Kontinuitas perbaikan</li>
                    <li>Transparansi dan akuntabilitas</li>
                </ul>',
                'order' => 5,
                'is_active' => true,
            ],
            [
                'title' => 'Sejarah Standar SPMI UII "MERCY OF GOD"',
                'slug' => 'sejarah-standar-spmi-uii-mercy-of-god',
                'category' => 'sejarah-mercy',
                'excerpt' => 'Sejarah pengembangan standar Sistem Penjaminan Mutu Internal UII dengan tema "Mercy of God".',
                'content' => '<p>Standar SPMI UII "MERCY OF GOD" merupakan hasil pengembangan sistem penjaminan mutu yang mengintegrasikan nilai-nilai Islam dengan standar mutu internasional.</p>

                <h3>Latar Belakang</h3>
                <p>Standar ini dikembangkan sebagai respon terhadap kebutuhan akan sistem penjaminan mutu yang tidak hanya memenuhi standar nasional dan internasional, tetapi juga mencerminkan identitas UII sebagai universitas Islam.</p>

                <h3>Makna "MERCY OF GOD"</h3>
                <ul>
                    <li><strong>M</strong> - Mutu (Quality)</li>
                    <li><strong>E</strong> - Excellent (Unggul)</li>
                    <li><strong>R</strong> - Rahmatan lil alamin (Rahmat untuk semesta)</li>
                    <li><strong>C</strong> - Continuous (Berkelanjutan)</li>
                    <li><strong>Y</strong> - Yield (Hasil)</li>
                    <li><strong>O</strong> - Outstanding (Istimewa)</li>
                    <li><strong>F</strong> - Faithful (Setia)</li>
                    <li><strong>G</strong> - God (Tuhan)</li>
                    <li><strong>O</strong> - Oriented (Berorientasi)</li>
                    <li><strong>D</strong> - Development (Pengembangan)</li>
                </ul>

                <p>Standar ini menjadi acuan bagi seluruh aktivitas penjaminan mutu di UII.</p>',
                'order' => 6,
                'is_active' => true,
            ],
        ];

        foreach ($profiles as $profile) {
            Profile::create($profile);
        }
    }
}
