<?php

namespace Database\Seeders;

use App\Models\Service;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ServiceSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $services = [
            [
                'title' => 'Sertifikasi Mutu',
                'slug' => 'sertifikasi-mutu',
                'description' => 'Layanan sertifikasi untuk memastikan produk dan layanan Anda memenuhi standar mutu yang telah ditetapkan.',
                'icon' => '✓',
                'features' => [
                    '• Sertifikasi ISO 9001',
                    '• Sertifikasi Produk',
                    '• Sertifikasi Jasa'
                ],
                'sort_order' => 1,
                'is_active' => true,
            ],
            [
                'title' => 'Akreditasi Lembaga',
                'slug' => 'akreditasi-lembaga',
                'description' => 'Proses akreditasi untuk lembaga pendidikan, kesehatan, dan industri untuk memastikan standar operasional yang tinggi.',
                'icon' => '🏛️',
                'features' => [
                    '• Akreditasi Sekolah',
                    '• Akreditasi Rumah Sakit',
                    '• Akreditasi Laboratorium'
                ],
                'sort_order' => 2,
                'is_active' => true,
            ],
            [
                'title' => 'Audit dan Pengawasan',
                'slug' => 'audit-dan-pengawasan',
                'description' => 'Layanan audit berkala dan pengawasan untuk memastikan kepatuhan terhadap standar mutu yang berlaku.',
                'icon' => '📊',
                'features' => [
                    '• Audit Internal',
                    '• Audit Eksternal',
                    '• Monitoring Berkala'
                ],
                'sort_order' => 3,
                'is_active' => true,
            ],
            [
                'title' => 'Pelatihan dan Konsultasi',
                'slug' => 'pelatihan-dan-konsultasi',
                'description' => 'Program pelatihan dan konsultasi untuk meningkatkan pemahaman dan implementasi sistem manajemen mutu.',
                'icon' => '🎓',
                'features' => [
                    '• Workshop Mutu',
                    '• Konsultasi Sistem',
                    '• Pelatihan Auditor'
                ],
                'sort_order' => 4,
                'is_active' => true,
            ],
        ];

        foreach ($services as $service) {
            Service::create($service);
        }
    }
}
