<?php
echo "<h1>🔐 CHECK AUTHENTICATION SYSTEM</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;font-size:14px;} .success{color:green;font-weight:bold;} .error{color:red;font-weight:bold;} .warning{color:orange;font-weight:bold;} .info{color:blue;} table{border-collapse:collapse;width:100%;margin:10px 0;} th,td{border:1px solid #ddd;padding:8px;text-align:left;} th{background:#f2f2f2;}</style>";

// Initialize Laravel
try {
    require_once '../vendor/autoload.php';
    $app = require_once '../bootstrap/app.php';
    $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
    $kernel->bootstrap();
} catch (Exception $e) {
    echo "<p class='error'>❌ Laravel initialization failed: " . $e->getMessage() . "</p>";
    exit;
}

echo "<h2>1. Database Tables Check</h2>";
$tables = ['users', 'password_resets', 'migrations'];
foreach ($tables as $table) {
    try {
        $count = DB::table($table)->count();
        echo "<p class='success'>✅ Table '$table' exists with $count records</p>";
    } catch (Exception $e) {
        echo "<p class='error'>❌ Table '$table' error: " . $e->getMessage() . "</p>";
    }
}

echo "<h2>2. Users Table Analysis</h2>";
try {
    $users = DB::table('users')->get();

    if ($users->count() > 0) {
        echo "<p class='success'>✅ Found {$users->count()} users in database</p>";

        echo "<table>";
        echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Email Verified</th><th>Created</th></tr>";

        foreach ($users as $user) {
            $role = isset($user->role) ? $user->role : 'N/A';
            $verified = isset($user->email_verified_at) && $user->email_verified_at ? '✅' : '❌';
            echo "<tr>";
            echo "<td>{$user->id}</td>";
            echo "<td>{$user->name}</td>";
            echo "<td>{$user->email}</td>";
            echo "<td>$role</td>";
            echo "<td>$verified</td>";
            echo "<td>{$user->created_at}</td>";
            echo "</tr>";
        }
        echo "</table>";

        // Check for admin users
        $adminUsers = DB::table('users')->where('role', 'admin')->orWhere('role', 'super_admin')->get();
        if ($adminUsers->count() > 0) {
            echo "<p class='success'>✅ Found {$adminUsers->count()} admin users</p>";
        } else {
            echo "<p class='warning'>⚠️ No admin users found</p>";
        }

    } else {
        echo "<p class='error'>❌ No users found in database</p>";
        echo "<div style='background:#fff3cd;padding:15px;border-radius:8px;margin:10px 0;border:1px solid #ffeaa7;'>";
        echo "<h3>🔧 Create Admin User</h3>";
        echo "<p>You need to create an admin user first. Run this SQL in phpMyAdmin:</p>";
        echo "<pre style='background:#f8f9fa;padding:10px;border-radius:4px;'>";
        echo "INSERT INTO users (name, email, password, role, created_at, updated_at) VALUES
('Admin', 'admin@spm.com', '" . password_hash('password123', PASSWORD_DEFAULT) . "', 'super_admin', NOW(), NOW());";
        echo "</pre>";
        echo "<p><strong>Login credentials:</strong></p>";
        echo "<ul>";
        echo "<li>Email: admin@spm.com</li>";
        echo "<li>Password: password123</li>";
        echo "</ul>";
        echo "</div>";
    }

} catch (Exception $e) {
    echo "<p class='error'>❌ Users table error: " . $e->getMessage() . "</p>";
}

echo "<h2>3. Authentication Configuration</h2>";
try {
    $authConfig = config('auth');
    echo "<p class='success'>✅ Auth config loaded</p>";
    echo "<p><strong>Guard:</strong> {$authConfig['defaults']['guard']}</p>";
    echo "<p><strong>Provider:</strong> {$authConfig['defaults']['passwords']}</p>";

    $guards = config('auth.guards');
    if (isset($guards['web'])) {
        echo "<p class='success'>✅ Web guard configured</p>";
    }

} catch (Exception $e) {
    echo "<p class='error'>❌ Auth config error: " . $e->getMessage() . "</p>";
}

echo "<h2>4. Session Configuration</h2>";
try {
    $sessionConfig = config('session');
    echo "<p class='success'>✅ Session config loaded</p>";
    echo "<p><strong>Driver:</strong> {$sessionConfig['driver']}</p>";
    echo "<p><strong>Lifetime:</strong> {$sessionConfig['lifetime']} minutes</p>";
    echo "<p><strong>Path:</strong> {$sessionConfig['path']}</p>";

    // Check session directory
    $sessionPath = storage_path('framework/sessions');
    if (is_writable($sessionPath)) {
        echo "<p class='success'>✅ Session directory writable</p>";
    } else {
        echo "<p class='error'>❌ Session directory not writable</p>";
    }

} catch (Exception $e) {
    echo "<p class='error'>❌ Session config error: " . $e->getMessage() . "</p>";
}

echo "<h2>5. Test Login Simulation</h2>";
if ($users->count() > 0) {
    $firstUser = $users->first();

    echo "<p class='info'>Testing login simulation with user: {$firstUser->email}</p>";

    try {
        // Test password verification
        $passwordValid = password_verify('password123', $firstUser->password);
        if ($passwordValid) {
            echo "<p class='success'>✅ Password 'password123' is valid for {$firstUser->email}</p>";
        } else {
            echo "<p class='warning'>⚠️ Password 'password123' is NOT valid for {$firstUser->email}</p>";
            echo "<p class='info'>User's password hash: " . substr($firstUser->password, 0, 20) . "...</p>";
        }

        // Test Laravel authentication
        $authAttempt = auth()->attempt([
            'email' => $firstUser->email,
            'password' => 'password123'
        ]);

        if ($authAttempt) {
            echo "<p class='success'>✅ Laravel authentication successful</p>";
            auth()->logout(); // Clean up
        } else {
            echo "<p class='error'>❌ Laravel authentication failed</p>";
        }

    } catch (Exception $e) {
        echo "<p class='error'>❌ Login test error: " . $e->getMessage() . "</p>";
    }

} else {
    echo "<p class='warning'>⚠️ No users to test login</p>";
}

echo "<h2>6. Migration Status</h2>";
try {
    $migrations = DB::table('migrations')->orderBy('id')->get();

    if ($migrations->count() > 0) {
        echo "<p class='success'>✅ Found {$migrations->count()} completed migrations</p>";

        echo "<div style='max-height:200px;overflow:auto;'>";
        echo "<table>";
        echo "<tr><th>ID</th><th>Migration</th><th>Batch</th></tr>";

        foreach ($migrations as $migration) {
            echo "<tr>";
            echo "<td>{$migration->id}</td>";
            echo "<td>{$migration->migration}</td>";
            echo "<td>{$migration->batch}</td>";
            echo "</tr>";
        }
        echo "</table>";
        echo "</div>";

    } else {
        echo "<p class='error'>❌ No migrations found - database not properly set up</p>";
    }

} catch (Exception $e) {
    echo "<p class='error'>❌ Migration check error: " . $e->getMessage() . "</p>";
}

echo "<h2>🎯 RECOMMENDATIONS</h2>";
echo "<div style='background:#e8f4f8;padding:15px;border-radius:8px;margin:10px 0;'>";

if ($users->count() === 0) {
    echo "<h3>🚨 CRITICAL: No Users Found</h3>";
    echo "<p>You must create at least one admin user. Use the SQL provided above in phpMyAdmin.</p>";
} elseif ($adminUsers->count() === 0) {
    echo "<h3>⚠️ WARNING: No Admin Users</h3>";
    echo "<p>Create an admin user or update existing user role to 'admin' or 'super_admin'.</p>";
} else {
    echo "<h3>✅ SYSTEM READY</h3>";
    echo "<p>Authentication system is properly configured. Try logging in with admin credentials.</p>";
}

echo "<h4>Quick SQL to Create Admin User:</h4>";
echo "<pre style='background:#f8f9fa;padding:10px;border-radius:4px;'>";
echo "INSERT INTO users (name, email, password, role, email_verified_at, created_at, updated_at) VALUES
('Administrator', 'admin@spm.com', '\$2y\$10\$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'super_admin', NOW(), NOW(), NOW());";
echo "</pre>";
echo "<p><strong>Login:</strong> admin@spm.com | <strong>Password:</strong> password</p>";

echo "</div>";

echo "<hr>";
echo "<p><strong>Auth check completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?>
