<?php
echo "<h1>📋 Check Laravel Logs</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;font-size:14px;} .error{color:red;font-weight:bold;} .success{color:green;font-weight:bold;} .warning{color:orange;font-weight:bold;} .info{color:blue;} pre{background:#f5f5f5;padding:10px;border-radius:4px;margin:10px 0;max-height:400px;overflow:auto;}</style>";

$logFile = '../storage/logs/laravel.log';

echo "<h2>Laravel Log File</h2>";
echo "<p><strong>Log file location:</strong> $logFile</p>";

if (file_exists($logFile)) {
    echo "<p class='success'>✅ Laravel log file exists</p>";

    $fileSize = filesize($logFile);
    echo "<p><strong>File size:</strong> " . number_format($fileSize) . " bytes</p>";

    if ($fileSize > 0) {
        $logContent = file_get_contents($logFile);

        // Get last 50 lines or last 10KB
        $lines = explode("\n", $logContent);
        $totalLines = count($lines);
        echo "<p><strong>Total log lines:</strong> $totalLines</p>";

        // Show recent errors
        $recentLines = array_slice($lines, -50);
        $recentContent = implode("\n", $recentLines);

        echo "<h3>Recent Log Entries (Last 50 lines)</h3>";
        echo "<pre>$recentContent</pre>";

        // Look for common errors
        echo "<h3>Error Analysis</h3>";

        $errors = [];
        if (strpos($logContent, 'No connection could be made') !== false) {
            $errors[] = "Database connection refused";
        }
        if (strpos($logContent, 'Class') !== false && strpos($logContent, 'not found') !== false) {
            $errors[] = "Missing class/autoload issue";
        }
        if (strpos($logContent, 'Permission denied') !== false) {
            $errors[] = "File permission issue";
        }
        if (strpos($logContent, 'syntax error') !== false) {
            $errors[] = "PHP syntax error";
        }
        if (strpos($logContent, 'Allowed memory size') !== false) {
            $errors[] = "Memory limit exceeded";
        }

        if (!empty($errors)) {
            echo "<div style='background:#f8d7da;padding:15px;border-radius:8px;margin:10px 0;border:1px solid #f5c6cb;'>";
            echo "<h4 style='color:#721c24;'>🔍 Detected Issues:</h4>";
            echo "<ul>";
            foreach ($errors as $error) {
                echo "<li style='color:#721c24;'>$error</li>";
            }
            echo "</ul>";
            echo "</div>";
        } else {
            echo "<p class='success'>✅ No common errors detected in logs</p>";
        }

    } else {
        echo "<p class='info'>ℹ️ Log file is empty (no errors logged yet)</p>";
    }

} else {
    echo "<p class='warning'>⚠️ Laravel log file does not exist</p>";
    echo "<p class='info'>This might be normal if no errors have occurred, or the storage/logs directory might not be writable.</p>";
}

// Check if we can write to log file
echo "<h2>Log File Writability Test</h2>";
$logDir = dirname($logFile);
if (is_writable($logDir)) {
    echo "<p class='success'>✅ Log directory is writable</p>";

    // Try to write a test entry
    $testMessage = "[" . date('Y-m-d H:i:s') . "] testing.INFO: Test log entry from debug script";
    if (file_put_contents($logFile, $testMessage . "\n", FILE_APPEND)) {
        echo "<p class='success'>✅ Successfully wrote test log entry</p>";
    } else {
        echo "<p class='error'>❌ Failed to write to log file</p>";
    }
} else {
    echo "<p class='error'>❌ Log directory is NOT writable</p>";
}

echo "<h2>PHP Error Log</h2>";
$phpErrorLog = ini_get('error_log');
if ($phpErrorLog) {
    echo "<p><strong>PHP Error Log:</strong> $phpErrorLog</p>";
    if (file_exists($phpErrorLog)) {
        $phpLogSize = filesize($phpErrorLog);
        echo "<p><strong>PHP Log Size:</strong> " . number_format($phpLogSize) . " bytes</p>";

        if ($phpLogSize > 0 && $phpLogSize < 100000) { // Only show if reasonable size
            $phpLogContent = file_get_contents($phpErrorLog);
            $phpLines = explode("\n", $phpLogContent);
            $recentPhpLines = array_slice($phpLines, -10);
            echo "<h4>Recent PHP Errors (Last 10 lines)</h4>";
            echo "<pre>" . implode("\n", $recentPhpLines) . "</pre>";
        }
    } else {
        echo "<p class='info'>PHP error log file does not exist</p>";
    }
} else {
    echo "<p class='info'>PHP error logging not configured</p>";
}

echo "<h2>Quick Actions</h2>";
echo "<div style='background:#e8f4f8;padding:15px;border-radius:8px;margin:10px 0;'>";
echo "<p><a href='clear_all_cache.php' style='color:#007bff;'>🧹 Clear All Cache</a> | ";
echo "<a href='debug_db_laravel.php' style='color:#007bff;'>🔍 Debug Database</a> | ";
echo "<a href='debug_500.php' style='color:#007bff;'>🔧 Full Debug</a></p>";
echo "</div>";

echo "<hr>";
echo "<p><strong>Log check completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?>
