<?php
echo "<h1>🧹 Clear All Laravel Caches</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .success{color:green;font-weight:bold;} .error{color:red;font-weight:bold;} .warning{color:orange;font-weight:bold;} .info{color:blue;}</style>";

echo "<h2>Clearing Laravel Caches</h2>";

$cacheCommands = [
    'config:clear' => 'Configuration cache',
    'cache:clear' => 'Application cache',
    'route:clear' => 'Route cache',
    'view:clear' => 'Compiled views',
    'config:cache' => 'Configuration cache (rebuild)',
    'route:cache' => 'Route cache (rebuild)',
    'view:cache' => 'Compiled views (rebuild)'
];

foreach ($cacheCommands as $command => $description) {
    echo "<h3>$description</h3>";
    echo "<p class='info'>Running: php artisan $command</p>";

    $output = shell_exec("cd ../ && php artisan $command 2>&1");

    if ($output === null) {
        echo "<p class='error'>❌ Command failed to execute</p>";
    } else {
        // Check for success indicators
        $success = false;
        if (strpos($output, 'successfully') !== false ||
            strpos($output, 'cleared') !== false ||
            strpos($output, 'cached') !== false ||
            strpos($output, 'compiled') !== false ||
            strpos($output, 'Configuration cached successfully') !== false) {
            $success = true;
        }

        if ($success) {
            echo "<p class='success'>✅ $description cleared successfully</p>";
        } else {
            echo "<p class='warning'>⚠️ $description completed with warnings</p>";
        }

        // Show output if it's not too long
        if (strlen($output) < 500) {
            echo "<pre style='background:#f8f9fa;padding:10px;border-radius:4px;margin:5px 0;'>$output</pre>";
        } else {
            echo "<p class='info'>Output too long, showing first 200 characters:</p>";
            echo "<pre style='background:#f8f9fa;padding:10px;border-radius:4px;margin:5px 0;'>" . substr($output, 0, 200) . "...</pre>";
        }
    }
}

echo "<h2>Manual Cache Clearing</h2>";

// Clear bootstrap/cache files
$bootstrapCache = '../bootstrap/cache';
if (is_dir($bootstrapCache)) {
    $files = glob($bootstrapCache . '/*.php');
    $cleared = 0;
    foreach ($files as $file) {
        if (unlink($file)) {
            $cleared++;
        }
    }
    echo "<p class='success'>✅ Cleared $cleared files from bootstrap/cache</p>";
}

// Clear storage/framework files
$storageDirs = [
    '../storage/framework/cache',
    '../storage/framework/sessions',
    '../storage/framework/views'
];

foreach ($storageDirs as $dir) {
    if (is_dir($dir)) {
        $files = glob($dir . '/*');
        $cleared = 0;
        foreach ($files as $file) {
            if (is_file($file) && basename($file) !== '.gitkeep') {
                if (unlink($file)) {
                    $cleared++;
                }
            }
        }
        echo "<p class='success'>✅ Cleared $cleared files from " . basename($dir) . "</p>";
    }
}

echo "<h2>Final Test</h2>";
try {
    require_once '../vendor/autoload.php';
    $app = require_once '../bootstrap/app.php';
    $app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

    echo "<p class='success'>✅ Laravel bootstrap successful after cache clearing</p>";

    $pdo = DB::connection('mysql')->getPdo();
    echo "<p class='success'>✅ Database connection still working</p>";

} catch (Exception $e) {
    echo "<p class='error'>❌ Laravel bootstrap failed: " . $e->getMessage() . "</p>";
}

echo "<h2>Next Steps</h2>";
echo "<div style='background:#d4edda;padding:15px;border-radius:8px;margin:10px 0;border:1px solid #c3e6cb;'>";
echo "<p class='success'>All caches have been cleared!</p>";
echo "<p><strong>Now try accessing your Laravel application:</strong></p>";
echo "<p><a href='http://192.168.10.70' target='_blank' style='color:#155724;font-weight:bold;'>http://192.168.10.70</a></p>";
echo "</div>";

echo "<p><a href='debug_500.php'>← Back to Debug Page</a></p>";
?>
