<?php
echo "<h1>🔍 DEBUG LARAVEL DATABASE CONNECTION</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;font-size:14px;} .error{color:red;font-weight:bold;} .success{color:green;font-weight:bold;} .warning{color:orange;font-weight:bold;} .info{color:blue;} pre{background:#f5f5f5;padding:10px;border-radius:4px;margin:10px 0;max-height:200px;overflow:auto;}</style>";

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Step 1: Direct PHP MySQL Test</h2>";
try {
    $pdo = new PDO('mysql:host=localhost;dbname=spm_db;charset=utf8', 'root', '');
    echo "<p class='success'>✅ Direct PHP MySQL connection successful</p>";

    $stmt = $pdo->query("SELECT COUNT(*) as total FROM profiles");
    $result = $stmt->fetch();
    echo "<p class='success'>✅ Query successful: {$result['total']} profiles</p>";

    $pdo = null; // Close connection
} catch (Exception $e) {
    echo "<p class='error'>❌ Direct PHP MySQL failed: " . $e->getMessage() . "</p>";
    exit;
}

echo "<h2>Step 2: PDO Extension Check</h2>";
if (extension_loaded('pdo_mysql')) {
    echo "<p class='success'>✅ PDO MySQL extension loaded</p>";
} else {
    echo "<p class='error'>❌ PDO MySQL extension NOT loaded</p>";
    exit;
}

echo "<h2>Step 3: Laravel Autoload Test</h2>";
try {
    require_once '../vendor/autoload.php';
    echo "<p class='success'>✅ Composer autoload successful</p>";
} catch (Exception $e) {
    echo "<p class='error'>❌ Composer autoload failed: " . $e->getMessage() . "</p>";
    exit;
}

echo "<h2>Step 4: Laravel App Bootstrap Test</h2>";
try {
    $app = require_once '../bootstrap/app.php';
    echo "<p class='success'>✅ Laravel app bootstrap successful</p>";
} catch (Exception $e) {
    echo "<p class='error'>❌ Laravel app bootstrap failed: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
    exit;
}

echo "<h2>Step 5: Laravel Kernel Bootstrap Test</h2>";
try {
    $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
    $kernel->bootstrap();
    echo "<p class='success'>✅ Laravel kernel bootstrap successful</p>";
} catch (Exception $e) {
    echo "<p class='error'>❌ Laravel kernel bootstrap failed: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
    exit;
}

echo "<h2>Step 6: Laravel Database Configuration Check</h2>";
try {
    $dbConfig = config('database.connections.mysql');
    echo "<p class='success'>✅ Database config loaded</p>";
    echo "<pre>";
    print_r($dbConfig);
    echo "</pre>";
} catch (Exception $e) {
    echo "<p class='error'>❌ Database config failed: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
    exit;
}

echo "<h2>Step 7: Laravel DB Connection Test</h2>";
try {
    echo "<p class='info'>Attempting to get PDO connection...</p>";
    $pdo = DB::connection('mysql')->getPdo();
    echo "<p class='success'>✅ Laravel DB connection successful</p>";
} catch (Exception $e) {
    echo "<p class='error'>❌ Laravel DB connection failed: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";

    // Try alternative connection method
    echo "<h3>Attempting Alternative Connection</h3>";
    try {
        $connection = DB::connection('mysql');
        echo "<p class='info'>Connection object created, testing reconnect...</p>";
        $connection->reconnect();
        echo "<p class='success'>✅ Reconnect successful</p>";
    } catch (Exception $e2) {
        echo "<p class='error'>❌ Reconnect also failed: " . $e2->getMessage() . "</p>";
    }
    exit;
}

echo "<h2>Step 8: Laravel Query Test</h2>";
try {
    $users = DB::table('users')->count();
    echo "<p class='success'>✅ Users query successful: $users users</p>";

    $profiles = DB::table('profiles')->count();
    echo "<p class='success'>✅ Profiles query successful: $profiles profiles</p>";

    $articles = DB::table('articles')->count();
    echo "<p class='success'>✅ Articles query successful: $articles articles</p>";

} catch (Exception $e) {
    echo "<p class='error'>❌ Laravel query failed: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
    exit;
}

echo "<h2>🎉 SUCCESS! All Tests Passed</h2>";
echo "<div style='background:#d4edda;padding:15px;border-radius:8px;margin:10px 0;border:1px solid #c3e6cb;'>";
echo "<p class='success'>Laravel database connection is working perfectly!</p>";
echo "<p><strong>Try accessing your application now:</strong></p>";
echo "<p><a href='http://192.168.10.70' target='_blank'>http://192.168.10.70</a></p>";
echo "</div>";

echo "<hr>";
echo "<p><strong>Debug completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?>
