<?php
echo "<h1>🌐 FIX APP_URL CONFIGURATION</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .success{color:green;font-weight:bold;} .error{color:red;font-weight:bold;} .info{color:blue;} code{background:#f5f5f5;padding:2px 4px;border-radius:3px;}</style>";

$envFile = '../.env';
$correctUrl = 'http://192.168.10.70';

echo "<h2>Current APP_URL Status</h2>";

if (file_exists($envFile)) {
    $envContent = file_get_contents($envFile);

    // Find current APP_URL
    if (preg_match('/^APP_URL=(.+)$/m', $envContent, $matches)) {
        $currentUrl = trim($matches[1]);
        echo "<p><strong>Current APP_URL:</strong> <code>$currentUrl</code></p>";

        if ($currentUrl === $correctUrl) {
            echo "<p class='success'>✅ APP_URL is already correct</p>";
        } else {
            echo "<p class='error'>❌ APP_URL is wrong - should be $correctUrl</p>";

            // Fix APP_URL
            $newEnvContent = preg_replace('/^APP_URL=.*/m', "APP_URL=$correctUrl", $envContent);

            if (file_put_contents($envFile, $newEnvContent)) {
                echo "<p class='success'>✅ APP_URL updated to $correctUrl</p>";

                // Clear config cache
                try {
                    require_once '../vendor/autoload.php';
                    $app = require_once '../bootstrap/app.php';
                    $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
                    $kernel->bootstrap();

                    \Illuminate\Support\Facades\Artisan::call('config:clear');
                    echo "<p class='success'>✅ Config cache cleared</p>";
                } catch (Exception $e) {
                    echo "<p class='warning'>⚠️ Could not clear cache: " . $e->getMessage() . "</p>";
                }

                echo "<div style='background:#d4edda;padding:15px;border-radius:8px;margin:20px 0;border:1px solid #c3e6cb;'>";
                echo "<h3 style='color:#155724;'>🎉 APP_URL FIXED!</h3>";
                echo "<p style='color:#155724;'>Route URLs will now generate with the correct host.</p>";
                echo "<p style='color:#155724;'>Login form will submit to the correct URL.</p>";
                echo "</div>";

            } else {
                echo "<p class='error'>❌ Failed to update .env file</p>";
            }
        }

    } else {
        echo "<p class='error'>❌ APP_URL not found in .env</p>";
        echo "<p class='info'>Adding APP_URL...</p>";

        $envContent .= "\nAPP_URL=$correctUrl\n";

        if (file_put_contents($envFile, $envContent)) {
            echo "<p class='success'>✅ APP_URL added to .env</p>";
        } else {
            echo "<p class='error'>❌ Failed to add APP_URL</p>";
        }
    }

} else {
    echo "<p class='error'>❌ .env file not found</p>";
}

echo "<h2>Test Route URL Generation</h2>";
try {
    require_once '../vendor/autoload.php';
    $app = require_once '../bootstrap/app.php';
    $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
    $kernel->bootstrap();

    $homeUrl = route('home');
    $loginUrl = route('login');

    echo "<p><strong>Home route URL:</strong> <code>$homeUrl</code></p>";
    echo "<p><strong>Login route URL:</strong> <code>$loginUrl</code></p>";

    // Parse URLs
    $loginParsed = parse_url($loginUrl);
    $loginHost = $loginParsed['host'] ?? 'none';

    if ($loginHost === '192.168.10.70') {
        echo "<p class='success'>✅ Login URL now uses correct host (192.168.10.70)</p>";
    } else {
        echo "<p class='error'>❌ Login URL still uses wrong host: $loginHost</p>";
    }

} catch (Exception $e) {
    echo "<p class='error'>❌ Route test failed: " . $e->getMessage() . "</p>";
}

echo "<h2>Next Steps</h2>";
echo "<div style='background:#e8f4f8;padding:15px;border-radius:8px;margin:10px 0;'>";
echo "<h3>🔧 TEST LOGIN FORM:</h3>";
echo "<ol>";
echo "<li>Go back to your website: <a href='http://192.168.10.70' target='_blank'>http://192.168.10.70</a></li>";
echo "<li>Try clicking the login button again</li>";
echo "<li>The form should now submit to the correct URL</li>";
echo "</ol>";

echo "<h3>💡 IF STILL 404:</h3>";
echo "<p>Try accessing login page directly: <a href='http://192.168.10.70/login' target='_blank'>http://192.168.10.70/login</a></p>";
echo "<p>Or clear browser cache (Ctrl+F5)</p>";

echo "</div>";

echo "<hr>";
echo "<p><strong>APP_URL fix completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?>
