<?php
echo "<h1>🔐 TEST LOGIN PAGE ACCESS</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .success{color:green;font-weight:bold;} .error{color:red;font-weight:bold;} .info{color:blue;} pre{background:#f5f5f5;padding:10px;border-radius:4px;margin:10px 0;}</style>";

// Initialize Laravel
try {
    require_once '../vendor/autoload.php';
    $app = require_once '../bootstrap/app.php';
    $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
    $kernel->bootstrap();
} catch (Exception $e) {
    echo "<p class='error'>❌ Laravel failed: " . $e->getMessage() . "</p>";
    exit;
}

echo "<h2>1. Test Direct Login URL Access</h2>";

// Test GET /login
try {
    $request = \Illuminate\Http\Request::create('/login', 'GET');
    $response = app(\Illuminate\Contracts\Http\Kernel::class)->handle($request);

    $status = $response->getStatusCode();
    $content = $response->getContent();

    echo "<p><strong>GET /login status:</strong> $status</p>";

    if ($status === 200) {
        echo "<p class='success'>✅ Login page loads successfully</p>";

        // Check if content contains login form
        if (strpos($content, 'login') !== false && strpos($content, 'password') !== false) {
            echo "<p class='success'>✅ Login form found in response</p>";
        }

        // Show first 200 chars
        echo "<p><strong>Response preview:</strong></p>";
        echo "<pre>" . htmlspecialchars(substr($content, 0, 200)) . "...</pre>";

    } elseif ($status === 404) {
        echo "<p class='error'>❌ 404 Not Found - Same error as user experiences</p>";
        echo "<p class='info'>This confirms the routing issue</p>";
    } else {
        echo "<p class='warning'>⚠️ Unexpected status: $status</p>";
    }

} catch (Exception $e) {
    echo "<p class='error'>❌ Request failed: " . $e->getMessage() . "</p>";
}

echo "<h2>2. Check Route Details</h2>";
$router = app('router');
$routes = $router->getRoutes();

$loginRoute = null;
foreach ($routes as $route) {
    if ($route->uri() === 'login' && in_array('GET', $route->methods())) {
        $loginRoute = $route;
        break;
    }
}

if ($loginRoute) {
    echo "<p class='success'>✅ Login route found:</p>";
    echo "<ul>";
    echo "<li><strong>URI:</strong> {$loginRoute->uri()}</li>";
    echo "<li><strong>Methods:</strong> " . implode(', ', $loginRoute->methods()) . "</li>";
    echo "<li><strong>Action:</strong> {$loginRoute->getActionName()}</li>";
    echo "<li><strong>Name:</strong> " . ($loginRoute->getName() ?: 'none') . "</li>";
    echo "</ul>";
} else {
    echo "<p class='error'>❌ GET /login route not found</p>";
}

echo "<h2>3. URL Generation Test</h2>";
try {
    $loginUrl = route('login');
    echo "<p><strong>Generated login URL:</strong> <code>$loginUrl</code></p>";

    // Parse URL
    $parsed = parse_url($loginUrl);
    echo "<p><strong>Scheme:</strong> " . ($parsed['scheme'] ?? 'none') . "</p>";
    echo "<p><strong>Host:</strong> " . ($parsed['host'] ?? 'none') . "</p>";
    echo "<p><strong>Path:</strong> " . ($parsed['path'] ?? 'none') . "</p>";

    // Test if URL is accessible
    $fullUrl = "http://" . ($_SERVER['HTTP_HOST'] ?? 'localhost') . $parsed['path'];
    echo "<p><strong>Full test URL:</strong> <a href='$fullUrl' target='_blank'>$fullUrl</a></p>";

} catch (Exception $e) {
    echo "<p class='error'>❌ URL generation failed: " . $e->getMessage() . "</p>";
}

echo "<h2>4. Browser Test Links</h2>";
echo "<div style='background:#e8f4f8;padding:15px;border-radius:8px;margin:10px 0;'>";
echo "<p><strong>Test these URLs in browser:</strong></p>";
echo "<ul>";
echo "<li><a href='/login' target='_blank'>/login</a> (relative)</li>";
echo "<li><a href='" . route('login') . "' target='_blank'>" . route('login') . "</a> (absolute)</li>";
echo "<li><a href='http://192.168.10.70/login' target='_blank'>http://192.168.10.70/login</a> (direct)</li>";
echo "</ul>";
echo "</div>";

echo "<h2>5. Server Configuration Check</h2>";
echo "<p><strong>Document Root:</strong> " . ($_SERVER['DOCUMENT_ROOT'] ?? 'unknown') . "</p>";
echo "<p><strong>Script Filename:</strong> " . ($_SERVER['SCRIPT_FILENAME'] ?? 'unknown') . "</p>";
echo "<p><strong>Request URI:</strong> " . ($_SERVER['REQUEST_URI'] ?? 'unknown') . "</p>";

// Check if .htaccess exists
$htaccess = '../.htaccess';
if (file_exists($htaccess)) {
    echo "<p class='success'>✅ .htaccess exists</p>";
    $content = file_get_contents($htaccess);
    if (strpos($content, 'RewriteEngine On') !== false) {
        echo "<p class='success'>✅ URL rewriting enabled</p>";
    } else {
        echo "<p class='error'>❌ URL rewriting not enabled in .htaccess</p>";
    }
} else {
    echo "<p class='error'>❌ .htaccess missing</p>";
}

echo "<h2>6. Quick Diagnosis</h2>";

$issues = [];

if ($status === 404) {
    $issues[] = "Route /login returns 404";
}

if (!file_exists($htaccess)) {
    $issues[] = ".htaccess file missing";
}

if (strpos($content ?? '', 'RewriteEngine On') === false) {
    $issues[] = "URL rewriting not enabled";
}

if (isset($parsed['host']) && $parsed['host'] !== $_SERVER['HTTP_HOST']) {
    $issues[] = "Generated URLs use wrong host";
}

echo "<div style='background:" . (empty($issues) ? "#d4edda" : "#f8d7da") . ";padding:15px;border-radius:8px;margin:10px 0;'>";

if (empty($issues)) {
    echo "<h3 style='color:#155724;'>✅ NO ISSUES DETECTED</h3>";
    echo "<p style='color:#155724;'>Login page should work. Try clearing browser cache.</p>";
} else {
    echo "<h3 style='color:#721c24;'>❌ ISSUES FOUND:</h3>";
    echo "<ul style='color:#721c24;'>";
    foreach ($issues as $issue) {
        echo "<li>$issue</li>";
    }
    echo "</ul>";
}

echo "</div>";

echo "<h2>7. Immediate Solutions</h2>";
echo "<div style='background:#fff3cd;padding:15px;border-radius:8px;margin:10px 0;'>";

echo "<h3>🔧 TRY THESE FIXES:</h3>";
echo "<ol>";
echo "<li><strong>Create .htaccess if missing:</strong></li>";
echo "<li>Copy the .htaccess content shown in check_urls.php</li>";
echo "<li><strong>Or try direct access:</strong> <a href='http://192.168.10.70/login' target='_blank'>http://192.168.10.70/login</a></li>";
echo "<li><strong>Check Apache mod_rewrite:</strong> Ensure it's enabled</li>";
echo "</ol>";

echo "<h3>📞 IF STILL 404:</h3>";
echo "<p>The issue is with Apache/URL rewriting, not Laravel routes.</p>";
echo "<p>You may need to:</p>";
echo "<ul>";
echo "<li>Enable mod_rewrite in Apache</li>";
echo "<li>Restart Apache/XAMPP</li>";
echo "<li>Check Apache configuration</li>";
echo "</ul>";

echo "</div>";

echo "<hr>";
echo "<p><strong>Login page test completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?>
