@extends('layouts.admin')

@section('title', 'Kelola Artikel - Admin Panel')

@section('page-title', 'Kelola Artikel')

@section('content')
<div class="breadcrumb">
    <a href="{{ route('admin.dashboard') }}">Dashboard</a>
    <span>/</span>
    <span>Kelola Artikel</span>
</div>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
    <h1 style="color: #0a3d91; font-size: 2rem; margin: 0;">Kelola Artikel & Berita</h1>
    <a href="{{ route('admin.articles.create') }}" style="background: #0a3d91; color: white; padding: 12px 24px; text-decoration: none; border-radius: 8px; font-weight: bold;">
        + Tambah Artikel
    </a>
</div>

        @if(session('success'))
            <div style="background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin-bottom: 20px; border: 1px solid #c3e6cb;">
                {{ session('success') }}
            </div>
        @endif

        <div style="background: white; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); overflow: hidden;">
            <div style="padding: 20px;">
                <table style="width: 100%; border-collapse: collapse;">
                    <thead>
                        <tr style="border-bottom: 2px solid #eee;">
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Judul</th>
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Kategori</th>
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Penulis</th>
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Status</th>
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Diterbitkan</th>
                            <th style="padding: 12px; text-align: center; font-weight: bold; color: #0a3d91;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($articles as $article)
                            <tr style="border-bottom: 1px solid #eee;">
                                <td style="padding: 12px;">
                                    <div style="font-weight: bold; color: #333;">{{ $article->title }}</div>
                                    <div style="font-size: 0.9rem; color: #666; margin-top: 4px;">
                                        {{ Str::limit($article->excerpt, 50) }}
                                    </div>
                                    @if($article->is_featured)
                                        <span style="background: #ffc107; color: #212529; padding: 2px 6px; border-radius: 3px; font-size: 0.8rem; margin-top: 4px; display: inline-block;">
                                            Featured
                                        </span>
                                    @endif
                                </td>
                                <td style="padding: 12px;">
                                    <span style="background: #f8f9fa; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                        {{ $article->category ?? 'Umum' }}
                                    </span>
                                </td>
                                <td style="padding: 12px;">
                                    {{ $article->author ?? 'Anonim' }}
                                </td>
                                <td style="padding: 12px;">
                                    @if($article->is_active)
                                        <span style="background: #d4edda; color: #155724; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                            Aktif
                                        </span>
                                    @else
                                        <span style="background: #f8d7da; color: #721c24; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                            Draft
                                        </span>
                                    @endif
                                </td>
                                <td style="padding: 12px;">
                                    @if($article->published_at)
                                        {{ $article->published_at->format('d M Y') }}
                                    @else
                                        <span style="color: #6c757d; font-style: italic;">Belum diterbitkan</span>
                                    @endif
                                </td>
                                <td style="padding: 12px; text-align: center;">
                                    <div style="display: flex; gap: 8px; justify-content: center;">
                                        <a href="{{ route('admin.articles.show', $article) }}" style="background: #17a2b8; color: white; padding: 6px 12px; text-decoration: none; border-radius: 4px; font-size: 0.9rem;">
                                            Lihat
                                        </a>
                                        <a href="{{ route('admin.articles.edit', $article) }}" style="background: #ffc107; color: #212529; padding: 6px 12px; text-decoration: none; border-radius: 4px; font-size: 0.9rem;">
                                            Edit
                                        </a>
                                        <form action="{{ route('admin.articles.destroy', $article) }}" method="POST" style="display: inline;" onsubmit="return confirm('Apakah Anda yakin ingin menghapus artikel ini?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" style="background: #dc3545; color: white; padding: 6px 12px; border: none; border-radius: 4px; font-size: 0.9rem; cursor: pointer;">
                                                Hapus
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" style="padding: 40px; text-align: center; color: #666;">
                                    Belum ada data artikel.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        @if($articles->hasPages())
            <div style="margin-top: 20px;">
                {{ $articles->links() }}
            </div>
        @endif
@endsection
