@extends('layouts.app')

@section('title', 'Detail Dokumen - Admin Panel')

@section('content')
<div style="padding: 40px 20px; width: 100%;">
    <div style="max-width: 800px; margin: 0 auto;">
        <div style="background: white; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); padding: 30px;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
                <h1 style="color: #0a3d91; font-size: 2rem; margin: 0;">Detail Dokumen</h1>
                <a href="{{ route('admin.documents.index') }}" style="color: #6c757d; text-decoration: none;">
                    ← Kembali
                </a>
            </div>

            <div style="margin-bottom: 30px;">
                <table style="width: 100%; border-collapse: collapse;">
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 15px 0; font-weight: bold; color: #333; width: 200px;">Judul Dokumen:</td>
                        <td style="padding: 15px 0; color: #555;">{{ $document->title }}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 15px 0; font-weight: bold; color: #333;">Deskripsi:</td>
                        <td style="padding: 15px 0; color: #555;">{{ $document->description ?? 'Tidak ada deskripsi' }}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 15px 0; font-weight: bold; color: #333;">Kategori:</td>
                        <td style="padding: 15px 0; color: #555;">
                            <span style="background: #f8f9fa; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                {{ $document->category }}
                            </span>
                        </td>
                    </tr>
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 15px 0; font-weight: bold; color: #333;">Nama File:</td>
                        <td style="padding: 15px 0; color: #555;">{{ $document->file_name }}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 15px 0; font-weight: bold; color: #333;">Ukuran File:</td>
                        <td style="padding: 15px 0; color: #555;">{{ $document->formatted_file_size }}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 15px 0; font-weight: bold; color: #333;">Tipe File:</td>
                        <td style="padding: 15px 0; color: #555;">{{ $document->file_type ?? 'Tidak diketahui' }}</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 15px 0; font-weight: bold; color: #333;">Jumlah Download:</td>
                        <td style="padding: 15px 0; color: #555;">{{ $document->download_count }} kali</td>
                    </tr>
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 15px 0; font-weight: bold; color: #333;">Status:</td>
                        <td style="padding: 15px 0; color: #555;">
                            @if($document->is_active)
                                <span style="background: #d4edda; color: #155724; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                    Aktif
                                </span>
                            @else
                                <span style="background: #f8d7da; color: #721c24; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                    Tidak Aktif
                                </span>
                            @endif
                        </td>
                    </tr>
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 15px 0; font-weight: bold; color: #333;">Dibuat:</td>
                        <td style="padding: 15px 0; color: #555;">{{ $document->created_at->format('d M Y H:i') }}</td>
                    </tr>
                    <tr>
                        <td style="padding: 15px 0; font-weight: bold; color: #333;">Diupdate:</td>
                        <td style="padding: 15px 0; color: #555;">{{ $document->updated_at->format('d M Y H:i') }}</td>
                    </tr>
                </table>
            </div>

            <div style="display: flex; gap: 15px; margin-top: 30px;">
                <a href="{{ $document->download_url }}" target="_blank" style="background: #28a745; color: white; padding: 12px 30px; text-decoration: none; border-radius: 8px; font-size: 16px; font-weight: bold;">
                    Download File
                </a>
                <a href="{{ route('admin.documents.edit', $document) }}" style="background: #ffc107; color: #212529; padding: 12px 30px; text-decoration: none; border-radius: 8px; font-size: 16px; font-weight: bold;">
                    Edit Dokumen
                </a>
                <a href="{{ route('admin.documents.index') }}" style="background: #6c757d; color: white; padding: 12px 30px; text-decoration: none; border-radius: 8px; font-size: 16px; font-weight: bold;">
                    Kembali ke List
                </a>
            </div>
        </div>
    </div>
</div>
@endsection
