@extends('layouts.admin')

@section('title', 'Kelola Layanan - Admin Panel')

@section('page-title', 'Kelola Layanan')

@section('content')
<div class="breadcrumb">
    <a href="{{ route('admin.dashboard') }}">Dashboard</a>
    <span>/</span>
    <span>Kelola Layanan</span>
</div>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
    <h1 style="color: #0a3d91; font-size: 2rem; margin: 0;">Kelola Layanan</h1>
    <a href="{{ route('admin.services.create') }}" style="background: #0a3d91; color: white; padding: 12px 24px; text-decoration: none; border-radius: 8px; font-weight: bold;">
        + Tambah Layanan
    </a>
</div>

@if(session('success'))
    <div style="background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin-bottom: 20px; border: 1px solid #c3e6cb;">
        {{ session('success') }}
    </div>
@endif

<div style="background: white; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); overflow: hidden;">
    <div style="padding: 20px;">
        <table style="width: 100%; border-collapse: collapse;">
            <thead>
                <tr style="border-bottom: 2px solid #eee;">
                    <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Judul</th>
                    <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Icon</th>
                    <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Urutan</th>
                    <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Status</th>
                    <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Dibuat</th>
                    <th style="padding: 12px; text-align: center; font-weight: bold; color: #0a3d91;">Aksi</th>
                </tr>
            </thead>
            <tbody>
                @forelse($services as $service)
                    <tr style="border-bottom: 1px solid #eee;">
                        <td style="padding: 12px;">
                            <div style="font-weight: bold; color: #333;">{{ $service->title }}</div>
                            <div style="font-size: 0.9rem; color: #666; margin-top: 4px;">
                                {{ Str::limit($service->description, 50) }}
                            </div>
                        </td>
                        <td style="padding: 12px;">
                            <span style="font-size: 1.5rem;">{{ $service->icon ?: '📋' }}</span>
                        </td>
                        <td style="padding: 12px;">
                            {{ $service->sort_order }}
                        </td>
                        <td style="padding: 12px;">
                            @if($service->is_active)
                                <span style="background: #28a745; color: white; padding: 4px 8px; border-radius: 12px; font-size: 0.8rem;">
                                    Aktif
                                </span>
                            @else
                                <span style="background: #dc3545; color: white; padding: 4px 8px; border-radius: 12px; font-size: 0.8rem;">
                                    Nonaktif
                                </span>
                            @endif
                        </td>
                        <td style="padding: 12px;">
                            {{ $service->created_at->format('d/m/Y') }}
                        </td>
                        <td style="padding: 12px; text-align: center;">
                            <div style="display: flex; gap: 8px; justify-content: center;">
                                <a href="{{ route('admin.services.show', $service) }}" style="background: #17a2b8; color: white; padding: 6px 12px; border-radius: 4px; text-decoration: none; font-size: 0.9rem;">
                                    Lihat
                                </a>
                                <a href="{{ route('admin.services.edit', $service) }}" style="background: #ffc107; color: #212529; padding: 6px 12px; border-radius: 4px; text-decoration: none; font-size: 0.9rem;">
                                    Edit
                                </a>
                                <form method="POST" action="{{ route('admin.services.destroy', $service) }}" style="display: inline;" onsubmit="return confirm('Apakah Anda yakin ingin menghapus layanan ini?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" style="background: #dc3545; color: white; border: none; padding: 6px 12px; border-radius: 4px; cursor: pointer; font-size: 0.9rem;">
                                        Hapus
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="6" style="padding: 40px; text-align: center; color: #666;">
                            <div style="font-size: 3rem; margin-bottom: 10px;">📋</div>
                            <div>Belum ada layanan yang dibuat</div>
                            <a href="{{ route('admin.services.create') }}" style="color: #0a3d91; text-decoration: underline; margin-top: 10px; display: inline-block;">
                                Buat layanan pertama
                            </a>
                        </td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>

@if($services->hasPages())
    <div style="margin-top: 20px;">
        {{ $services->links() }}
    </div>
@endif
@endsection
