@extends('layouts.app')

@section('title', 'Edit User - Admin Panel')

@section('content')
<div style="padding: 40px 20px; width: 100%;">
    <div style="max-width: 600px; margin: 0 auto;">
        <div style="background: white; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); padding: 30px;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
                <h1 style="color: #0a3d91; font-size: 2rem; margin: 0;">Edit User</h1>
                <a href="{{ route('admin.users.index') }}" style="color: #6c757d; text-decoration: none;">
                    ← Kembali
                </a>
            </div>

            <form action="{{ route('admin.users.update', $user) }}" method="POST">
                @csrf
                @method('PUT')

                <div style="margin-bottom: 20px;">
                    <label for="name" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Nama Lengkap *</label>
                    <input type="text" id="name" name="name" value="{{ old('name', $user->name) }}" required
                           style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                    @error('name')
                        <div style="color: #dc3545; font-size: 0.9rem; margin-top: 4px;">{{ $message }}</div>
                    @enderror
                </div>

                <div style="margin-bottom: 20px;">
                    <label for="email" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Email *</label>
                    <input type="email" id="email" name="email" value="{{ old('email', $user->email) }}" required
                           style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                    @error('email')
                        <div style="color: #dc3545; font-size: 0.9rem; margin-top: 4px;">{{ $message }}</div>
                    @enderror
                </div>

                @if(auth()->user()->isSuperAdmin() && $canEditRole)
                <div style="margin-bottom: 20px;">
                    <label for="role" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Role *</label>
                    <select id="role" name="role" required style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                        <option value="admin" {{ old('role', $user->role) == 'admin' ? 'selected' : '' }}>Admin</option>
                        <option value="super_admin" {{ old('role', $user->role) == 'super_admin' ? 'selected' : '' }}>Super Admin</option>
                    </select>
                    <div style="font-size: 0.9rem; color: #666; margin-top: 4px;">
                        <strong>Admin:</strong> Dapat CRUD data<br>
                        <strong>Super Admin:</strong> Dapat CRUD data + manage users
                    </div>
                    @error('role')
                        <div style="color: #dc3545; font-size: 0.9rem; margin-top: 4px;">{{ $message }}</div>
                    @enderror
                </div>
                @endif

                <div style="margin-bottom: 20px;">
                    <label for="password" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Password Baru (Opsional)</label>
                    <input type="password" id="password" name="password"
                           style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                    <div style="font-size: 0.9rem; color: #666; margin-top: 4px;">
                        Biarkan kosong jika tidak ingin mengubah password
                    </div>
                    @error('password')
                        <div style="color: #dc3545; font-size: 0.9rem; margin-top: 4px;">{{ $message }}</div>
                    @enderror
                </div>

                <div style="margin-bottom: 30px;">
                    <label for="password_confirmation" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Konfirmasi Password Baru</label>
                    <input type="password" id="password_confirmation" name="password_confirmation"
                           style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                </div>

                <div style="display: flex; gap: 15px;">
                    <button type="submit" style="background: #0a3d91; color: white; padding: 12px 30px; border: none; border-radius: 8px; font-size: 16px; font-weight: bold; cursor: pointer;">
                        Update User
                    </button>
                    <a href="{{ route('admin.users.index') }}" style="background: #6c757d; color: white; padding: 12px 30px; text-decoration: none; border-radius: 8px; font-size: 16px; font-weight: bold;">
                        Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
