<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', 'Admin Panel - SPM ATK')</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600&display=swap" rel="stylesheet" />

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Instrument Sans', ui-sans-serif, system-ui, sans-serif;
            background-color: #f8fafc;
            overflow-x: hidden;
        }

        /* Sidebar Styles */
        .admin-sidebar {
            position: fixed;
            top: 0;
            left: 0;
            width: 280px;
            height: 100vh;
            background: linear-gradient(180deg, #0a3d91 0%, #1e5bc6 100%);
            color: white;
            z-index: 1000;
            transition: transform 0.3s ease;
            box-shadow: 2px 0 10px rgba(0,0,0,0.1);
        }

        .admin-sidebar.collapsed {
            transform: translateX(-280px);
        }

        .sidebar-header {
            padding: 25px 20px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            background: rgba(255,255,255,0.1);
            text-align: center;
        }

        .sidebar-header img {
            width: 300px;
            height: auto;
            max-height: 300px;
            border-radius: 12px;
            object-fit: contain;
            padding: 8px;
        }

        .sidebar-menu {
            padding: 20px 0;
        }

        .sidebar-menu-item {
            margin-bottom: 5px;
        }

        .sidebar-menu-link {
            display: flex;
            align-items: center;
            padding: 15px 20px;
            color: rgba(255,255,255,0.8);
            text-decoration: none;
            transition: all 0.3s ease;
            border-left: 4px solid transparent;
        }

        .sidebar-menu-link:hover,
        .sidebar-menu-link.active {
            background-color: rgba(255,255,255,0.1);
            color: white;
            border-left-color: #ffd700;
        }

        .sidebar-menu-link i {
            width: 20px;
            margin-right: 15px;
            font-size: 1.1rem;
        }

        .sidebar-menu-link span {
            font-weight: 500;
        }

        /* Main Content */
        .admin-main {
            margin-left: 280px;
            transition: margin-left 0.3s ease;
            min-height: 100vh;
        }

        .admin-main.expanded {
            margin-left: 0;
        }

        .admin-header {
            background: white;
            padding: 20px 30px;
            border-bottom: 1px solid #e5e7eb;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: sticky;
            top: 0;
            z-index: 999;
        }

        .header-left {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .sidebar-toggle {
            background: none;
            border: none;
            color: #6b7280;
            font-size: 1.2rem;
            cursor: pointer;
            padding: 8px;
            border-radius: 6px;
            transition: all 0.2s ease;
        }

        .sidebar-toggle:hover {
            background-color: #f3f4f6;
            color: #374151;
        }

        .header-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #1f2937;
        }

        .header-right {
            display: flex;
            align-items: center;
            gap: 20px;
        }

        .user-info {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            background: #0a3d91;
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            font-size: 1.1rem;
        }

        .user-details {
            display: flex;
            flex-direction: column;
        }

        .user-name {
            font-weight: 600;
            color: #1f2937;
            font-size: 0.9rem;
        }

        .user-role {
            font-size: 0.8rem;
            color: #6b7280;
        }

        .logout-btn {
            background: #dc3545;
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 6px;
            font-size: 0.85rem;
            font-weight: 500;
            cursor: pointer;
            transition: background-color 0.2s ease;
        }

        .logout-btn:hover {
            background: #c82333;
        }

        .admin-content {
            padding: 30px;
            max-width: 100%;
        }

        .breadcrumb {
            margin-bottom: 25px;
            font-size: 0.9rem;
            color: #6b7280;
        }

        .breadcrumb a {
            color: #0a3d91;
            text-decoration: none;
        }

        .breadcrumb a:hover {
            text-decoration: underline;
        }

        .breadcrumb span {
            margin: 0 8px;
        }

        /* Mobile Responsive */
        @media (max-width: 768px) {
            .admin-sidebar {
                transform: translateX(-280px);
                width: 250px;
            }

            .admin-sidebar.mobile-open {
                transform: translateX(0);
            }

            .admin-main {
                margin-left: 0;
            }

            .admin-header {
                padding: 15px 20px;
            }

            .header-title {
                font-size: 1.3rem;
            }

            .admin-content {
                padding: 20px 15px;
            }

            .user-details {
                display: none;
            }

            .sidebar-header img {
                width: 200px;
                height: auto;
            }

            .sidebar-menu-link {
                padding: 12px 15px;
                font-size: 0.9rem;
            }

            .sidebar-menu-link i {
                width: 18px;
                margin-right: 12px;
            }
        }

        @media (max-width: 480px) {
            .admin-sidebar {
                width: 220px;
            }

            .sidebar-header {
                padding: 20px 15px;
            }

            .sidebar-header img {
                width: 180px;
            }

            .admin-header {
                padding: 12px 15px;
            }

            .header-title {
                font-size: 1.1rem;
            }

            .admin-content {
                padding: 15px 10px;
            }

            .user-avatar {
                width: 32px;
                height: 32px;
            }

            .sidebar-menu-link {
                padding: 10px 12px;
                font-size: 0.85rem;
            }
        }

        /* Dark overlay for mobile */
        .sidebar-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.5);
            z-index: 999;
        }

        .sidebar-overlay.active {
            display: block;
        }

        /* Content animations */
        .fade-in {
            animation: fadeIn 0.3s ease-in-out;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        /* Custom scrollbar */
        .admin-sidebar::-webkit-scrollbar {
            width: 6px;
        }

        .admin-sidebar::-webkit-scrollbar-track {
            background: rgba(255,255,255,0.1);
        }

        .admin-sidebar::-webkit-scrollbar-thumb {
            background: rgba(255,255,255,0.3);
            border-radius: 3px;
        }

        .admin-sidebar::-webkit-scrollbar-thumb:hover {
            background: rgba(255,255,255,0.5);
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <aside class="admin-sidebar" id="adminSidebar">
        <div class="sidebar-header">
            <img src="{{ asset('images/Logo_Tipograph_Tulisan_Warna.png') }}" alt="ATK Admin Logo">
        </div>

        <nav class="sidebar-menu">
            <div class="sidebar-menu-item">
                <a href="{{ route('admin.dashboard') }}" class="sidebar-menu-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>Dashboard</span>
                </a>
            </div>

            <div class="sidebar-menu-item">
                <a href="{{ route('admin.profiles.index') }}" class="sidebar-menu-link {{ request()->routeIs('admin.profiles.*') ? 'active' : '' }}">
                    <i class="fas fa-user-circle"></i>
                    <span>Kelola Profil</span>
                </a>
            </div>

            <div class="sidebar-menu-item">
                <a href="{{ route('admin.articles.index') }}" class="sidebar-menu-link {{ request()->routeIs('admin.articles.*') ? 'active' : '' }}">
                    <i class="fas fa-newspaper"></i>
                    <span>Kelola Artikel</span>
                </a>
            </div>

            <div class="sidebar-menu-item">
                <a href="{{ route('admin.services.index') }}" class="sidebar-menu-link {{ request()->routeIs('admin.services.*') ? 'active' : '' }}">
                    <i class="fas fa-concierge-bell"></i>
                    <span>Kelola Layanan</span>
                </a>
            </div>

            <div class="sidebar-menu-item">
                <a href="{{ route('admin.documents.index') }}" class="sidebar-menu-link {{ request()->routeIs('admin.documents.*') ? 'active' : '' }}">
                    <i class="fas fa-folder-open"></i>
                    <span>Kelola Dokumen</span>
                </a>
            </div>

            @if(auth()->user()->isSuperAdmin())
            <div class="sidebar-menu-item">
                <a href="{{ route('admin.users.index') }}" class="sidebar-menu-link {{ request()->routeIs('admin.users.*') ? 'active' : '' }}">
                    <i class="fas fa-users-cog"></i>
                    <span>Kelola Users</span>
                </a>
            </div>
            @endif

            <hr style="border: none; border-top: 1px solid rgba(255,255,255,0.1); margin: 20px 20px;">

            <div class="sidebar-menu-item">
                <a href="{{ route('home') }}" target="_blank" class="sidebar-menu-link">
                    <i class="fas fa-external-link-alt"></i>
                    <span>Lihat Website</span>
                </a>
            </div>
        </nav>
    </aside>

    <!-- Sidebar Overlay for Mobile -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>

    <!-- Main Content -->
    <main class="admin-main" id="adminMain">
        <!-- Header -->
        <header class="admin-header">
            <div class="header-left">
                <button class="sidebar-toggle" id="sidebarToggle">
                    <i class="fas fa-bars"></i>
                </button>
                <h1 class="header-title">@yield('page-title', 'Dashboard')</h1>
            </div>

            <div class="header-right">
                <div class="user-info">
                    <div class="user-avatar">
                        {{ strtoupper(substr(auth()->user()->name, 0, 1)) }}
                    </div>
                    <div class="user-details">
                        <div class="user-name">{{ auth()->user()->name }}</div>
                        <div class="user-role">{{ auth()->user()->isSuperAdmin() ? 'Super Admin' : 'Admin' }}</div>
                    </div>
                </div>

                <form method="POST" action="{{ route('logout') }}" style="display: inline;">
                    @csrf
                    <button type="submit" class="logout-btn">
                        <i class="fas fa-sign-out-alt"></i>
                        <span class="d-none d-md-inline">Logout</span>
                    </button>
                </form>
            </div>
        </header>

        <!-- Content -->
        <div class="admin-content fade-in">
            @yield('content')
        </div>
    </main>

    <script>
        // Sidebar toggle functionality
        document.addEventListener('DOMContentLoaded', function() {
            const sidebar = document.getElementById('adminSidebar');
            const sidebarOverlay = document.getElementById('sidebarOverlay');
            const sidebarToggle = document.getElementById('sidebarToggle');
            const adminMain = document.getElementById('adminMain');

            // Toggle sidebar
            sidebarToggle.addEventListener('click', function() {
                sidebar.classList.toggle('collapsed');
                sidebar.classList.toggle('mobile-open');
                adminMain.classList.toggle('expanded');
                sidebarOverlay.classList.toggle('active');
            });

            // Close sidebar when clicking overlay
            sidebarOverlay.addEventListener('click', function() {
                sidebar.classList.remove('mobile-open');
                sidebarOverlay.classList.remove('active');
            });

            // Close sidebar on mobile when clicking menu items
            document.querySelectorAll('.sidebar-menu-link').forEach(link => {
                link.addEventListener('click', function() {
                    if (window.innerWidth <= 768) {
                        sidebar.classList.remove('mobile-open');
                        sidebarOverlay.classList.remove('active');
                    }
                });
            });

            // Handle window resize
            window.addEventListener('resize', function() {
                if (window.innerWidth > 768) {
                    sidebar.classList.remove('mobile-open');
                    sidebarOverlay.classList.remove('active');
                    adminMain.classList.remove('expanded');
                }
            });
        });
    </script>
</body>
</html>
