<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="{{ csrf_token() }}">

        <title>{{ config('app.name', 'Laravel') }}</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
    </head>
    <body class="font-sans text-gray-900 antialiased">
        <div style="min-height: 100vh; display: flex; flex-direction: column; justify-content: center; align-items: center; padding: 20px; background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);">
            <div style="text-align: center; margin-bottom: 20px;">
                <a href="{{ route('home') }}" style="color: #0a3d91; text-decoration: none;">
                    <img src="{{ asset('images/atk.png') }}" alt="Logo ATK" style="height: 50px; width: auto;">
                </a>
            </div>

            <div style="width: 100%; max-width: 400px;">
                {{ $slot }}
            </div>
        </div>
    </body>
</html>
