@extends('layouts.app')

@section('content')
<div style="padding: 60px 20px 40px 20px; width: 100%;">
    <h1 style="color: #0a3d91; text-align: center; margin-bottom: 20px; font-size: 2.5rem;">
        @if(isset($showAllCategories) && !$showAllCategories)
            DOCUMENT STANDART SPMI
        @else
            DOWNLOAD DOKUMEN
        @endif
    </h1>
    <p style="text-align: center; color: #666; font-size: 1.2rem; margin-bottom: 60px;">
        @if(isset($showAllCategories) && !$showAllCategories)
            Document standart SPMI yang telah disusun sesuai dengan persyaratan sistem penjaminan mutu.
        @else
            Unduh dokumen-dokumen penting terkait standar mutu dan regulasi.
        @endif
    </p>

    <div style="display: grid; gap: 20px; max-width: 1000px; margin: 0 auto;">
        @php
            $filteredDocuments = isset($showAllCategories) && !$showAllCategories
                ? $documents->get('dokumen-mutu', collect())
                : $documents->flatten();
        @endphp

        @if($filteredDocuments->isEmpty())
            <div style="background: white; padding: 60px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); text-align: center;">
                <h3 style="color: #666; margin-bottom: 15px;">
                    @if(isset($showAllCategories) && !$showAllCategories)
                        Belum ada dokumen mutu tersedia
                    @else
                        Belum ada dokumen tersedia
                    @endif
                </h3>
                <p style="color: #999;">
                    @if(isset($showAllCategories) && !$showAllCategories)
                        Dokumen mutu akan segera ditambahkan oleh administrator.
                    @else
                        Dokumen-dokumen akan segera ditambahkan oleh administrator.
                    @endif
                </p>
            </div>
        @else
            @foreach($filteredDocuments as $document)
                <!-- Simple Document Card -->
                <div style="background: white; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); overflow: hidden;">
                    <!-- Document Header -->
                    <div style="padding: 20px; border-bottom: 1px solid #eee;">
                        <h3 style="margin: 0; color: #0a3d91; font-size: 1.4rem; text-align: center;">{{ $document->title }}</h3>
                    </div>

                    <!-- Simple PDF Viewer -->
                    <div style="padding: 20px;">
                        <div style="width: 100%; height: 500px; border: 1px solid #ddd; border-radius: 8px; background: #f9f9fa;">
                            <iframe src="{{ route('documents.download', $document->id) }}?preview=1"
                                    style="width: 100%; height: 100%; border: none; border-radius: 8px;"
                                    title="Preview {{ $document->title }}">
                            </iframe>
                        </div>
                    </div>

                    <!-- Document Info & Download -->
                    <div style="padding: 20px; background: #f8f9fa; border-top: 1px solid #eee;">
                        <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px;">
                            <div style="flex: 1;">
                                <div style="font-size: 0.9rem; color: #666;">
                                    <strong>Kategori:</strong> {{ ucfirst($document->category) }} |
                                    <strong>Ukuran:</strong> {{ $document->formatted_file_size }} |
                                    <strong>Format:</strong> {{ strtoupper(pathinfo($document->file_name, PATHINFO_EXTENSION)) }}
                                </div>
                                @if($document->description)
                                    <div style="margin-top: 8px; font-size: 0.85rem; color: #888;">
                                        {{ Str::limit($document->description, 100) }}
                                    </div>
                                @endif
                            </div>

                            <div style="flex-shrink: 0;">
                                <a href="{{ route('documents.download', $document->id) }}"
                                   style="background: #0a3d91; color: white; padding: 12px 25px; border-radius: 25px; text-decoration: none; font-weight: bold; display: inline-block;">
                                    📥 Download
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        @endif
    </div>

    <div style="background: #f8f9fa; padding: 30px; border-radius: 10px; text-align: center; margin-top: 40px;">
        <h3 style="color: #0a3d91; margin-bottom: 15px;">Butuh Dokumen Lainnya?</h3>
        <p style="color: #666; margin-bottom: 20px;">
            Jika Anda membutuhkan dokumen tertentu yang tidak tersedia di sini, silakan hubungi kami.
        </p>
        <a href="{{ route('kontak') }}" style="background: #0a3d91; color: white; padding: 12px 25px; border-radius: 25px; text-decoration: none; font-weight: bold; display: inline-block;">
            Hubungi Kami
        </a>
    </div>
</div>

<style>
/* PDF Viewer responsive adjustments */
@media (max-width: 768px) {
    div[style*="height: 500px"] {
        height: 400px !important;
    }
}

@media (max-width: 480px) {
    div[style*="height: 500px"] {
        height: 350px !important;
    }
}
</style>

@endsection