@extends('layouts.app')

@section('title', 'Kontak - BADAN PENJAMINAN MUTU ATK')

@section('content')
<div style="padding: 40px 20px; width: 100%;">
    <h1 style="color: #0a3d91; text-align: center; margin-bottom: 20px; font-size: 2.5rem;">
        HUBUNGI KAMI
    </h1>
    <p style="text-align: center; color: #666; font-size: 1.2rem; margin-bottom: 60px;">
        Silakan hubungi Badan Penjaminan Mutu Politeknik ATK untuk informasi lebih lanjut tentang layanan penjaminan mutu.
    </p>

    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr)); gap: 40px;">
        <!-- Contact Information -->
        <div style="background: white; padding: 30px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
            <h2 style="color: #0a3d91; margin-bottom: 25px; font-size: 1.5rem;">Informasi Kontak</h2>

            <div style="display: grid; gap: 20px;">
                <div style="display: flex; align-items: flex-start; gap: 15px;">
                    <div style="width: 40px; height: 40px; background: #0a3d91; border-radius: 50%; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                        <span style="color: white; font-size: 18px;">📍</span>
                    </div>
                    <div>
                        <h4 style="color: #0a3d91; margin-bottom: 5px; font-size: 1.1rem;">Alamat</h4>
                        <p style="color: #666; margin: 0; line-height: 1.5;">
                            Jl. Prof. DR. Wirjono Projodikoro<br>
                            Glugo, Panggungharjo, Prodjodikoro<br>
                            Kabupaten Bantul, Daerah Istimewa Yogyakarta 55188<br>
                            Indonesia
                        </p>
                    </div>
                </div>

                <div style="display: flex; align-items: flex-start; gap: 15px;">
                    <div style="width: 40px; height: 40px; background: #0a3d91; border-radius: 50%; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                        <span style="color: white; font-size: 18px;">📞</span>
                    </div>
                    <div>
                        <h4 style="color: #0a3d91; margin-bottom: 5px; font-size: 1.1rem;">Telepon</h4>
                        <p style="color: #666; margin: 0;">
                            Telepon: (0274) 383727<br>
                            WhatsApp (PMB): 08112671919
                        </p>
                    </div>
                </div>

                <div style="display: flex; align-items: flex-start; gap: 15px;">
                    <div style="width: 40px; height: 40px; background: #0a3d91; border-radius: 50%; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                        <span style="color: white; font-size: 18px;">✉️</span>
                    </div>
                    <div>
                        <h4 style="color: #0a3d91; margin-bottom: 5px; font-size: 1.1rem;">Email</h4>
                        <p style="color: #666; margin: 0;">
                            Email: info@atk.ac.id / humas@politeknikatk.ac.id
                        </p>
                    </div>
                </div>

                <div style="display: flex; align-items: flex-start; gap: 15px;">
                    <div style="width: 40px; height: 40px; background: #0a3d91; border-radius: 50%; display: flex; align-items: center; justify-content: center; flex-shrink: 0;">
                        <span style="color: white; font-size: 18px;">🕒</span>
                    </div>
                    <div>
                        <h4 style="color: #0a3d91; margin-bottom: 5px; font-size: 1.1rem;">Jam Kerja</h4>
                        <p style="color: #666; margin: 0;">
                            Senin - Jumat: 07:30 - 16:00 WIB<br>
                            Sabtu: 07:30 - 16:30 WIB<br>
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Contact Form -->
        <div style="background: white; padding: 30px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
            <h2 style="color: #0a3d91; margin-bottom: 25px; font-size: 1.5rem;">Kirim Pesan</h2>

            <form action="#" method="POST" style="display: grid; gap: 20px;">
                <div>
                    <label for="name" style="display: block; color: #333; margin-bottom: 5px; font-weight: 500;">Nama Lengkap *</label>
                    <input type="text" id="name" name="name" required
                           style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px; box-sizing: border-box;">
                </div>

                <div>
                    <label for="email" style="display: block; color: #333; margin-bottom: 5px; font-weight: 500;">Email *</label>
                    <input type="email" id="email" name="email" required
                           style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px; box-sizing: border-box;">
                </div>

                <div>
                    <label for="phone" style="display: block; color: #333; margin-bottom: 5px; font-weight: 500;">No. Telepon</label>
                    <input type="tel" id="phone" name="phone"
                           style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px; box-sizing: border-box;">
                </div>

                <div>
                    <label for="subject" style="display: block; color: #333; margin-bottom: 5px; font-weight: 500;">Subjek *</label>
                    <select id="subject" name="subject" required
                            style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px; box-sizing: border-box;">
                        <option value="">Pilih Subjek</option>
                        <option value="sertifikasi">Informasi Sertifikasi</option>
                        <option value="akreditasi">Informasi Akreditasi</option>
                        <option value="audit">Jadwal Audit</option>
                        <option value="pelatihan">Informasi Pelatihan</option>
                        <option value="komplain">Pengaduan/Komplain</option>
                        <option value="lainnya">Lainnya</option>
                    </select>
                </div>

                <div>
                    <label for="message" style="display: block; color: #333; margin-bottom: 5px; font-weight: 500;">Pesan *</label>
                    <textarea id="message" name="message" rows="5" required
                              style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px; box-sizing: border-box; resize: vertical;"></textarea>
                </div>

                <button type="submit"
                        style="background: #0a3d91; color: white; border: none; padding: 15px 30px; border-radius: 25px; font-weight: bold; font-size: 16px; cursor: pointer; transition: background-color 0.3s ease;">
                    Kirim Pesan
                </button>
            </form>
        </div>
    </div>

    <!-- Map Section -->
    <div style="background: white; padding: 30px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); margin-top: 40px;">
        <h2 style="color: #0a3d91; margin-bottom: 20px; font-size: 1.5rem; text-align: center;">Lokasi Kami</h2>
        <div style="margin-bottom: 15px; text-align: center;">
            <p style="color: #666; margin: 0; font-size: 0.9rem;">
                <strong>Politeknik ATK Yogyakarta</strong><br>
                Alamat : Jl. Prof. DR. Wirjono Projodikoro, Glugo, Panggungharjo, Prodjodikoro<br>
                Kabupaten Bantul, Daerah Istimewa Yogyakarta 55188
            </p>
        </div>
        <div style="border-radius: 8px; overflow: hidden; box-shadow: 0 2px 8px rgba(0,0,0,0.1);">
            <iframe
                src="https://maps.google.com/maps?q=Jl.%20Prof.%20DR.%20Wirjono%20Projodikoro,%20Glugo,%20Panggungharjo,%20Prodjodikoro,%20Kabupaten%20Bantul,%20Daerah%20Istimewa%20Yogyakarta%2055188&t=&z=15&ie=UTF8&iwloc=&output=embed"
                width="100%"
                height="400"
                style="border:0;"
                allowfullscreen=""
                loading="lazy">
            </iframe>
        </div>
        <div style="margin-top: 15px; text-align: center;">
            <a href="https://maps.google.com/maps?q=Jl.+Prof.+DR.+Wirjono+Projodikoro+Glugo+Panggungharjo+Prodjodikoro+Kabupaten+Bantul+Daerah+Istimewa+Yogyakarta+55188"
               target="_blank"
               style="background: #0a3d91; color: white; padding: 10px 20px; text-decoration: none; border-radius: 6px; font-size: 0.9rem; display: inline-block;">
                🗺️ Buka di Google Maps
            </a>
        </div>
    </div>
</div>

<style>
    /* Responsive Styles for Contact Page */
    @media (max-width: 768px) {
        .contact-container {
            padding: 20px 10px;
        }

        .contact-title {
            font-size: 2rem;
        }

        .contact-subtitle {
            font-size: 1rem;
        }

        .contact-grid {
            grid-template-columns: 1fr;
            gap: 20px;
        }

        .contact-info, .contact-form {
            padding: 20px;
        }

        .map-container iframe {
            height: 300px;
        }
    }

    @media (max-width: 480px) {
        .contact-title {
            font-size: 1.8rem;
        }

        .contact-info, .contact-form {
            padding: 15px;
        }

        .contact-form input, .contact-form select, .contact-form textarea {
            font-size: 16px; /* Prevent zoom on iOS */
        }

        .map-container iframe {
            height: 250px;
        }
    }
</style>

    @include('partials.footer')
@endsection
