@extends('layouts.app')

@section('content')
<style>
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(30px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    @keyframes fadeIn {
        from {
            opacity: 0;
        }
        to {
            opacity: 1;
        }
    }
    
    @keyframes slideInLeft {
        from {
            opacity: 0;
            transform: translateX(-30px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }
    
    @keyframes slideInRight {
        from {
            opacity: 0;
            transform: translateX(30px);
        }
        to {
            opacity: 1;
            transform: translateX(0);
        }
    }
    
    @keyframes scaleIn {
        from {
            opacity: 0;
            transform: scale(0.9);
        }
        to {
            opacity: 1;
            transform: scale(1);
        }
    }
    
    @keyframes shimmer {
        0% {
            background-position: -1000px 0;
        }
        100% {
            background-position: 1000px 0;
        }
    }
    
    .profile-container {
        max-width: 1000px;
        margin: 0 auto;
        padding: 40px 20px;
    }
    
    .profile-header {
        text-align: center;
        margin-bottom: 50px;
        padding-top: 40px;
        animation: fadeInUp 0.8s ease-out;
    }
    
    .profile-title {
        font-size: 2.5rem;
        font-weight: 700;
        color: #0a3d91;
        margin-bottom: 15px;
        line-height: 1.3;
        position: relative;
        display: inline-block;
        transition: all 0.3s ease;
    }
    
    .profile-title::after {
        content: '';
        position: absolute;
        bottom: -5px;
        left: 50%;
        transform: translateX(-50%);
        width: 0;
        height: 3px;
        background: linear-gradient(90deg, #0a3d91, #1a5f99);
        border-radius: 2px;
        transition: width 0.5s ease;
    }
    
    .profile-title:hover::after {
        width: 100%;
    }
    
    .profile-subtitle {
        font-size: 1.1rem;
        color: #666;
        max-width: 700px;
        margin: 0 auto;
        line-height: 1.7;
        animation: fadeIn 1s ease-out 0.3s both;
    }
    
    .profile-content {
        background: white;
        border-radius: 12px;
        padding: 50px;
        box-shadow: 0 2px 15px rgba(0,0,0,0.08);
        line-height: 1.9;
        font-size: 1.05rem;
        color: #444;
        text-align: justify;
        animation: scaleIn 0.8s ease-out 0.4s both;
        transition: all 0.3s ease;
        position: relative;
        overflow: hidden;
    }
    
    .profile-content::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(10, 61, 145, 0.03), transparent);
        transition: left 0.5s ease;
    }
    
    .profile-content:hover {
        box-shadow: 0 8px 30px rgba(0,0,0,0.12);
        transform: translateY(-2px);
    }
    
    .profile-content:hover::before {
        left: 100%;
    }
    
    .profile-image-wrapper {
        text-align: center;
        margin-bottom: 40px;
        animation: fadeInUp 0.8s ease-out 0.2s both;
    }
    
    .profile-image-wrapper img {
        max-width: 100%;
        height: auto;
        border-radius: 12px;
        box-shadow: 0 4px 20px rgba(0,0,0,0.1);
        transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        position: relative;
    }
    
    .profile-image-wrapper img:hover {
        transform: scale(1.02) translateY(-5px);
        box-shadow: 0 12px 40px rgba(10, 61, 145, 0.2);
    }
    
    .divider {
        width: 80px;
        height: 3px;
        background: linear-gradient(90deg, #0a3d91, #1a5f99);
        margin: 30px auto;
        border-radius: 2px;
        position: relative;
        overflow: hidden;
        animation: slideInLeft 0.8s ease-out 0.5s both;
    }
    
    .divider::after {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 100%;
        height: 100%;
        background: linear-gradient(90deg, transparent, rgba(255,255,255,0.5), transparent);
        animation: shimmer 2s infinite;
    }
    
    .category-badge {
        display: inline-block;
        padding: 8px 20px;
        background: #f0f4f8;
        color: #0a3d91;
        border-radius: 20px;
        font-size: 0.9rem;
        font-weight: 500;
        transition: all 0.3s ease;
        animation: fadeInUp 0.8s ease-out 0.6s both;
        position: relative;
        overflow: hidden;
    }
    
    .category-badge::before {
        content: '';
        position: absolute;
        top: 50%;
        left: 50%;
        width: 0;
        height: 0;
        border-radius: 50%;
        background: rgba(10, 61, 145, 0.1);
        transform: translate(-50%, -50%);
        transition: width 0.6s ease, height 0.6s ease;
    }
    
    .category-badge:hover {
        background: #0a3d91;
        color: white;
        transform: scale(1.05);
        box-shadow: 0 4px 15px rgba(10, 61, 145, 0.3);
    }
    
    .category-badge:hover::before {
        width: 300px;
        height: 300px;
    }
    
    .category-badge span {
        position: relative;
        z-index: 1;
    }
    
    /* Scroll Animation */
    .fade-in-on-scroll {
        opacity: 0;
        transform: translateY(30px);
        transition: all 0.8s ease-out;
    }
    
    .fade-in-on-scroll.visible {
        opacity: 1;
        transform: translateY(0);
    }
    
    @media (max-width: 768px) {
        .profile-title {
            font-size: 2rem;
        }
        
        .profile-content {
            padding: 30px 20px;
            font-size: 1rem;
        }
        
        .profile-container {
            padding: 20px 15px;
        }
    }
    
    /* Smooth page load */
    body {
        animation: fadeIn 0.5s ease-out;
    }
</style>

<div class="profile-container">
    <!-- Header -->
    <div class="profile-header">
        <h1 class="profile-title">
            {{ $profile->title ?? 'Tentang Badan Penjaminan Mutu' }}
        </h1>
        @if($profile->excerpt)
        <p class="profile-subtitle">
            {{ $profile->excerpt }}
        </p>
        @endif
        <div class="divider"></div>
    </div>

    <!-- Image (if available) -->
    @if($profile->image)
    <div class="profile-image-wrapper fade-in-on-scroll">
        <img src="{{ asset($profile->image) }}" alt="{{ $profile->title }}">
    </div>
    @endif

    <!-- Content -->
    <div class="profile-content fade-in-on-scroll">
        {!! nl2br(e($profile->content ?? 'Konten tentang Sistem Penjaminan Mutu akan ditampilkan di sini.')) !!}
    </div>

    <!-- Category Badge (if available) -->
    @if($profile->category)
    <div style="text-align: center; margin-top: 30px;">
        <span class="category-badge">
            <span>{{ ucwords(str_replace('-', ' ', $profile->category)) }}</span>
        </span>
    </div>
    @endif
</div>

<script>
    // Scroll Animation
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };
    
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('visible');
            }
        });
    }, observerOptions);
    
    // Observe all elements with fade-in-on-scroll class
    document.querySelectorAll('.fade-in-on-scroll').forEach(el => {
        observer.observe(el);
    });
    
    // Smooth scroll for page load
    window.addEventListener('load', () => {
        document.body.style.opacity = '1';
    });
</script>

@include('partials.footer')

@endsection
