<!DOCTYPE html>
<html>
<head>
    <title>Simple Dokumen Mutu Test</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        .document { border: 1px solid #ccc; padding: 15px; margin: 10px 0; border-radius: 5px; }
        .title { color: #0a3d91; font-weight: bold; }
    </style>
</head>
<body>
    <h1>Simple Dokumen Mutu Test</h1>
    <p>Total documents found: {{ $documents->count() }}</p>

    @if($documents->count() > 0)
        <h2>Documents:</h2>
        @foreach($documents as $document)
            <div class="document">
                <div class="title">{{ $document->title }}</div>
                <div>ID: {{ $document->id }}</div>
                <div>Category: {{ $document->category }}</div>
                <div>Active: {{ $document->is_active ? 'Yes' : 'No' }}</div>
                <div>File: {{ $document->file_name }}</div>
            </div>
        @endforeach
    @else
        <p>No documents found with category 'dokumen-mutu'</p>
    @endif
</body>
</html>
