<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\BpmController;
use Illuminate\Support\Facades\Route;

// Public routes - tidak perlu login
Route::get('/', [BpmController::class, 'home'])->name('home');
Route::get('/profil', [BpmController::class, 'profil'])->name('profil');
Route::get('/layanan', [BpmController::class, 'layanan'])->name('layanan');
Route::get('/artikel', [BpmController::class, 'artikel'])->name('artikel');
Route::get('/download', [BpmController::class, 'download'])->name('download');
Route::get('/dokumen-mutu', [BpmController::class, 'dokumenMutu'])->name('dokumen-mutu');

// Debug route for testing
Route::get('/test-dokumen-mutu', function () {
    $documents = \App\Models\Document::active()
        ->where('category', 'dokumen-mutu')
        ->orderBy('title')
        ->get()
        ->groupBy('category');

    $showAllCategories = false;
    $filteredDocuments = isset($showAllCategories) && !$showAllCategories
        ? $documents->get('dokumen-mutu', collect())
        : $documents->flatten();

    return response()->json([
        'total_raw' => \App\Models\Document::where('category', 'dokumen-mutu')->count(),
        'total_active' => \App\Models\Document::active()->where('category', 'dokumen-mutu')->count(),
        'showAllCategories' => $showAllCategories,
        'filtered_count' => $filteredDocuments->count(),
        'documents' => $filteredDocuments->map(function($doc) {
            return [
                'id' => $doc->id,
                'title' => $doc->title,
                'category' => $doc->category,
                'is_active' => $doc->is_active
            ];
        })
    ]);
});

// Simple test page for dokumen-mutu
Route::get('/simple-dokumen-mutu', function () {
    $documents = \App\Models\Document::active()
        ->where('category', 'dokumen-mutu')
        ->orderBy('title')
        ->get();

    return view('simple-test', compact('documents'));
});
Route::get('/akreditasi', [BpmController::class, 'akreditasi'])->name('akreditasi');
Route::get('/peraturan-peraturan', [BpmController::class, 'peraturan'])->name('peraturan');
Route::get('/pernyataan-mutu', [BpmController::class, 'pernyataanMutu'])->name('pernyataan-mutu');
Route::get('/kontak', [BpmController::class, 'kontak'])->name('kontak');

// Dynamic profile routes
Route::get('/profil/{slug}', [BpmController::class, 'showProfile'])->name('profile.show');

// Dynamic article routes
Route::get('/artikel/{slug}', [BpmController::class, 'showArticle'])->name('artikel.show');

// Language switching route
Route::get('/lang/{locale}', function ($locale) {
    if (in_array($locale, ['en', 'id'])) {
        session(['locale' => $locale]);
        app()->setLocale($locale);

        // Force session save
        session()->save();

        \Log::info("Language switched to: {$locale}, Session: " . session('locale'));
    }
    return redirect()->back();
})->name('lang.switch');

// Admin dashboard - hanya untuk admin yang sudah login
Route::get('/dashboard', function () {
    return view('admin.dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});

require __DIR__.'/auth.php';

// Admin routes for content management (protected by auth middleware)
use App\Http\Controllers\Admin\ProfileController as AdminProfileController;
use App\Http\Controllers\Admin\ArticleController as AdminArticleController;
use App\Http\Controllers\Admin\ServiceController as AdminServiceController;
use App\Http\Controllers\DocumentController;

Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
    // Admin dashboard route
    Route::get('/dashboard', function () {
        return view('admin.dashboard');
    })->name('dashboard');

    Route::resource('profiles', AdminProfileController::class);
    Route::resource('articles', AdminArticleController::class);
    Route::resource('services', AdminServiceController::class);
    Route::resource('documents', DocumentController::class);

    // Admin user management - only for super admin
    Route::middleware('role:super_admin')->group(function () {
        Route::resource('users', \App\Http\Controllers\Admin\UserController::class);
    });
});

// Document download route (public)
Route::get('/documents/{id}/download', [DocumentController::class, 'download'])->name('documents.download');
