<!-- Custom Navigation Bar -->
<nav style="background: linear-gradient(135deg, #3a7bd5 0%, #2a5298 50%, #1e3c72 100%); color: white; padding: 8px 0; position: fixed; top: 0; left: 0; right: 0; z-index: 1000; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
    <div style="max-width: 1200px; margin: 0 auto; padding: 0 20px;">
        <div style="display: flex; justify-content: space-between; align-items: center;">

            <!-- Logo -->
            <div style="display: flex; align-items: center; margin-left: -120px;">
                <a href="<?php echo e(route('home')); ?>" style="color: white; text-decoration: none;">
                    <img src="<?php echo e(asset('images/Logo_Tipograph_Tulisan_Warna.png')); ?>" alt="Logo SPMI" style="height: 40px; width: auto;">
                </a>
            </div>

            <!-- Desktop Navigation -->
            <div style="display: flex; align-items: center; gap: 30px;">
                <a href="<?php echo e(route('home')); ?>" style="color: white; text-decoration: none; padding: 8px 12px; border-radius: 4px; transition: background-color 0.3s ease; <?php echo e(request()->routeIs('home') ? 'background-color: rgba(255,255,255,0.1);' : ''); ?>"
                   onmouseover="this.style.backgroundColor='rgba(255,255,255,0.1)'"
                   onmouseout="this.style.backgroundColor='<?php echo e(request()->routeIs('home') ? 'rgba(255,255,255,0.1)' : 'transparent'); ?>'">
                    HOME
                </a>

                <a href="<?php echo e(route('profil')); ?>" style="color: white; text-decoration: none; padding: 8px 12px; border-radius: 4px; transition: background-color 0.3s ease; <?php echo e(request()->routeIs('profil') || request()->routeIs('profile.show') ? 'background-color: rgba(255,255,255,0.1);' : ''); ?>"
                   onmouseover="this.style.backgroundColor='rgba(255,255,255,0.1)'"
                   onmouseout="this.style.backgroundColor='<?php echo e(request()->routeIs('profil') || request()->routeIs('profile.show') ? 'rgba(255,255,255,0.1)' : 'transparent'); ?>'">
                    PROFIL
                </a>

                <a href="<?php echo e(route('artikel')); ?>" style="color: white; text-decoration: none; padding: 8px 12px; border-radius: 4px; transition: background-color 0.3s ease; <?php echo e(request()->routeIs('artikel') ? 'background-color: rgba(255,255,255,0.1);' : ''); ?>"
                   onmouseover="this.style.backgroundColor='rgba(255,255,255,0.1)'"
                   onmouseout="this.style.backgroundColor='<?php echo e(request()->routeIs('artikel') ? 'rgba(255,255,255,0.1)' : 'transparent'); ?>'">
                    ARTIKEL
                </a>

                <div style="position: relative;" onmouseleave="hideDropdown('downloadDropdown')">
                    <a href="#" onmouseover="showDropdown('downloadDropdown'); this.style.backgroundColor='rgba(255,255,255,0.1)'"
                       onmouseout="this.style.backgroundColor='transparent'"
                       style="color: white; text-decoration: none; padding: 8px 12px; border-radius: 4px; transition: background-color 0.3s ease; display: flex; align-items: center; gap: 5px;">
                        DOWNLOAD
                    </a>
                    <div id="downloadDropdown" style="display: none; position: absolute; top: 100%; left: 0; background: white; color: #333; min-width: 200px; border-radius: 4px; box-shadow: 0 4px 8px rgba(0,0,0,0.3); z-index: 1000;">
                        <a href="<?php echo e(route('dokumen-mutu')); ?>" style="display: block; padding: 12px 20px; text-decoration: none; color: #333;" onmouseover="this.style.backgroundColor='#f8f9fa'" onmouseout="this.style.backgroundColor='transparent'">DOCUMENT STANDART SPMI</a>
                    </div>
                </div>

                <a href="<?php echo e(route('kontak')); ?>" style="color: white; text-decoration: none; padding: 8px 12px; border-radius: 4px; transition: background-color 0.3s ease; <?php echo e(request()->routeIs('kontak') ? 'background-color: rgba(255,255,255,0.1);' : ''); ?>"
                   onmouseover="this.style.backgroundColor='rgba(255,255,255,0.1)'"
                   onmouseout="this.style.backgroundColor='<?php echo e(request()->routeIs('kontak') ? 'rgba(255,255,255,0.1)' : 'transparent'); ?>'">
                    KONTAK
                </a>

                <!-- Admin Panel (Professional Design) -->
                <?php if(auth()->guard()->check()): ?>
                    <div style="position: relative; margin-left: 15px; padding-left: 15px; border-left: 1px solid rgba(255,255,255,0.4);">
                        <button onclick="toggleDropdown('adminDropdown')"
                                style="color: white; background: linear-gradient(135deg, rgba(255,255,255,0.1), rgba(255,255,255,0.05)); border: 1px solid rgba(255,255,255,0.2); cursor: pointer; display: flex; align-items: center; gap: 10px; padding: 8px 14px; border-radius: 25px; font-size: 13px; font-weight: 500; transition: all 0.3s ease; backdrop-filter: blur(10px);"
                                onmouseover="this.style.background='linear-gradient(135deg, rgba(255,255,255,0.15), rgba(255,255,255,0.1))'; this.style.transform='translateY(-1px)'; this.style.boxShadow='0 4px 12px rgba(0,0,0,0.15)'"
                                onmouseout="this.style.background='linear-gradient(135deg, rgba(255,255,255,0.1), rgba(255,255,255,0.05))'; this.style.transform='translateY(0)'; this.style.boxShadow='none'">
                            <!-- Avatar Circle -->
                            <div style="width: 28px; height: 28px; border-radius: 50%; background: linear-gradient(135deg, #667eea, #764ba2); display: flex; align-items: center; justify-content: center; font-size: 14px; font-weight: bold; color: white;">
                                <?php echo e(strtoupper(substr(Auth::user()->name, 0, 1))); ?>

                            </div>

                            <!-- User Info -->
                            <div style="display: flex; flex-direction: column; align-items: flex-start; line-height: 1.2;">
                                <span style="font-size: 12px; opacity: 0.9;"><?php echo e(Auth::user()->name); ?></span>
                                <div style="display: flex; align-items: center; gap: 4px;">
                                    <?php if(Auth::user()->isSuperAdmin()): ?>
                                        <span style="background: linear-gradient(135deg, #ff6b6b, #ee5a24); color: white; padding: 2px 8px; border-radius: 12px; font-size: 9px; font-weight: bold; letter-spacing: 0.5px;">SUPER ADMIN</span>
                                    <?php else: ?>
                                        <span style="background: linear-gradient(135deg, #ffd93d, #ffb347); color: #333; padding: 2px 8px; border-radius: 12px; font-size: 9px; font-weight: bold; letter-spacing: 0.5px;">ADMIN</span>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Dropdown Arrow -->
                            <svg width="12" height="12" viewBox="0 0 12 12" fill="none" style="opacity: 0.7;">
                                <path d="M3 4.5L6 7.5L9 4.5" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </button>

                        <!-- Enhanced Admin Dropdown -->
                        <div id="adminDropdown" style="display: none; position: absolute; top: calc(100% + 8px); right: 0; background: white; min-width: 220px; border-radius: 12px; box-shadow: 0 8px 32px rgba(0,0,0,0.12), 0 2px 8px rgba(0,0,0,0.08); border: 1px solid rgba(255,255,255,0.8); overflow: hidden; z-index: 1000;">
                            <!-- Header -->
                            <div style="padding: 16px 20px; background: linear-gradient(135deg, #f8f9fa, #e9ecef); border-bottom: 1px solid #dee2e6;">
                                <div style="font-size: 14px; font-weight: 600; color: #495057; margin-bottom: 4px;"><?php echo e(Auth::user()->name); ?></div>
                                <div style="font-size: 12px; color: #6c757d;">
                                    <?php if(Auth::user()->isSuperAdmin()): ?>
                                        Super Administrator
                                    <?php else: ?>
                                        Administrator
                                    <?php endif; ?>
                                </div>
                            </div>

                            <!-- Menu Items -->
                            <div style="padding: 8px;">
                                <a href="<?php echo e(route('dashboard')); ?>" style="display: flex; align-items: center; gap: 12px; padding: 12px 16px; text-decoration: none; color: #495057; border-radius: 8px; transition: all 0.2s ease; margin-bottom: 4px;"
                                   onmouseover="this.style.backgroundColor='#f8f9fa'; this.style.color='#0a3d91'"
                                   onmouseout="this.style.backgroundColor='transparent'; this.style.color='#495057'">
                                    <div style="width: 20px; height: 20px; border-radius: 6px; background: linear-gradient(135deg, #667eea, #764ba2); display: flex; align-items: center; justify-content: center;">
                                        <svg width="12" height="12" viewBox="0 0 24 24" fill="none">
                                            <path d="M3 7V5C3 4.44772 3.44772 4 4 4H20C20.5523 4 21 4.44772 21 5V7M3 7V19C3 19.5523 3.44772 20 4 20H20C20.5523 20 21 19.5523 21 19V7M3 7H21M12 11V15M9 13H15" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                                        </svg>
                                    </div>
                                    <span style="font-weight: 500;">Dashboard</span>
                                </a>

                                <?php if(Auth::user()->isSuperAdmin()): ?>
                                <a href="<?php echo e(route('admin.users.index')); ?>" style="display: flex; align-items: center; gap: 12px; padding: 12px 16px; text-decoration: none; color: #495057; border-radius: 8px; transition: all 0.2s ease; margin-bottom: 4px;"
                                   onmouseover="this.style.backgroundColor='#f8f9fa'; this.style.color='#0a3d91'"
                                   onmouseout="this.style.backgroundColor='transparent'; this.style.color='#495057'">
                                    <div style="width: 20px; height: 20px; border-radius: 6px; background: linear-gradient(135deg, #ff6b6b, #ee5a24); display: flex; align-items: center; justify-content: center;">
                                        <svg width="12" height="12" viewBox="0 0 24 24" fill="none">
                                            <path d="M17 20H7C5.89543 20 5 19.1046 5 18V9C5 7.89543 5.89543 7 7 7H17C18.1046 7 19 7.89543 19 9V18C19 19.1046 18.1046 20 17 20Z" stroke="white" stroke-width="1.5"/>
                                            <path d="M12 4V7M9 4V7M15 4V7" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                                            <circle cx="12" cy="14" r="1.5" fill="white"/>
                                        </svg>
                                    </div>
                                    <span style="font-weight: 500;">Kelola Users</span>
                                </a>
                                <?php endif; ?>

                                <!-- Divider -->
                                <div style="height: 1px; background: #e9ecef; margin: 8px 0;"></div>

                                <!-- Logout Button -->
                                <form method="POST" action="<?php echo e(route('logout')); ?>" style="margin: 0;">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" style="width: 100%; display: flex; align-items: center; gap: 12px; padding: 12px 16px; background: none; border: none; text-align: left; cursor: pointer; color: #dc3545; border-radius: 8px; transition: all 0.2s ease; font-weight: 500;"
                                            onmouseover="this.style.backgroundColor='#fff5f5'"
                                            onmouseout="this.style.backgroundColor='transparent'">
                                        <div style="width: 20px; height: 20px; border-radius: 6px; background: linear-gradient(135deg, #dc3545, #c82333); display: flex; align-items: center; justify-content: center;">
                                            <svg width="12" height="12" viewBox="0 0 24 24" fill="none">
                                                <path d="M9 21H5C4.46957 21 3.96086 20.7893 3.58579 20.4142C3.21071 20.0391 3 19.5304 3 19V5C3 4.46957 3.21071 3.96086 3.58579 3.58579C3.96086 3.21071 4.46957 3 5 3H9M16 17L21 12M21 12L16 7M21 12H9" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                            </svg>
                                        </div>
                                        <span>Logout</span>
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Mobile Menu Button -->
            <div style="display: none;" id="mobile-menu-button">
                <button onclick="toggleMobileMenu()" style="color: white; background: rgba(255,255,255,0.1); border: 1px solid rgba(255,255,255,0.2); cursor: pointer; font-size: 18px; padding: 8px 12px; border-radius: 6px; transition: all 0.3s ease;" onmouseover="this.style.background='rgba(255,255,255,0.2)'" onmouseout="this.style.background='rgba(255,255,255,0.1)'">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
        </div>
    </div>

    <!-- Mobile Menu -->
    <div id="mobile-menu" style="display: none; background: #0a3d91; border-top: 1px solid rgba(255,255,255,0.1);">
        <div style="max-width: 1200px; margin: 0 auto; padding: 20px;">
            <div style="display: flex; flex-direction: column; gap: 15px;">
                <a href="<?php echo e(route('home')); ?>" style="color: white; text-decoration: none; padding: 10px; border-radius: 4px; <?php echo e(request()->routeIs('home') ? 'background-color: rgba(255,255,255,0.1);' : ''); ?>">HOME</a>
                <a href="<?php echo e(route('profil')); ?>" style="color: white; text-decoration: none; padding: 10px; border-radius: 4px; <?php echo e(request()->routeIs('profil') || request()->routeIs('profile.show') ? 'background-color: rgba(255,255,255,0.1);' : ''); ?>">PROFIL</a>
                <a href="<?php echo e(route('artikel')); ?>" style="color: white; text-decoration: none; padding: 10px; border-radius: 4px; <?php echo e(request()->routeIs('artikel') ? 'background-color: rgba(255,255,255,0.1);' : ''); ?>">ARTIKEL</a>
                <a href="<?php echo e(route('download')); ?>" style="color: white; text-decoration: none; padding: 10px; border-radius: 4px; <?php echo e(request()->routeIs('download') ? 'background-color: rgba(255,255,255,0.1);' : ''); ?>">DOWNLOAD</a>
                <a href="<?php echo e(route('kontak')); ?>" style="color: white; text-decoration: none; padding: 10px; border-radius: 4px; <?php echo e(request()->routeIs('kontak') ? 'background-color: rgba(255,255,255,0.1);' : ''); ?>">KONTAK</a>

                <?php if(auth()->guard()->check()): ?>
                    <div style="border-top: 1px solid rgba(255,255,255,0.4); margin-top: 20px; padding-top: 20px;">
                        <!-- Mobile Admin Header -->
                        <div style="display: flex; align-items: center; gap: 12px; margin-bottom: 15px; padding: 12px; background: linear-gradient(135deg, rgba(255,255,255,0.1), rgba(255,255,255,0.05)); border-radius: 12px; border: 1px solid rgba(255,255,255,0.2);">
                            <div style="width: 36px; height: 36px; border-radius: 50%; background: linear-gradient(135deg, #667eea, #764ba2); display: flex; align-items: center; justify-content: center; font-size: 16px; font-weight: bold; color: white;">
                                <?php echo e(strtoupper(substr(Auth::user()->name, 0, 1))); ?>

                            </div>
                            <div style="flex: 1;">
                                <div style="color: white; font-size: 14px; font-weight: 600; margin-bottom: 2px;"><?php echo e(Auth::user()->name); ?></div>
                                <div style="color: rgba(255,255,255,0.8); font-size: 12px;">
                                    <?php if(Auth::user()->isSuperAdmin()): ?>
                                        Super Admin
                                    <?php else: ?>
                                        Admin
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Mobile Admin Menu -->
                        <a href="<?php echo e(route('dashboard')); ?>" style="display: flex; align-items: center; gap: 12px; color: white; text-decoration: none; padding: 12px 16px; border-radius: 10px; background: rgba(255,255,255,0.1); margin-bottom: 8px; transition: all 0.3s ease; border: 1px solid rgba(255,255,255,0.2);"
                           onmouseover="this.style.background='rgba(255,255,255,0.15)'; this.style.transform='translateX(4px)'"
                           onmouseout="this.style.background='rgba(255,255,255,0.1)'; this.style.transform='translateX(0)'">
                            <div style="width: 24px; height: 24px; border-radius: 8px; background: linear-gradient(135deg, #667eea, #764ba2); display: flex; align-items: center; justify-content: center;">
                                <svg width="14" height="14" viewBox="0 0 24 24" fill="none">
                                    <path d="M3 7V5C3 4.44772 3.44772 4 4 4H20C20.5523 4 21 4.44772 21 5V7M3 7V19C3 19.5523 3.44772 20 4 20H20C20.5523 20 21 19.5523 21 19V7M3 7H21M12 11V15M9 13H15" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                                </svg>
                            </div>
                            <span style="font-weight: 500;">Dashboard</span>
                        </a>

                        <?php if(Auth::user()->isSuperAdmin()): ?>
                        <a href="<?php echo e(route('admin.users.index')); ?>" style="display: flex; align-items: center; gap: 12px; color: white; text-decoration: none; padding: 12px 16px; border-radius: 10px; background: rgba(255,255,255,0.1); margin-bottom: 8px; transition: all 0.3s ease; border: 1px solid rgba(255,255,255,0.2);"
                           onmouseover="this.style.background='rgba(255,255,255,0.15)'; this.style.transform='translateX(4px)'"
                           onmouseout="this.style.background='rgba(255,255,255,0.1)'; this.style.transform='translateX(0)'">
                            <div style="width: 24px; height: 24px; border-radius: 8px; background: linear-gradient(135deg, #ff6b6b, #ee5a24); display: flex; align-items: center; justify-content: center;">
                                <svg width="14" height="14" viewBox="0 0 24 24" fill="none">
                                    <path d="M17 20H7C5.89543 20 5 19.1046 5 18V9C5 7.89543 5.89543 7 7 7H17C18.1046 7 19 7.89543 19 9V18C19 19.1046 18.1046 20 17 20Z" stroke="white" stroke-width="1.5"/>
                                    <path d="M12 4V7M9 4V7M15 4V7" stroke="white" stroke-width="1.5" stroke-linecap="round"/>
                                    <circle cx="12" cy="14" r="1.5" fill="white"/>
                                </svg>
                            </div>
                            <span style="font-weight: 500;">Kelola Users</span>
                        </a>
                        <?php endif; ?>

                        <!-- Logout Button -->
                        <form method="POST" action="<?php echo e(route('logout')); ?>" style="margin: 0;">
                            <?php echo csrf_field(); ?>
                            <button type="submit" style="width: 100%; display: flex; align-items: center; gap: 12px; color: #dc3545; background: linear-gradient(135deg, rgba(220, 53, 69, 0.1), rgba(220, 53, 69, 0.05)); border: 1px solid rgba(220, 53, 69, 0.3); padding: 12px 16px; border-radius: 10px; cursor: pointer; font-weight: 500; transition: all 0.3s ease;"
                                    onmouseover="this.style.background='linear-gradient(135deg, rgba(220, 53, 69, 0.15), rgba(220, 53, 69, 0.1))'; this.style.transform='translateX(4px)'"
                                    onmouseout="this.style.background='linear-gradient(135deg, rgba(220, 53, 69, 0.1), rgba(220, 53, 69, 0.05))'; this.style.transform='translateX(0)'">
                                <div style="width: 24px; height: 24px; border-radius: 8px; background: linear-gradient(135deg, #dc3545, #c82333); display: flex; align-items: center; justify-content: center;">
                                    <svg width="14" height="14" viewBox="0 0 24 24" fill="none">
                                        <path d="M9 21H5C4.46957 21 3.96086 20.7893 3.58579 20.4142C3.21071 20.0391 3 19.5304 3 19V5C3 4.46957 3.21071 3.96086 3.58579 3.58579C3.96086 3.21071 4.46957 3 5 3H9M16 17L21 12M21 12L16 7M21 12H9" stroke="white" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                                    </svg>
                                </div>
                                <span>Logout</span>
                            </button>
                        </form>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</nav>

<script>
function toggleDropdown(id) {
    const dropdown = document.getElementById(id);
    const isVisible = dropdown.style.display === 'block';
    dropdown.style.display = isVisible ? 'none' : 'block';
}

function showDropdown(id) {
    const dropdown = document.getElementById(id);
    dropdown.style.display = 'block';
}

function hideDropdown(id) {
    const dropdown = document.getElementById(id);
    dropdown.style.display = 'none';
}

// Close admin dropdown when clicking outside (only for click-based dropdowns)
document.addEventListener('click', function(event) {
    const adminDropdown = document.getElementById('adminDropdown');
    if (adminDropdown && !adminDropdown.contains(event.target) && !event.target.closest('[onclick*="toggleDropdown"]')) {
        adminDropdown.style.display = 'none';
    }
});

function toggleMobileMenu() {
    const menu = document.getElementById('mobile-menu');
    const isVisible = menu.style.display === 'block';
    menu.style.display = isVisible ? 'none' : 'block';
}

// Handle mobile menu visibility
window.addEventListener('resize', function() {
    const mobileMenu = document.getElementById('mobile-menu');
    const mobileButton = document.getElementById('mobile-menu-button');

    if (window.innerWidth > 768) {
        mobileMenu.style.display = 'none';
        mobileButton.style.display = 'none';
    } else {
        mobileButton.style.display = 'block';
    }
});

// Initialize on load
window.addEventListener('load', function() {
    if (window.innerWidth <= 768) {
        document.getElementById('mobile-menu-button').style.display = 'block';
    }
});
</script>

<style>
    /* Responsive Navigation Styles */
    @media (max-width: 1200px) {
        .nav-container {
            max-width: 100%;
            padding: 0 15px;
        }
    }

    @media (max-width: 1024px) {
        .nav-container {
            padding: 0 15px;
        }

        .desktop-nav {
            gap: 20px;
        }

        .logo img {
            height: 35px;
        }
    }

    @media (max-width: 768px) {
        nav {
            padding: 6px 0;
        }

        .nav-container {
            padding: 0 10px;
        }

        .desktop-nav {
            display: none;
        }

        .logo img {
            height: 30px;
            margin-left: -80px;
        }

        .mobile-menu-button {
            display: block !important;
        }

        .mobile-menu {
            display: none;
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            background: linear-gradient(135deg, #2a5298 0%, #1e3c72 100%);
            padding: 15px 0;
            box-shadow: 0 4px 15px rgba(0,0,0,0.2);
        }

        .mobile-menu.active {
            display: block;
        }

        .mobile-menu a {
            display: block;
            padding: 12px 20px;
            color: white;
            text-decoration: none;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            transition: background-color 0.3s ease;
        }

        .mobile-menu a:hover {
            background-color: rgba(255,255,255,0.1);
        }
    }

    @media (max-width: 480px) {
        nav {
            padding: 4px 0;
        }

        .nav-container {
            padding: 0 8px;
        }

        .logo img {
            height: 28px;
            margin-left: -60px;
        }

        .mobile-menu-button {
            padding: 6px;
        }

        .mobile-menu-button i {
            font-size: 18px;
        }

        .mobile-menu a {
            padding: 15px 20px;
            font-size: 16px;
        }
    }
</style>
<?php /**PATH C:\xampp\htdocs\Spm1\resources\views/layouts/navigation.blade.php ENDPATH**/ ?>