

<?php $__env->startSection('title', 'Kelola Users - Admin Panel'); ?>

<?php $__env->startSection('page-title', 'Kelola Users'); ?>

<?php $__env->startSection('content'); ?>
<div class="breadcrumb">
    <a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
    <span>/</span>
    <span>Kelola Users</span>
</div>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
    <h1 style="color: #0a3d91; font-size: 2rem; margin: 0;">Kelola Users</h1>
    <a href="<?php echo e(route('admin.users.create')); ?>" style="background: #0a3d91; color: white; padding: 12px 24px; text-decoration: none; border-radius: 8px; font-weight: bold;">
        + Tambah User
    </a>
</div>

        <?php if(session('success')): ?>
            <div style="background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin-bottom: 20px; border: 1px solid #c3e6cb;">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div style="background: #f8d7da; color: #721c24; padding: 15px; border-radius: 8px; margin-bottom: 20px; border: 1px solid #f5c6cb;">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <div style="background: white; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); overflow: hidden;">
            <div style="padding: 20px;">
                <table style="width: 100%; border-collapse: collapse;">
                    <thead>
                        <tr style="border-bottom: 2px solid #eee;">
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Nama</th>
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Email</th>
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Role</th>
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Status</th>
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Dibuat</th>
                            <th style="padding: 12px; text-align: center; font-weight: bold; color: #0a3d91;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr style="border-bottom: 1px solid #eee;">
                                <td style="padding: 12px;">
                                    <div style="font-weight: bold; color: #333;"><?php echo e($user->name); ?></div>
                                    <?php if($user->id === auth()->id()): ?>
                                        <span style="background: #e9ecef; color: #495057; padding: 2px 6px; border-radius: 3px; font-size: 0.8rem;">(Anda)</span>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 12px;">
                                    <?php echo e($user->email); ?>

                                </td>
                                <td style="padding: 12px;">
                                    <?php if($user->isSuperAdmin()): ?>
                                        <span style="background: #dc3545; color: white; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem; font-weight: bold;">
                                            Super Admin
                                        </span>
                                    <?php else: ?>
                                        <span style="background: #ffc107; color: #212529; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                            Admin
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 12px;">
                                    <?php if($user->email_verified_at): ?>
                                        <span style="background: #d4edda; color: #155724; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                            Terverifikasi
                                        </span>
                                    <?php else: ?>
                                        <span style="background: #fff3cd; color: #856404; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                            Belum Verifikasi
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 12px;">
                                    <?php echo e($user->created_at->format('d M Y')); ?>

                                </td>
                                <td style="padding: 12px; text-align: center;">
                                    <div style="display: flex; gap: 8px; justify-content: center;">
                                        <a href="<?php echo e(route('admin.users.show', $user)); ?>" style="background: #17a2b8; color: white; padding: 6px 12px; text-decoration: none; border-radius: 4px; font-size: 0.9rem;">
                                            Lihat
                                        </a>
                                        <a href="<?php echo e(route('admin.users.edit', $user)); ?>" style="background: #ffc107; color: #212529; padding: 6px 12px; text-decoration: none; border-radius: 4px; font-size: 0.9rem;">
                                            Edit
                                        </a>
                                        <?php if($user->id !== auth()->id() && !($user->isSuperAdmin() && !auth()->user()->isSuperAdmin())): ?>
                                            <form action="<?php echo e(route('admin.users.destroy', $user)); ?>" method="POST" style="display: inline;" onsubmit="return confirm('Apakah Anda yakin ingin menghapus user ini?')">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="submit" style="background: #dc3545; color: white; padding: 6px 12px; border: none; border-radius: 4px; font-size: 0.9rem; cursor: pointer;">
                                                    Hapus
                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" style="padding: 40px; text-align: center; color: #666;">
                                    Belum ada data user.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <?php if($users->hasPages()): ?>
            <div style="margin-top: 20px;">
                <?php echo e($users->links()); ?>

            </div>
        <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Spm1\resources\views/admin/users/index.blade.php ENDPATH**/ ?>