<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     * @param  string  $role
     */
    public function handle(Request $request, Closure $next, string $role): Response
    {
        if (!auth()->check()) {
            return redirect()->route('login');
        }

        $user = auth()->user();

        // Check role permissions
        switch ($role) {
            case 'super_admin':
                if (!$user->isSuperAdmin()) {
                    abort(403, 'Access denied. Super Admin privileges required.');
                }
                break;

            case 'admin':
                if (!$user->isAdmin()) {
                    abort(403, 'Access denied. Admin privileges required.');
                }
                break;

            default:
                abort(403, 'Invalid role specified.');
        }

        return $next($request);
    }
}
