<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('articles', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->text('content');
            $table->text('excerpt')->nullable(); // ringkasan artikel
            $table->string('image')->nullable(); // path gambar utama
            $table->string('category')->nullable(); // kategori artikel
            $table->string('author')->nullable(); // penulis artikel
            $table->timestamp('published_at')->nullable(); // tanggal publikasi
            $table->boolean('is_featured')->default(false); // artikel unggulan
            $table->integer('view_count')->default(0); // jumlah dilihat
            $table->boolean('is_active')->default(true); // status aktif
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('articles');
    }
};
