<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\User;

class AdminUserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Buat super admin jika belum ada
        if (!User::where('email', 'superadmin@poltek-atk.ac.id')->exists()) {
            User::create([
                'name' => 'Super Admin',
                'email' => 'superadmin@poltek-atk.ac.id',
                'password' => bcrypt('super123'),
                'role' => 'super_admin',
                'email_verified_at' => now(),
            ]);
        }

        // Buat admin biasa jika belum ada
        if (!User::where('email', 'admin@poltek-atk.ac.id')->exists()) {
            User::create([
                'name' => 'Admin SPM',
                'email' => 'admin@poltek-atk.ac.id',
                'password' => bcrypt('admin123'),
                'role' => 'admin',
                'email_verified_at' => now(),
            ]);
        }
    }
}
