<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Article;

class ArticleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $articles = [
            [
                'title' => 'Standar Mutu Baru 2024',
                'slug' => 'standar-mutu-baru-2024',
                'excerpt' => 'Peluncuran standar mutu terbaru yang akan diterapkan di seluruh industri nasional mulai tahun 2024.',
                'content' => '<p>Badan Penjaminan Mutu Universitas Islam Indonesia dengan bangga mengumumkan peluncuran Standar Mutu Baru 2024. Standar ini merupakan hasil kajian mendalam terhadap perkembangan mutu pendidikan tinggi nasional dan internasional.</p>

                <h3>Fokus Utama Standar Baru</h3>
                <ul>
                    <li>Peningkatan kompetensi lulusan</li>
                    <li>Penguatan kurikulum berbasis outcome</li>
                    <li>Pengembangan sistem evaluasi yang komprehensif</li>
                    <li>Integrasi teknologi digital dalam proses pembelajaran</li>
                </ul>

                <h3>Implementasi</h3>
                <p>Standar mutu baru ini akan diimplementasikan secara bertahap mulai semester genap 2024. BPM UII akan menyediakan panduan dan pelatihan bagi seluruh fakultas dan program studi.</p>

                <p>Dengan diterapkannya standar mutu baru ini, diharapkan mutu pendidikan di UII dapat meningkat signifikan dan mampu bersaing di tingkat nasional maupun internasional.</p>',
                'category' => 'standar-mutu',
                'author' => 'Tim BPM UII',
                'published_at' => now()->subDays(5),
                'is_featured' => true,
                'is_active' => true,
            ],
            [
                'title' => 'Penghargaan Akreditasi',
                'slug' => 'penghargaan-akreditasi',
                'excerpt' => '50 lembaga berhasil mendapatkan akreditasi A dalam program penilaian mutu tahunan.',
                'content' => '<p>Program akreditasi tahunan BPM UII telah mencapai hasil yang sangat menggembirakan. Sebanyak 50 lembaga di lingkungan UII berhasil mendapatkan akreditasi A dalam proses penilaian mutu yang ketat.</p>

                <h3>Rincian Penghargaan</h3>
                <ul>
                    <li>Akreditasi A: 50 lembaga</li>
                    <li>Akreditasi B: 25 lembaga</li>
                    <li>Akreditasi C: 5 lembaga</li>
                    <li>Total lembaga yang dinilai: 80 lembaga</li>
                </ul>

                <h3>Faktor Keberhasilan</h3>
                <p>Keberhasilan ini tidak terlepas dari komitmen pimpinan dan seluruh civitas akademika UII dalam menerapkan sistem penjaminan mutu. Beberapa faktor penentu keberhasilan:</p>
                <ol>
                    <li>Konsistensi implementasi SPMI</li>
                    <li>Kualitas sumber daya manusia</li>
                    <li>Dukungan sarana dan prasarana</li>
                    <li>Kerjasama yang baik antar unit</li>
                </ol>

                <p>BPM UII mengucapkan selamat kepada seluruh lembaga yang berhasil mendapatkan akreditasi A dan berharap dapat mempertahankan serta meningkatkan mutu di masa mendatang.</p>',
                'category' => 'akreditasi',
                'author' => 'BPM UII',
                'published_at' => now()->subDays(10),
                'is_featured' => true,
                'is_active' => true,
            ],
            [
                'title' => 'Workshop Sistem Mutu',
                'slug' => 'workshop-sistem-mutu',
                'excerpt' => 'Jadwal workshop implementasi sistem manajemen mutu untuk UMKM di seluruh Indonesia.',
                'content' => '<p>BPM UII akan menyelenggarakan serangkaian workshop implementasi sistem manajemen mutu khusus untuk Usaha Mikro, Kecil, dan Menengah (UMKM) di seluruh Indonesia.</p>

                <h3>Tujuan Workshop</h3>
                <ul>
                    <li>Meningkatkan pemahaman UMKM tentang pentingnya sistem mutu</li>
                    <li>Menyediakan panduan praktis implementasi sistem mutu</li>
                    <li>Mendorong UMKM untuk mendapatkan sertifikasi mutu</li>
                    <li>Membangun jaringan antar pelaku UMKM</li>
                </ul>

                <h3>Jadwal Workshop</h3>
                <table style="width: 100%; border-collapse: collapse; margin: 20px 0;">
                    <thead>
                        <tr style="background-color: #f8f9fa;">
                            <th style="border: 1px solid #dee2e6; padding: 12px; text-align: left;">Kota</th>
                            <th style="border: 1px solid #dee2e6; padding: 12px; text-align: left;">Tanggal</th>
                            <th style="border: 1px solid #dee2e6; padding: 12px; text-align: left;">Lokasi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td style="border: 1px solid #dee2e6; padding: 12px;">Jakarta</td>
                            <td style="border: 1px solid #dee2e6; padding: 12px;">15-16 Februari 2024</td>
                            <td style="border: 1px solid #dee2e6; padding: 12px;">Hotel Borobudur</td>
                        </tr>
                        <tr style="background-color: #f8f9fa;">
                            <td style="border: 1px solid #dee2e6; padding: 12px;">Surabaya</td>
                            <td style="border: 1px solid #dee2e6; padding: 12px;">22-23 Februari 2024</td>
                            <td style="border: 1px solid #dee2e6; padding: 12px;">Hotel Bumi Surabaya</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #dee2e6; padding: 12px;">Yogyakarta</td>
                            <td style="border: 1px solid #dee2e6; padding: 12px;">1-2 Maret 2024</td>
                            <td style="border: 1px solid #dee2e6; padding: 12px;">Gedung UII</td>
                        </tr>
                    </tbody>
                </table>

                <h3>Pendaftaran</h3>
                <p>Pendaftaran workshop dapat dilakukan melalui website BPM UII atau menghubungi contact center kami. Kuota terbatas, segera daftar untuk mendapatkan tempat.</p>

                <p>Biaya workshop: Rp 500.000,- per peserta (termasuk materi, sertifikat, dan konsumsi)</p>',
                'category' => 'workshop',
                'author' => 'Tim Pelatihan BPM UII',
                'published_at' => now()->subDays(15),
                'is_featured' => false,
                'is_active' => true,
            ],
            [
                'title' => 'Audit Mutu Internal 2024',
                'slug' => 'audit-mutu-internal-2024',
                'excerpt' => 'Jadwal dan persiapan audit mutu internal untuk seluruh program studi di UII.',
                'content' => '<p>Audit Mutu Internal (AMI) 2024 telah memasuki tahap persiapan intensif. BPM UII akan melakukan audit terhadap seluruh program studi di lingkungan Universitas Islam Indonesia.</p>

                <h3>Tujuan AMI 2024</h3>
                <ul>
                    <li>Mengevaluasi implementasi SPMI di setiap program studi</li>
                    <li>Mengidentifikasi kekuatan dan area perbaikan</li>
                    <li>Memberikan rekomendasi perbaikan mutu</li>
                    <li>Mempersiapkan program studi menghadapi akreditasi eksternal</li>
                </ul>

                <h3>Jadwal AMI</h3>
                <p>Audit akan dilaksanakan dalam tiga gelombang:</p>
                <ol>
                    <li><strong>Gelombang I:</strong> 1-15 Maret 2024 (Program Studi Sains dan Teknologi)</li>
                    <li><strong>Gelombang II:</strong> 16-30 Maret 2024 (Program Studi Sosial dan Humaniora)</li>
                    <li><strong>Gelombang III:</strong> 1-15 April 2024 (Program Studi Agama dan Kesehatan)</li>
                </ol>

                <h3>Persiapan Yang Diperlukan</h3>
                <p>Setiap program studi diminta mempersiapkan dokumen-dokumen berikut:</p>
                <ul>
                    <li>Buku Mutu Program Studi</li>
                    <li>Data implementasi kurikulum</li>
                    <li>Hasil evaluasi pembelajaran</li>
                    <li>Dokumentasi kegiatan kemahasiswaan</li>
                    <li>Laporan audit sebelumnya dan tindak lanjut</li>
                </ul>

                <p>BPM UII telah menyiapkan tim auditor internal yang kompeten untuk melaksanakan audit ini. Kami mengimbau seluruh program studi untuk mempersiapkan diri dengan baik.</p>',
                'category' => 'audit',
                'author' => 'Tim Audit BPM UII',
                'published_at' => now()->subDays(20),
                'is_featured' => false,
                'is_active' => true,
            ],
            [
                'title' => 'Benchmarking Mutu dengan Universitas Terbaik',
                'slug' => 'benchmarking-mutu-universitas-terbaik',
                'excerpt' => 'Kunjungan studi banding ke universitas-universitas terbaik di Asia untuk meningkatkan mutu pendidikan.',
                'content' => '<p>BPM UII telah melaksanakan program benchmarking mutu dengan kunjungan studi banding ke beberapa universitas terbaik di Asia. Program ini bertujuan untuk belajar dari praktik terbaik dalam penjaminan mutu pendidikan tinggi.</p>

                <h3>Universitas Tujuan</h3>
                <ol>
                    <li>National University of Singapore (NUS)</li>
                    <li>University of Tokyo</li>
                    <li>King Abdulaziz University</li>
                    <li>Universiti Malaya</li>
                </ol>

                <h3>Fokus Benchmarking</h3>
                <ul>
                    <li>Sistem penjaminan mutu terintegrasi</li>
                    <li>Implementasi learning outcome</li>
                    <li>Sistem evaluasi pembelajaran</li>
                    <li>Pengembangan kompetensi dosen</li>
                    <li>Inovasi dalam assessment</li>
                </ul>

                <h3>Hasil Benchmarking</h3>
                <p>Dari kunjungan studi banding ini, BPM UII memperoleh insights berharga yang akan diimplementasikan dalam pengembangan sistem mutu UII:</p>

                <p><strong>1. Digital Quality Management System</strong><br>
                Implementasi sistem manajemen mutu berbasis digital untuk efisiensi dan transparansi.</p>

                <p><strong>2. Outcome-Based Education Framework</strong><br>
                Penguatan kurikulum berbasis capaian pembelajaran yang jelas dan terukur.</p>

                <p><strong>3. Continuous Professional Development</strong><br>
                Program pengembangan kompetensi dosen yang berkelanjutan dan terstruktur.</p>

                <p><strong>4. Stakeholder Engagement</strong><br>
                Peningkatan keterlibatan stakeholder dalam proses penjaminan mutu.</p>

                <p>Hasil benchmarking ini akan menjadi acuan bagi pengembangan SPMI UII dalam beberapa tahun ke depan.</p>',
                'category' => 'benchmarking',
                'author' => 'Tim Benchmarking BPM UII',
                'published_at' => now()->subDays(25),
                'is_featured' => true,
                'is_active' => true,
            ],
        ];

        foreach ($articles as $article) {
            Article::create($article);
        }
    }
}
