<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DocumentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $documents = [
            [
                'title' => 'Panduan Sistem Penjaminan Mutu Internal (SPMI)',
                'description' => 'Dokumen panduan lengkap untuk implementasi SPMI di Universitas Islam Indonesia',
                'file_name' => 'panduan_spmi_uii_2024.pdf',
                'file_path' => 'documents/sample_spmi_guide.pdf', // Placeholder path
                'file_size' => 2048576, // 2MB in bytes
                'file_type' => 'application/pdf',
                'category' => 'dokumen-mutu',
                'is_active' => true,
            ],
            [
                'title' => 'Standar Akreditasi Program Studi',
                'description' => 'Dokumen standar akreditasi yang digunakan untuk evaluasi program studi',
                'file_name' => 'standar_akreditasi_prodi.pdf',
                'file_path' => 'documents/sample_accreditation_standard.pdf',
                'file_size' => 1536000, // 1.5MB
                'file_type' => 'application/pdf',
                'category' => 'standar',
                'is_active' => true,
            ],
            [
                'title' => 'Formulir Permohonan Sertifikasi',
                'description' => 'Formulir untuk permohonan sertifikasi mutu program studi',
                'file_name' => 'formulir_sertifikasi.docx',
                'file_path' => 'documents/sample_certification_form.docx',
                'file_size' => 512000, // 500KB
                'file_type' => 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
                'category' => 'formulir',
                'is_active' => true,
            ],
            [
                'title' => 'Prosedur Audit Internal',
                'description' => 'Panduan lengkap prosedur pelaksanaan audit internal',
                'file_name' => 'prosedur_audit_internal.pdf',
                'file_path' => 'documents/sample_audit_procedure.pdf',
                'file_size' => 1024000, // 1MB
                'file_type' => 'application/pdf',
                'category' => 'prosedur',
                'is_active' => true,
            ],
            [
                'title' => 'Laporan Akreditasi Tahunan 2024',
                'description' => 'Laporan hasil akreditasi program studi tahun 2024',
                'file_name' => 'laporan_akreditasi_2024.pdf',
                'file_path' => 'documents/sample_annual_report.pdf',
                'file_size' => 3072000, // 3MB
                'file_type' => 'application/pdf',
                'category' => 'laporan',
                'is_active' => true,
            ],
        ];

        foreach ($documents as $document) {
            \App\Models\Document::create($document);
        }
    }
}
