<?php
echo "<h1>🌐 CHECK URL CONFIGURATION</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .success{color:green;font-weight:bold;} .error{color:red;font-weight:bold;} .warning{color:orange;font-weight:bold;} .info{color:blue;} pre{background:#f5f5f5;padding:10px;border-radius:4px;margin:10px 0;}</style>";

// Initialize Laravel
try {
    require_once '../vendor/autoload.php';
    $app = require_once '../bootstrap/app.php';
    $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
    $kernel->bootstrap();
} catch (Exception $e) {
    echo "<p class='error'>❌ Laravel initialization failed: " . $e->getMessage() . "</p>";
    exit;
}

echo "<h2>1. Environment Configuration</h2>";
$envFile = '../.env';
if (file_exists($envFile)) {
    $envContent = file_get_contents($envFile);

    // Check APP_URL
    if (preg_match('/^APP_URL=(.+)$/m', $envContent, $matches)) {
        $appUrl = trim($matches[1]);
        echo "<p><strong>APP_URL in .env:</strong> <code>$appUrl</code></p>";

        $currentHost = $_SERVER['HTTP_HOST'] ?? 'unknown';
        $expectedUrl = "http://$currentHost";

        if ($appUrl === $expectedUrl) {
            echo "<p class='success'>✅ APP_URL matches current host</p>";
        } elseif ($appUrl === 'http://192.168.10.70') {
            echo "<p class='success'>✅ APP_URL is correct for this server</p>";
        } else {
            echo "<p class='warning'>⚠️ APP_URL may not match current host</p>";
            echo "<p class='info'>Current host: $currentHost</p>";
            echo "<p class='info'>Expected: $expectedUrl</p>";
        }
    } else {
        echo "<p class='error'>❌ APP_URL not found in .env</p>";
    }
} else {
    echo "<p class='error'>❌ .env file not found</p>";
}

echo "<h2>2. Server Information</h2>";
echo "<p><strong>HTTP_HOST:</strong> " . ($_SERVER['HTTP_HOST'] ?? 'not set') . "</p>";
echo "<p><strong>SERVER_NAME:</strong> " . ($_SERVER['SERVER_NAME'] ?? 'not set') . "</p>";
echo "<p><strong>REQUEST_URI:</strong> " . ($_SERVER['REQUEST_URI'] ?? 'not set') . "</p>";
echo "<p><strong>SCRIPT_NAME:</strong> " . ($_SERVER['SCRIPT_NAME'] ?? 'not set') . "</p>";
echo "<p><strong>PHP_SELF:</strong> " . ($_SERVER['PHP_SELF'] ?? 'not set') . "</p>";

echo "<h2>3. Route URL Generation Test</h2>";
try {
    // Test route URL generation
    $homeUrl = route('home');
    $loginUrl = route('login');

    echo "<p><strong>Home route URL:</strong> <code>$homeUrl</code></p>";
    echo "<p><strong>Login route URL:</strong> <code>$loginUrl</code></p>";

    // Check if URLs are absolute or relative
    if (strpos($homeUrl, 'http') === 0) {
        echo "<p class='success'>✅ Routes generate absolute URLs</p>";
    } else {
        echo "<p class='warning'>⚠️ Routes generate relative URLs</p>";
    }

    // Test URL components
    $parsed = parse_url($homeUrl);
    echo "<p><strong>Generated URL scheme:</strong> " . ($parsed['scheme'] ?? 'none') . "</p>";
    echo "<p><strong>Generated URL host:</strong> " . ($parsed['host'] ?? 'none') . "</p>";
    echo "<p><strong>Generated URL path:</strong> " . ($parsed['path'] ?? 'none') . "</p>";

} catch (Exception $e) {
    echo "<p class='error'>❌ Route URL generation failed: " . $e->getMessage() . "</p>";
}

echo "<h2>4. URL Rewriting Test</h2>";
// Test if .htaccess exists
$htaccessPath = '../.htaccess';
if (file_exists($htaccessPath)) {
    echo "<p class='success'>✅ .htaccess file exists</p>";

    $htaccessContent = file_get_contents($htaccessPath);
    if (strpos($htaccessContent, 'RewriteEngine On') !== false) {
        echo "<p class='success'>✅ URL rewriting appears enabled</p>";
    } else {
        echo "<p class='warning'>⚠️ URL rewriting may not be enabled</p>";
    }

    // Show relevant .htaccess content
    echo "<p><strong>.htaccess content (relevant lines):</strong></p>";
    $lines = explode("\n", $htaccessContent);
    $relevantLines = [];
    foreach ($lines as $line) {
        if (preg_match('/Rewrite|public|index\.php/i', $line)) {
            $relevantLines[] = $line;
        }
    }

    if (!empty($relevantLines)) {
        echo "<pre>" . implode("\n", $relevantLines) . "</pre>";
    }

} else {
    echo "<p class='error'>❌ .htaccess file not found</p>";
    echo "<p class='info'>This may cause 404 errors for routes other than /</p>";
}

echo "<h2>5. Direct Route Access Test</h2>";
// Test direct access to login route
$directLoginUrl = "http://" . ($_SERVER['HTTP_HOST'] ?? 'localhost') . "/login";

echo "<p><strong>Test direct login URL:</strong> <a href='$directLoginUrl' target='_blank'>$directLoginUrl</a></p>";
echo "<p class='info'>Click the link above to test if login page loads directly</p>";

// Test POST to login
echo "<h3>Test POST to /login</h3>";
echo "<form method='POST' action='/login' style='background:#f8f9fa;padding:15px;border-radius:8px;margin:10px 0;'>";
echo "<input type='hidden' name='_token' value='" . csrf_token() . "'>";
echo "<p><strong>Test login with known user:</strong></p>";
echo "<input type='email' name='email' value='superadmin@poltek-atk.ac.id' readonly style='margin:5px;padding:5px;'><br>";
echo "<input type='password' name='password' placeholder='Enter password' style='margin:5px;padding:5px;'><br>";
echo "<button type='submit' style='margin:5px;padding:8px 15px;background:#007bff;color:white;border:none;border-radius:4px;'>Test Login</button>";
echo "</form>";

echo "<h2>6. Diagnosis & Solutions</h2>";
echo "<div style='background:#e8f4f8;padding:20px;border-radius:8px;margin:20px 0;'>";

echo "<h3>🔍 POSSIBLE CAUSES OF 404 ON LOGIN:</h3>";

echo "<h4>1. APP_URL Mismatch</h4>";
echo "<p>If APP_URL in .env doesn't match the domain you're accessing, route URLs will be wrong.</p>";
echo "<p><strong>Current APP_URL:</strong> " . ($appUrl ?? 'not set') . "</p>";
echo "<p><strong>Current domain:</strong> http://" . ($_SERVER['HTTP_HOST'] ?? 'unknown') . "</p>";

echo "<h4>2. Missing .htaccess</h4>";
echo "<p>Without .htaccess, Apache can't rewrite URLs to index.php, causing 404 for all routes except /.</p>";
if (!file_exists($htaccessPath)) {
    echo "<p class='error'>❌ .htaccess is missing - this is likely the cause!</p>";
}

echo "<h4>3. URL Rewriting Disabled</h4>";
echo "<p>If mod_rewrite is disabled in Apache, URL rewriting won't work.</p>";

echo "<h3>🛠️ SOLUTIONS:</h3>";
echo "<ol>";
echo "<li><strong>Fix APP_URL:</strong> Set APP_URL=http://192.168.10.70 in .env</li>";
echo "<li><strong>Create .htaccess:</strong> Ensure .htaccess exists in project root</li>";
echo "<li><strong>Enable mod_rewrite:</strong> Make sure Apache has mod_rewrite enabled</li>";
echo "<li><strong>Test direct access:</strong> Try http://" . ($_SERVER['HTTP_HOST'] ?? 'localhost') . "/login</li>";
echo "</ol>";

echo "</div>";

echo "<h2>7. Quick Fix Actions</h2>";

// Fix APP_URL if needed
if (isset($appUrl) && $appUrl !== 'http://192.168.10.70') {
    echo "<p class='info'>🔧 Fixing APP_URL...</p>";
    $newEnvContent = preg_replace('/^APP_URL=.*/m', 'APP_URL=http://192.168.10.70', $envContent);

    if (file_put_contents($envFile, $newEnvContent)) {
        echo "<p class='success'>✅ APP_URL fixed to http://192.168.10.70</p>";
        echo "<p class='info'>Please refresh this page to see the changes</p>";
    } else {
        echo "<p class='error'>❌ Failed to fix APP_URL</p>";
    }
}

// Create .htaccess if missing
if (!file_exists($htaccessPath)) {
    echo "<p class='info'>🔧 Creating .htaccess file...</p>";

    $htaccessContent = '<IfModule mod_rewrite.c>
    <IfModule mod_negotiation.c>
        Options -MultiViews -Indexes
    </IfModule>

    RewriteEngine On

    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes If Not A Folder...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Send Requests To Front Controller...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>';

    if (file_put_contents('../.htaccess', $htaccessContent)) {
        echo "<p class='success'>✅ .htaccess file created</p>";
    } else {
        echo "<p class='error'>❌ Failed to create .htaccess</p>";
    }
}

echo "<hr>";
echo "<p><strong>URL configuration check completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?>
