<?php
echo "<h1>🛣️ DEBUG LARAVEL ROUTES & CONTROLLERS</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;font-size:14px;} .error{color:red;font-weight:bold;} .success{color:green;font-weight:bold;} .warning{color:orange;font-weight:bold;} .info{color:blue;} pre{background:#f5f5f5;padding:10px;border-radius:4px;margin:10px 0;max-height:300px;overflow:auto;}</style>";

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Step 1: Laravel Framework Setup</h2>";
try {
    require_once '../vendor/autoload.php';
    $app = require_once '../bootstrap/app.php';
    $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
    $kernel->bootstrap();
    echo "<p class='success'>✅ Laravel framework initialized</p>";
} catch (Exception $e) {
    echo "<p class='error'>❌ Framework setup failed: " . $e->getMessage() . "</p>";
    exit;
}

echo "<h2>Step 2: Route Registration Check</h2>";
try {
    $router = app('router');
    $routes = $router->getRoutes();
    $routeCount = count($routes);

    echo "<p class='success'>✅ Router initialized with $routeCount routes</p>";

    // Show some routes
    echo "<h3>Sample Routes (first 10):</h3>";
    echo "<table border='1' style='border-collapse:collapse;margin:10px 0;'>";
    echo "<tr><th>Method</th><th>URI</th><th>Name</th><th>Action</th></tr>";

    $count = 0;
    foreach ($routes as $route) {
        if ($count >= 10) break;

        $methods = implode('|', $route->methods());
        $uri = $route->uri();
        $name = $route->getName() ?: '-';
        $action = $route->getActionName() ?: '-';

        echo "<tr><td>$methods</td><td>$uri</td><td>$name</td><td>$action</td></tr>";
        $count++;
    }
    echo "</table>";

} catch (Exception $e) {
    echo "<p class='error'>❌ Route check failed: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
    exit;
}

echo "<h2>Step 3: Home Route Test</h2>";
try {
    // Test route resolution
    $request = \Illuminate\Http\Request::create('/');

    echo "<p class='info'>Testing route resolution for '/'</p>";

    $route = $router->getRoutes()->match($request);
    echo "<p class='success'>✅ Route matched: " . $route->uri() . "</p>";
    echo "<p class='info'>Route action: " . $route->getActionName() . "</p>";

} catch (Exception $e) {
    echo "<p class='error'>❌ Route resolution failed: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
    exit;
}

echo "<h2>Step 4: Controller Instantiation Test</h2>";
try {
    $controllerClass = 'App\Http\Controllers\BpmController';

    if (class_exists($controllerClass)) {
        echo "<p class='success'>✅ Controller class exists: $controllerClass</p>";

        $controller = app($controllerClass);
        echo "<p class='success'>✅ Controller instantiated successfully</p>";

        if (method_exists($controller, 'home')) {
            echo "<p class='success'>✅ home() method exists</p>";
        } else {
            echo "<p class='error'>❌ home() method missing</p>";
        }

    } else {
        echo "<p class='error'>❌ Controller class not found: $controllerClass</p>";
        exit;
    }

} catch (Exception $e) {
    echo "<p class='error'>❌ Controller test failed: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
    exit;
}

echo "<h2>Step 5: Controller Method Execution Test</h2>";
try {
    echo "<p class='info'>Testing BpmController::home() method execution</p>";

    $response = $controller->home();

    if ($response instanceof \Illuminate\View\View) {
        echo "<p class='success'>✅ Controller returned View object</p>";
        echo "<p class='info'>View name: " . $response->getName() . "</p>";

        $data = $response->getData();
        echo "<p class='info'>View data keys: " . implode(', ', array_keys($data)) . "</p>";

    } elseif ($response instanceof \Illuminate\Http\Response) {
        echo "<p class='success'>✅ Controller returned Response object</p>";
        echo "<p class='info'>Response content length: " . strlen($response->getContent()) . " characters</p>";
    } else {
        echo "<p class='warning'>⚠️ Controller returned unexpected type: " . get_class($response) . "</p>";
    }

} catch (Exception $e) {
    echo "<p class='error'>❌ Controller execution failed: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
    exit;
}

echo "<h2>Step 6: View Rendering Test</h2>";
try {
    echo "<p class='info'>Testing view rendering for 'pages.home'</p>";

    $view = view('pages.home', ['title' => 'Test Title']);
    echo "<p class='success'>✅ View 'pages.home' can be rendered</p>";

    $rendered = $view->render();
    echo "<p class='success'>✅ View rendered successfully (" . strlen($rendered) . " characters)</p>";

    // Check if view contains expected content
    if (strpos($rendered, 'Test Title') !== false) {
        echo "<p class='success'>✅ View contains passed data</p>";
    } else {
        echo "<p class='warning'>⚠️ View data not found in rendered output</p>";
    }

} catch (Exception $e) {
    echo "<p class='error'>❌ View rendering failed: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
    exit;
}

echo "<h2>Step 7: Middleware Test</h2>";
try {
    $middlewareGroups = config('app.middleware', []);
    echo "<p class='success'>✅ Middleware config loaded (" . count($middlewareGroups) . " groups)</p>";

    // Test if middleware classes exist
    $missingMiddleware = [];
    foreach ($middlewareGroups as $middleware) {
        if (is_string($middleware) && !class_exists($middleware)) {
            $missingMiddleware[] = $middleware;
        }
    }

    if (empty($missingMiddleware)) {
        echo "<p class='success'>✅ All middleware classes exist</p>";
    } else {
        echo "<p class='error'>❌ Missing middleware classes: " . implode(', ', $missingMiddleware) . "</p>";
    }

} catch (Exception $e) {
    echo "<p class='error'>❌ Middleware test failed: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<h2>Step 8: Full Request Simulation</h2>";
try {
    echo "<p class='info'>Simulating full HTTP request to '/'</p>";

    // Create a request
    $request = \Illuminate\Http\Request::create('/');
    $request->server->set('REQUEST_METHOD', 'GET');

    // Get the kernel
    $kernel = app(\Illuminate\Contracts\Http\Kernel::class);

    // Handle the request
    $response = $kernel->handle($request);

    echo "<p class='success'>✅ HTTP Kernel handled request successfully</p>";
    echo "<p class='info'>Response status: " . $response->getStatusCode() . "</p>";

    if ($response->getStatusCode() === 200) {
        echo "<p class='success'>✅ Response status is 200 OK</p>";
        $content = $response->getContent();
        echo "<p class='info'>Response content length: " . strlen($content) . " characters</p>";

        // Check for common Laravel error indicators
        if (strpos($content, 'Whoops') !== false) {
            echo "<p class='error'>❌ Laravel error page detected in response</p>";
        } elseif (strpos($content, 'Symfony') !== false && strpos($content, 'Exception') !== false) {
            echo "<p class='error'>❌ Symfony exception detected in response</p>";
        } else {
            echo "<p class='success'>✅ Response appears to be valid HTML</p>";
        }

    } else {
        echo "<p class='error'>❌ Response status is {$response->getStatusCode()}</p>";
    }

} catch (Exception $e) {
    echo "<p class='error'>❌ Full request simulation failed: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
    exit;
}

echo "<h1>🎉 SUCCESS! All Route & Controller Tests Passed</h1>";
echo "<div style='background:#d4edda;padding:20px;border-radius:8px;margin:20px 0;border:1px solid #c3e6cb;'>";
echo "<h3 style='color:#155724;'>✅ ROUTE & CONTROLLER SYSTEM WORKING!</h3>";
echo "<p style='color:#155724;'>All components are functioning correctly:</p>";
echo "<ul style='color:#155724;'>";
echo "<li>Routes registered and accessible</li>";
echo "<li>Controllers can be instantiated</li>";
echo "<li>Methods execute without errors</li>";
echo "<li>Views render successfully</li>";
echo "<li>Middleware system working</li>";
echo "<li>HTTP request handling OK</li>";
echo "</ul>";
echo "<br>";
echo "<p style='color:#155724;'><strong>🚀 Your Laravel application should work now!</strong></p>";
echo "<p><a href='http://192.168.10.70' target='_blank' style='color:#155724;font-weight:bold;'>Access Application → http://192.168.10.70</a></p>";
echo "</div>";

echo "<hr>";
echo "<p><strong>Route debug completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?>
