<?php
echo "<h1>🚀 FINAL DATABASE FIX - NO QUESTIONS ASKED</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .success{color:green;font-weight:bold;font-size:18px;} .error{color:red;font-weight:bold;font-size:16px;} .info{color:blue;font-size:14px;}</style>";

$envFile = '../.env';

// Step 1: Force localhost connection (since app and DB should be on same server)
echo "<h2>Step 1: Force Localhost Connection</h2>";
$envContent = "APP_NAME=Spm1
APP_ENV=local
APP_KEY=base64:final_fix_key_2024
APP_DEBUG=true
APP_TIMEZONE=UTC
APP_URL=http://192.168.10.70

DB_CONNECTION=mysql
DB_HOST=localhost
DB_PORT=3306
DB_DATABASE=spm_db
DB_USERNAME=root
DB_PASSWORD=

SESSION_DRIVER=database
CACHE_STORE=database
QUEUE_CONNECTION=database";

if (file_put_contents($envFile, $envContent)) {
    echo "<p class='success'>✅ .env file updated with localhost configuration</p>";
} else {
    echo "<p class='error'>❌ Failed to update .env file</p>";
}

// Step 2: Test all possible connections
echo "<h2>Step 2: Testing All Possible Connections</h2>";
$connectionTests = [
    ['host' => 'localhost', 'name' => 'Localhost'],
    ['host' => '127.0.0.1', 'name' => '127.0.0.1'],
    ['host' => '192.168.10.70', 'name' => 'Server IP'],
];

$workingConnection = null;

foreach ($connectionTests as $test) {
    echo "<h3>Testing {$test['name']} ({$test['host']})</h3>";
    try {
        $pdo = new PDO("mysql:host={$test['host']};dbname=spm_db;charset=utf8", 'root', '');
        echo "<p class='success'>✅ Direct MySQL connection successful to {$test['host']}</p>";

        // Test Laravel with this host
        $testEnv = str_replace('DB_HOST=localhost', "DB_HOST={$test['host']}", $envContent);
        file_put_contents($envFile, $testEnv);

        require_once '../vendor/autoload.php';
        $app = require_once '../bootstrap/app.php';
        $app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

        $laravelPdo = DB::connection('mysql')->getPdo();
        echo "<p class='success'>✅ Laravel database connection successful!</p>";

        // Test the problematic query
        $profiles = DB::table('profiles')->where('is_active', 1)->orderBy('order')->orderBy('created_at', 'desc')->get();
        echo "<p class='success'>✅ Profile query works! Found {$profiles->count()} profiles</p>";

        $workingConnection = $test;
        break;

    } catch (Exception $e) {
        echo "<p class='error'>❌ Failed: " . $e->getMessage() . "</p>";
    }
}

if ($workingConnection) {
    // Save the working configuration
    $finalEnv = str_replace('DB_HOST=localhost', "DB_HOST={$workingConnection['host']}", $envContent);
    file_put_contents($envFile, $finalEnv);

    echo "<h2>🎉 SUCCESS! DATABASE CONNECTED!</h2>";
    echo "<div style='background:#d4edda;border:1px solid #c3e6cb;padding:20px;border-radius:8px;margin:20px 0;'>";
    echo "<h3>✅ WORKING CONFIGURATION:</h3>";
    echo "<p><strong>DB_HOST:</strong> {$workingConnection['host']}</p>";
    echo "<p><strong>Status:</strong> Database synchronized and working</p>";
    echo "<br>";
    echo "<p><strong>🚀 Your application is now ready!</strong></p>";
    echo "<p>Access your Laravel app at: <a href='http://192.168.10.70' target='_blank'>http://192.168.10.70</a></p>";
    echo "</div>";

} else {
    echo "<h2>❌ ALL CONNECTIONS FAILED</h2>";
    echo "<div style='background:#f8d7da;border:1px solid #f5c6cb;padding:20px;border-radius:8px;margin:20px 0;color:#721c24;'>";
    echo "<h3>🔍 POSSIBLE ISSUES:</h3>";
    echo "<ul>";
    echo "<li>MySQL service is not running on 192.168.10.70</li>";
    echo "<li>Database 'spm_db' doesn't exist</li>";
    echo "<li>Wrong server IP address</li>";
    echo "<li>Firewall blocking MySQL port (3306)</li>";
    echo "</ul>";
    echo "<br>";
    echo "<p><strong>Quick Fix:</strong> Make sure XAMPP MySQL is running on 192.168.10.70</p>";
    echo "</div>";
}

// Step 3: Clear caches
echo "<h2>Step 3: Clearing Caches</h2>";
if (file_exists('../artisan')) {
    echo "<p class='info'>Clearing Laravel caches...</p>";
    $commands = ['config:clear', 'cache:clear', 'route:clear', 'view:clear'];
    foreach ($commands as $cmd) {
        $output = shell_exec("cd ../ && php artisan {$cmd} 2>&1");
        if (strpos($output, 'successfully') !== false || strpos($output, 'cleared') !== false) {
            echo "<p class='success'>✅ {$cmd} completed</p>";
        } else {
            echo "<p class='info'>⚠️ {$cmd} may have issues</p>";
        }
    }
}

echo "<hr>";
echo "<p><strong>Timestamp:</strong> " . date('Y-m-d H:i:s') . "</p>";
echo "<p><strong>Server:</strong> " . $_SERVER['SERVER_ADDR'] . "</p>";
?>
