<?php
echo "<h1>⚡ QUICK TEST</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .success{color:green;font-weight:bold;} .error{color:red;font-weight:bold;}</style>";

// Check paths
echo "<h2>Path Check</h2>";
echo "<p><strong>Current dir (__DIR__):</strong> " . __DIR__ . "</p>";
echo "<p><strong>Parent dir (dirname(__DIR__)):</strong> " . dirname(__DIR__) . "</p>";
echo "<p><strong>Env file path:</strong> " . dirname(__DIR__) . '/.env' . "</p>";

$envPath = dirname(__DIR__) . '/.env';
if (file_exists($envPath)) {
    echo "<p class='success'>✅ .env file exists at correct path</p>";

    // Read APP_KEY
    $envContent = file_get_contents($envPath);
    if (preg_match('/^APP_KEY=(.+)$/m', $envContent, $matches)) {
        $appKey = trim($matches[1]);
        echo "<p><strong>Current APP_KEY:</strong> " . substr($appKey, 0, 20) . "...</p>";
        echo "<p class='success'>✅ APP_KEY found in .env</p>";
    } else {
        echo "<p class='error'>❌ APP_KEY not found in .env</p>";
    }

} else {
    echo "<p class='error'>❌ .env file NOT found at: $envPath</p>";
}

// Test basic Laravel init
echo "<h2>Laravel Quick Test</h2>";
try {
    require_once '../vendor/autoload.php';
    echo "<p class='success'>✅ Autoload successful</p>";

    $app = require_once '../bootstrap/app.php';
    echo "<p class='success'>✅ App bootstrap successful</p>";

    $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
    $kernel->bootstrap();
    echo "<p class='success'>✅ Kernel bootstrap successful</p>";

    // Quick encryption test
    $test = encrypt('test');
    $result = decrypt($test);
    if ($result === 'test') {
        echo "<p class='success'>✅ Encryption working</p>";
    } else {
        echo "<p class='error'>❌ Encryption failed</p>";
    }

    echo "<h2>🎯 RESULT</h2>";
    echo "<div style='background:#d4edda;padding:15px;border-radius:8px;margin:10px 0;'>";
    echo "<p class='success'>Laravel is ready! Try accessing your application now.</p>";
    echo "<p><a href='http://192.168.10.70' target='_blank'>http://192.168.10.70</a></p>";
    echo "</div>";

} catch (Exception $e) {
    echo "<p class='error'>❌ Laravel test failed: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<p><strong>Quick test completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?>
