<?php
echo "<h1>🔑 RESET PASSWORD USER</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .success{color:green;font-weight:bold;} .error{color:red;font-weight:bold;} .info{color:blue;} .warning{color:orange;font-weight:bold;}</style>";

// Initialize Laravel
try {
    require_once '../vendor/autoload.php';
    $app = require_once '../bootstrap/app.php';
    $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
    $kernel->bootstrap();
} catch (Exception $e) {
    echo "<p class='error'>❌ Laravel initialization failed: " . $e->getMessage() . "</p>";
    exit;
}

echo "<h2>Current Users</h2>";
$users = DB::table('users')->get();

echo "<table border='1' style='border-collapse:collapse;margin:10px 0;'>";
echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Role</th><th>Current Password Hash</th></tr>";

foreach ($users as $user) {
    echo "<tr>";
    echo "<td>{$user->id}</td>";
    echo "<td>{$user->name}</td>";
    echo "<td>{$user->email}</td>";
    echo "<td>{$user->role}</td>";
    echo "<td><small>" . substr($user->password, 0, 30) . "...</small></td>";
    echo "</tr>";
}
echo "</table>";

echo "<h2>Reset Password Options</h2>";

// Option 1: Reset specific user
if (isset($_POST['reset_user']) && isset($_POST['new_password'])) {
    $userId = (int)$_POST['reset_user'];
    $newPassword = $_POST['new_password'];

    if (strlen($newPassword) < 6) {
        echo "<p class='error'>❌ Password must be at least 6 characters</p>";
    } else {
        $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);

        $updated = DB::table('users')->where('id', $userId)->update([
            'password' => $hashedPassword,
            'updated_at' => now()
        ]);

        if ($updated) {
            echo "<p class='success'>✅ Password reset successful!</p>";
            echo "<p class='info'>User ID $userId can now login with password: <strong>$newPassword</strong></p>";
        } else {
            echo "<p class='error'>❌ Password reset failed</p>";
        }
    }
}

// Option 2: Create new admin user
if (isset($_POST['create_admin'])) {
    $adminData = [
        'name' => 'System Admin',
        'email' => 'admin@system.com',
        'password' => password_hash('admin123', PASSWORD_DEFAULT),
        'role' => 'super_admin',
        'email_verified_at' => now(),
        'created_at' => now(),
        'updated_at' => now()
    ];

    $userId = DB::table('users')->insertGetId($adminData);

    if ($userId) {
        echo "<p class='success'>✅ New admin user created!</p>";
        echo "<div style='background:#d4edda;padding:15px;border-radius:8px;margin:10px 0;border:1px solid #c3e6cb;'>";
        echo "<h3>🔑 LOGIN CREDENTIALS:</h3>";
        echo "<p><strong>Email:</strong> admin@system.com</p>";
        echo "<p><strong>Password:</strong> admin123</p>";
        echo "<p><strong>Role:</strong> Super Admin</p>";
        echo "</div>";
    } else {
        echo "<p class='error'>❌ Failed to create admin user</p>";
    }
}

?>

<div style="background:#e8f4f8;padding:20px;border-radius:8px;margin:20px 0;">
    <h3>🔧 OPTION 1: Reset Existing User Password</h3>
    <form method="POST" style="margin:10px 0;">
        <label><strong>Select User to Reset:</strong></label><br>
        <select name="reset_user" required style="margin:5px 0;padding:5px;">
            <?php foreach ($users as $user): ?>
                <option value="<?php echo $user->id; ?>">
                    <?php echo $user->id; ?> - <?php echo $user->name; ?> (<?php echo $user->email; ?>)
                </option>
            <?php endforeach; ?>
        </select><br><br>

        <label><strong>New Password:</strong></label><br>
        <input type="password" name="new_password" required minlength="6" style="margin:5px 0;padding:5px;"><br><br>

        <button type="submit" style="padding:10px 20px;background:#007bff;color:white;border:none;border-radius:4px;cursor:pointer;">
            🔑 Reset Password
        </button>
    </form>
</div>

<div style="background:#fff3cd;padding:20px;border-radius:8px;margin:20px 0;border:1px solid #ffeaa7;">
    <h3>➕ OPTION 2: Create New Admin User</h3>
    <p>Create a new admin user with known credentials:</p>
    <form method="POST" style="margin:10px 0;">
        <button type="submit" name="create_admin" style="padding:10px 20px;background:#28a745;color:white;border:none;border-radius:4px;cursor:pointer;">
            ➕ Create Admin User
        </button>
    </form>
    <p><small><strong>Email:</strong> admin@system.com | <strong>Password:</strong> admin123</small></p>
</div>

<div style="background:#d1ecf1;padding:15px;border-radius:8px;margin:10px 0;border:1px solid #bee5eb;">
    <h3>🎯 RECOMMENDED: Use Existing Super Admin</h3>
    <p>Try logging in with existing Super Admin:</p>
    <ul>
        <li><strong>Email:</strong> superadmin@poltek-atk.ac.id</li>
        <li><strong>Password:</strong> Coba tebak atau reset password user ini</li>
    </ul>
    <p><small>Jika tidak tahu password, gunakan Option 1 untuk reset password user ID 2 (Super Admin).</small></p>
</div>

<hr>
<p><strong>Password reset completed at:</strong> <?php echo date('Y-m-d H:i:s'); ?></p>
