<?php
echo "<h1>🧪 SPM Connection Test</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .success{color:green;font-weight:bold;} .error{color:red;font-weight:bold;} .info{color:blue;}</style>";

// Test 1: PHP Version
echo "<h2>1. PHP Version</h2>";
echo "<p>PHP Version: <strong>" . phpversion() . "</strong></p>";

// Test 2: MySQL Extension
echo "<h2>2. MySQL Extension</h2>";
if (extension_loaded('pdo_mysql')) {
    echo "<p class='success'>✅ PDO MySQL extension is loaded</p>";
} else {
    echo "<p class='error'>❌ PDO MySQL extension is NOT loaded</p>";
}

// Test 3: Direct MySQL Connection
echo "<h2>3. Direct MySQL Connection</h2>";
try {
    $pdo = new PDO('mysql:host=127.0.0.1;dbname=spm_db;charset=utf8', 'root', '');
    echo "<p class='success'>✅ MySQL connection successful</p>";

    $stmt = $pdo->query("SELECT COUNT(*) as count FROM profiles");
    $result = $stmt->fetch();
    echo "<p>Profiles count: <strong>" . $result['count'] . "</strong></p>";

} catch (Exception $e) {
    echo "<p class='error'>❌ MySQL connection failed: " . $e->getMessage() . "</p>";
}

// Test 4: Laravel Environment
echo "<h2>4. Laravel Environment</h2>";
$envFile = '../.env';
if (file_exists($envFile)) {
    echo "<p class='success'>✅ .env file exists</p>";

    $envContent = file_get_contents($envFile);
    $lines = explode("\n", $envContent);

    echo "<ul>";
    foreach ($lines as $line) {
        if (strpos($line, 'DB_') === 0 && trim($line) !== '') {
            echo "<li><strong>$line</strong></li>";
        }
        if (strpos($line, 'APP_') === 0 && trim($line) !== '') {
            echo "<li><strong>$line</strong></li>";
        }
    }
    echo "</ul>";

} else {
    echo "<p class='error'>❌ .env file does not exist</p>";
}

// Test 5: Laravel Database Connection
echo "<h2>5. Laravel Database Connection</h2>";
try {
    require_once '../vendor/autoload.php';
    $app = require_once '../bootstrap/app.php';
    $app->make(Illuminate\Contracts\Console\Kernel::class)->bootstrap();

    $pdo = DB::connection('mysql')->getPdo();
    echo "<p class='success'>✅ Laravel database connection successful</p>";

    // Test the problematic query
    $profiles = DB::table('profiles')->where('is_active', 1)->orderBy('order')->orderBy('created_at', 'desc')->limit(5)->get();
    echo "<p>Found <strong>" . $profiles->count() . "</strong> active profiles</p>";

    if ($profiles->count() > 0) {
        echo "<ul>";
        foreach ($profiles as $profile) {
            echo "<li>{$profile->title}</li>";
        }
        echo "</ul>";
    }

} catch (Exception $e) {
    echo "<p class='error'>❌ Laravel database connection failed: " . $e->getMessage() . "</p>";

    // Detailed error analysis
    if (strpos($e->getMessage(), 'No connection could be made') !== false) {
        echo "<div style='background:#ffe6e6;border:1px solid #ff9999;padding:15px;border-radius:4px;margin:10px 0;'>";
        echo "<h3>🔍 Possible Solutions:</h3>";
        echo "<ol>";
        echo "<li><strong>Start MySQL:</strong> Make sure XAMPP MySQL is running</li>";
        echo "<li><strong>Check Port:</strong> Verify MySQL is running on port 3306</li>";
        echo "<li><strong>Firewall:</strong> Disable firewall temporarily to test</li>";
        echo "<li><strong>Host:</strong> Try changing DB_HOST to 'localhost' instead of '127.0.0.1'</li>";
        echo "</ol>";
        echo "</div>";
    }
}

echo "<hr>";
echo "<p><strong>Current Directory:</strong> " . __DIR__ . "</p>";
echo "<p><strong>Script Path:</strong> " . __FILE__ . "</p>";
echo "<p><strong>Server:</strong> " . $_SERVER['SERVER_SOFTWARE'] . "</p>";
?>
