<?php
echo "<h1>🧪 TEST APPLICATION NOW</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;font-size:14px;} .success{color:green;font-weight:bold;} .error{color:red;font-weight:bold;} .warning{color:orange;font-weight:bold;} .info{color:blue;} pre{background:#f5f5f5;padding:10px;border-radius:4px;margin:10px 0;max-height:200px;overflow:auto;}</style>";

// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>🔍 FINAL TEST - FRESH LARAVEL INSTANCE</h2>";
echo "<p class='info'>Testing with completely fresh Laravel initialization</p>";

try {
    // Step 1: Fresh Laravel initialization
    echo "<h3>Step 1: Fresh Laravel Init</h3>";
    require_once '../vendor/autoload.php';

    // Force reload environment
    $envPath = dirname(__DIR__); // Go up one directory from public/
    if (file_exists($envPath . '/.env')) {
        $dotenv = \Dotenv\Dotenv::createImmutable($envPath);
        $dotenv->load();
        echo "<p class='success'>✅ Environment reloaded from: $envPath/.env</p>";
    } else {
        echo "<p class='error'>❌ .env file not found at: $envPath/.env</p>";
    }

    $app = require_once '../bootstrap/app.php';
    $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
    $kernel->bootstrap();
    echo "<p class='success'>✅ Fresh Laravel bootstrap successful</p>";

    // Step 2: Test encryption with fresh instance
    echo "<h3>Step 2: Test Encryption</h3>";
    $testData = 'encryption_test_' . time();

    try {
        $encrypted = encrypt($testData);
        $decrypted = decrypt($encrypted);

        if ($decrypted === $testData) {
            echo "<p class='success'>✅ Encryption/decryption working perfectly!</p>";
            echo "<p class='info'>Test data: '$testData' → encrypted → decrypted successfully</p>";
        } else {
            echo "<p class='error'>❌ Encryption test failed - data mismatch</p>";
        }
    } catch (Exception $e) {
        echo "<p class='error'>❌ Encryption failed: " . $e->getMessage() . "</p>";
        exit;
    }

    // Step 3: Test database
    echo "<h3>Step 3: Test Database</h3>";
    try {
        $pdo = DB::connection('mysql')->getPdo();
        $users = DB::table('users')->count();
        $profiles = DB::table('profiles')->count();
        echo "<p class='success'>✅ Database working - Users: $users, Profiles: $profiles</p>";
    } catch (Exception $e) {
        echo "<p class='error'>❌ Database failed: " . $e->getMessage() . "</p>";
        exit;
    }

    // Step 4: Simulate real HTTP request
    echo "<h3>Step 4: Simulate HTTP Request</h3>";
    try {
        $request = \Illuminate\Http\Request::create('/', 'GET');
        $response = $kernel->handle($request);

        $statusCode = $response->getStatusCode();

        if ($statusCode === 200) {
            echo "<p class='success'>🎉 SUCCESS! HTTP 200 OK - Application working!</p>";
            echo "<div style='background:#d4edda;padding:20px;border-radius:8px;margin:20px 0;border:1px solid #c3e6cb;'>";
            echo "<h2 style='color:#155724;margin-top:0;'>✅ APLIKASI LARAVEL ANDA SUDAH BERJALAN!</h2>";
            echo "<p style='color:#155724;font-size:16px;'>Error 500 sudah teratasi. APP_KEY sudah diperbaiki.</p>";
            echo "<br>";
            echo "<p style='color:#155724;'><strong>🚀 Akses aplikasi sekarang:</strong></p>";
            echo "<p><a href='http://192.168.10.70' target='_blank' style='color:#155724;font-weight:bold;font-size:18px;'>http://192.168.10.70</a></p>";
            echo "</div>";
        } elseif ($statusCode === 500) {
            echo "<p class='error'>❌ Still getting HTTP 500 error</p>";
            $content = $response->getContent();
            if (strpos($content, 'cipher') !== false || strpos($content, 'encryption') !== false) {
                echo "<p class='error'>Encryption error still present - try refreshing the page</p>";
            }
        } else {
            echo "<p class='warning'>⚠️ Unexpected HTTP status: $statusCode</p>";
        }

        $kernel->terminate($request, $response);

    } catch (Exception $e) {
        echo "<p class='error'>❌ HTTP simulation failed: " . $e->getMessage() . "</p>";
        echo "<pre>" . $e->getTraceAsString() . "</pre>";
    }

} catch (Exception $e) {
    echo "<h2 class='error'>💥 CRITICAL ERROR</h2>";
    echo "<p class='error'>Fresh Laravel initialization failed: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<hr>";
echo "<p><strong>Test completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?>
