<?php
echo "<h1>🔍 TEST LOGIN ROUTE</h1>";
echo "<style>body{font-family:Arial,sans-serif;margin:20px;} .success{color:green;font-weight:bold;} .error{color:red;font-weight:bold;} .info{color:blue;} pre{background:#f5f5f5;padding:10px;border-radius:4px;margin:10px 0;max-height:300px;overflow:auto;}</style>";

// Initialize Laravel
try {
    require_once '../vendor/autoload.php';
    $app = require_once '../bootstrap/app.php';
    $kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
    $kernel->bootstrap();
    echo "<p class='success'>✅ Laravel initialized successfully</p>";
} catch (Exception $e) {
    echo "<p class='error'>❌ Laravel initialization failed: " . $e->getMessage() . "</p>";
    exit;
}

echo "<h2>Step 1: Check Login Routes</h2>";
$router = app('router');
$routes = $router->getRoutes();

// Find login routes
$loginRoutes = [];
foreach ($routes as $route) {
    $uri = $route->uri();
    if (strpos($uri, 'login') !== false) {
        $methods = implode('|', $route->methods());
        $action = $route->getActionName() ?: 'Closure';
        $loginRoutes[] = [
            'methods' => $methods,
            'uri' => $uri,
            'action' => $action,
            'name' => $route->getName()
        ];
    }
}

if (!empty($loginRoutes)) {
    echo "<p class='success'>✅ Found " . count($loginRoutes) . " login-related routes:</p>";
    echo "<table border='1' style='border-collapse:collapse;margin:10px 0;'>";
    echo "<tr><th>Method</th><th>URI</th><th>Action</th><th>Name</th></tr>";

    foreach ($loginRoutes as $route) {
        echo "<tr>";
        echo "<td>{$route['methods']}</td>";
        echo "<td>{$route['uri']}</td>";
        echo "<td>{$route['action']}</td>";
        echo "<td>" . ($route['name'] ?: '-') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<p class='error'>❌ No login routes found!</p>";
}

echo "<h2>Step 2: Test Route Resolution</h2>";
try {
    // Test GET /login
    $getRequest = \Illuminate\Http\Request::create('/login', 'GET');
    $getRoute = $router->getRoutes()->match($getRequest);
    echo "<p class='success'>✅ GET /login route resolved: " . $getRoute->getActionName() . "</p>";
} catch (Exception $e) {
    echo "<p class='error'>❌ GET /login route resolution failed: " . $e->getMessage() . "</p>";
}

try {
    // Test POST /login
    $postRequest = \Illuminate\Http\Request::create('/login', 'POST');
    $postRoute = $router->getRoutes()->match($postRequest);
    echo "<p class='success'>✅ POST /login route resolved: " . $postRoute->getActionName() . "</p>";
} catch (Exception $e) {
    echo "<p class='error'>❌ POST /login route resolution failed: " . $e->getMessage() . "</p>";
}

echo "<h2>Step 3: Test Authentication Classes</h2>";
try {
    // Check AuthenticatedSessionController
    $controllerClass = 'App\Http\Controllers\Auth\AuthenticatedSessionController';
    if (class_exists($controllerClass)) {
        echo "<p class='success'>✅ $controllerClass exists</p>";

        $controller = app($controllerClass);
        if (method_exists($controller, 'store')) {
            echo "<p class='success'>✅ store() method exists</p>";
        } else {
            echo "<p class='error'>❌ store() method missing</p>";
        }
    } else {
        echo "<p class='error'>❌ $controllerClass not found</p>";
    }

    // Check LoginRequest
    $requestClass = 'App\Http\Requests\Auth\LoginRequest';
    if (class_exists($requestClass)) {
        echo "<p class='success'>✅ $requestClass exists</p>";
    } else {
        echo "<p class='error'>❌ $requestClass not found</p>";
    }

} catch (Exception $e) {
    echo "<p class='error'>❌ Authentication classes test failed: " . $e->getMessage() . "</p>";
}

echo "<h2>Step 4: Simulate Login Request</h2>";
try {
    // Get a test user
    $testUser = DB::table('users')->where('role', 'super_admin')->first();
    if ($testUser) {
        echo "<p class='info'>Using test user: {$testUser->email}</p>";

        // Create login request data
        $loginData = [
            'email' => $testUser->email,
            'password' => 'admin123', // We'll test with a known password
            'remember' => false
        ];

        // Create request
        $request = new \Illuminate\Http\Request();
        $request->merge($loginData);
        $request->setMethod('POST');

        // Test LoginRequest validation
        $loginRequest = new \App\Http\Requests\Auth\LoginRequest();
        $loginRequest->merge($loginData);

        // Validate
        $validator = \Illuminate\Support\Facades\Validator::make($loginData, [
            'email' => 'required|email',
            'password' => 'required|string'
        ]);

        if ($validator->passes()) {
            echo "<p class='success'>✅ Login validation passed</p>";

            // Test authentication
            $authResult = \Illuminate\Support\Facades\Auth::attempt([
                'email' => $testUser->email,
                'password' => 'admin123'
            ]);

            if ($authResult) {
                echo "<p class='success'>✅ Authentication successful with admin123!</p>";
                \Illuminate\Support\Facades\Auth::logout();
            } else {
                echo "<p class='error'>❌ Authentication failed - wrong password</p>";
                echo "<p class='info'>Try resetting password using reset_password.php script</p>";
            }

        } else {
            echo "<p class='error'>❌ Login validation failed: " . implode(', ', $validator->errors()->all()) . "</p>";
        }

    } else {
        echo "<p class='error'>❌ No super_admin user found</p>";
    }

} catch (Exception $e) {
    echo "<p class='error'>❌ Login simulation failed: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<h2>Step 5: Check for Route Conflicts</h2>";
$conflicts = [];
foreach ($routes as $route) {
    $uri = $route->uri();
    if ($uri === 'login') {
        $methods = $route->methods();
        $conflicts[$uri][] = $methods;
    }
}

if (!empty($conflicts)) {
    echo "<p class='warning'>⚠️ Potential route conflicts detected:</p>";
    foreach ($conflicts as $uri => $methodsList) {
        echo "<p><strong>$uri:</strong> " . count($methodsList) . " route(s)</p>";
    }
} else {
    echo "<p class='success'>✅ No route conflicts detected</p>";
}

echo "<h2>🎯 SUMMARY & NEXT STEPS</h2>";
echo "<div style='background:#e8f4f8;padding:15px;border-radius:8px;margin:10px 0;'>";

if (count($loginRoutes) > 0) {
    echo "<h3>✅ ROUTES OK</h3>";
    echo "<p>Login routes are properly registered.</p>";
} else {
    echo "<h3>❌ ROUTES MISSING</h3>";
    echo "<p>Login routes are not registered. Check routes/auth.php</p>";
}

echo "<h3>🔧 IF STILL 404:</h3>";
echo "<ol>";
echo "<li><strong>Clear routes cache:</strong> Run <code>php artisan route:clear</code></li>";
echo "<li><strong>Check .htaccess:</strong> Ensure URL rewriting is enabled</li>";
echo "<li><strong>Check APP_URL:</strong> Make sure APP_URL in .env is correct</li>";
echo "<li><strong>Test direct access:</strong> Try <code>http://192.168.10.70/login</code></li>";
echo "</ol>";

echo "</div>";

echo "<hr>";
echo "<p><strong>Login route test completed at:</strong> " . date('Y-m-d H:i:s') . "</p>";
?>
