@extends('layouts.app')

@section('title', 'Edit Profil - Admin Panel')

@section('content')
<div style="padding: 40px 20px; width: 100%;">
    <div style="max-width: 800px; margin: 0 auto;">
        <div style="background: white; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); padding: 30px;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
                <h1 style="color: #0a3d91; font-size: 2rem; margin: 0;">Edit Profil</h1>
                <a href="{{ route('admin.profiles.index') }}" style="color: #6c757d; text-decoration: none;">
                    ← Kembali
                </a>
            </div>

            <form action="{{ route('admin.profiles.update', $profile) }}" method="POST" enctype="multipart/form-data">
                @csrf
                @method('PUT')

                <div style="margin-bottom: 20px;">
                    <label for="title" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Judul *</label>
                    <input type="text" id="title" name="title" value="{{ old('title', $profile->title) }}" required
                           style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                    @error('title')
                        <div style="color: #dc3545; font-size: 0.9rem; margin-top: 4px;">{{ $message }}</div>
                    @enderror
                </div>

                <div style="margin-bottom: 20px;">
                    <label for="category" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Kategori</label>
                    <select id="category" name="category" style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                        <option value="">Pilih Kategori</option>
                        <option value="tentang-bpm" {{ old('category', $profile->category) == 'tentang-bpm' ? 'selected' : '' }}>Tentang BPM</option>
                        <option value="pernyataan-mutu" {{ old('category', $profile->category) == 'pernyataan-mutu' ? 'selected' : '' }}>Pernyataan Mutu</option>
                        <option value="tujuan-peranan" {{ old('category', $profile->category) == 'tujuan-peranan' ? 'selected' : '' }}>Tujuan dan Peranan</option>
                        <option value="status-kedudukan" {{ old('category', $profile->category) == 'status-kedudukan' ? 'selected' : '' }}>Status dan Kedudukan</option>
                        <option value="spm-atk" {{ old('category', $profile->category) == 'spm-atk' ? 'selected' : '' }}>SPM ATK</option>
                        <option value="sejarah-mercy" {{ old('category', $profile->category) == 'sejarah-mercy' ? 'selected' : '' }}>Sejarah Mercy</option>
                    </select>
                </div>

                <div style="margin-bottom: 20px;">
                    <label for="excerpt" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Ringkasan</label>
                    <textarea id="excerpt" name="excerpt" rows="3" style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px; resize: vertical;">{{ old('excerpt', $profile->excerpt) }}</textarea>
                    @error('excerpt')
                        <div style="color: #dc3545; font-size: 0.9rem; margin-top: 4px;">{{ $message }}</div>
                    @enderror
                </div>

                <div style="margin-bottom: 20px;">
                    <label for="content" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Konten *</label>
                    <textarea id="content" name="content" rows="10" required style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px; resize: vertical;">{{ old('content', $profile->content) }}</textarea>
                    @error('content')
                        <div style="color: #dc3545; font-size: 0.9rem; margin-top: 4px;">{{ $message }}</div>
                    @enderror
                </div>

                <div style="margin-bottom: 20px;">
                    <label for="image" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Gambar</label>
                    @if($profile->image)
                        <div style="margin-bottom: 12px;">
                            <img src="{{ asset($profile->image) }}" alt="Current Image" style="max-width: 200px; max-height: 150px; border-radius: 8px; border: 1px solid #ddd;">
                        </div>
                    @endif
                    <input type="file" id="image" name="image" accept="image/*"
                           style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                    <small style="color: #666; font-size: 0.9rem;">Biarkan kosong jika tidak ingin mengubah gambar</small>
                    @error('image')
                        <div style="color: #dc3545; font-size: 0.9rem; margin-top: 4px;">{{ $message }}</div>
                    @enderror
                </div>

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
                    <div>
                        <label for="order" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Urutan</label>
                        <input type="number" id="order" name="order" value="{{ old('order', $profile->order) }}" min="0"
                               style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                    </div>

                    <div>
                        <label style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Status</label>
                        <div style="display: flex; align-items: center; gap: 10px;">
                            <label style="display: flex; align-items: center; cursor: pointer;">
                                <input type="checkbox" name="is_active" value="1" {{ old('is_active', $profile->is_active) ? 'checked' : '' }}
                                       style="margin-right: 8px; width: 18px; height: 18px;">
                                Aktif
                            </label>
                        </div>
                    </div>
                </div>

                <div style="display: flex; gap: 12px; margin-top: 30px;">
                    <button type="submit" style="background: #0a3d91; color: white; padding: 12px 24px; border: none; border-radius: 8px; font-weight: bold; font-size: 16px; cursor: pointer;">
                        Update Profil
                    </button>
                    <a href="{{ route('admin.profiles.index') }}" style="background: #6c757d; color: white; padding: 12px 24px; text-decoration: none; border-radius: 8px; font-weight: bold;">
                        Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
