@extends('layouts.admin')

@section('title', 'Kelola Profil - Admin Panel')

@section('page-title', 'Kelola Profil')

@section('content')
<div class="breadcrumb">
    <a href="{{ route('admin.dashboard') }}">Dashboard</a>
    <span>/</span>
    <span>Kelola Profil</span>
</div>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
    <h1 style="color: #0a3d91; font-size: 2rem; margin: 0;">Kelola Profil BPM ATK</h1>
    <a href="{{ route('admin.profiles.create') }}" style="background: #0a3d91; color: white; padding: 12px 24px; text-decoration: none; border-radius: 8px; font-weight: bold;">
        + Tambah Profil
    </a>
</div>

        @if(session('success'))
            <div style="background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin-bottom: 20px; border: 1px solid #c3e6cb;">
                {{ session('success') }}
            </div>
        @endif

        <div style="background: white; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); overflow: hidden;">
            <div style="padding: 20px;">
                <table style="width: 100%; border-collapse: collapse;">
                    <thead>
                        <tr style="border-bottom: 2px solid #eee;">
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Judul</th>
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Kategori</th>
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Status</th>
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Urutan</th>
                            <th style="padding: 12px; text-align: center; font-weight: bold; color: #0a3d91;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($profiles as $profile)
                            <tr style="border-bottom: 1px solid #eee;">
                                <td style="padding: 12px;">
                                    <div style="font-weight: bold; color: #333;">{{ $profile->title }}</div>
                                    <div style="font-size: 0.9rem; color: #666; margin-top: 4px;">
                                        {{ Str::limit($profile->excerpt, 50) }}
                                    </div>
                                </td>
                                <td style="padding: 12px;">
                                    <span style="background: #f8f9fa; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                        {{ $profile->category ?? 'Umum' }}
                                    </span>
                                </td>
                                <td style="padding: 12px;">
                                    @if($profile->is_active)
                                        <span style="background: #d4edda; color: #155724; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                            Aktif
                                        </span>
                                    @else
                                        <span style="background: #f8d7da; color: #721c24; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                            Tidak Aktif
                                        </span>
                                    @endif
                                </td>
                                <td style="padding: 12px; text-align: center;">
                                    {{ $profile->order }}
                                </td>
                                <td style="padding: 12px; text-align: center;">
                                    <div style="display: flex; gap: 8px; justify-content: center;">
                                        <a href="{{ route('admin.profiles.show', $profile) }}" style="background: #17a2b8; color: white; padding: 6px 12px; text-decoration: none; border-radius: 4px; font-size: 0.9rem;">
                                            Lihat
                                        </a>
                                        <a href="{{ route('admin.profiles.edit', $profile) }}" style="background: #ffc107; color: #212529; padding: 6px 12px; text-decoration: none; border-radius: 4px; font-size: 0.9rem;">
                                            Edit
                                        </a>
                                        <form action="{{ route('admin.profiles.destroy', $profile) }}" method="POST" style="display: inline;" onsubmit="return confirm('Apakah Anda yakin ingin menghapus profil ini?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" style="background: #dc3545; color: white; padding: 6px 12px; border: none; border-radius: 4px; font-size: 0.9rem; cursor: pointer;">
                                                Hapus
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" style="padding: 40px; text-align: center; color: #666;">
                                    Belum ada data profil.
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        @if($profiles->hasPages())
            <div style="margin-top: 20px;">
                {{ $profiles->links() }}
            </div>
        @endif
@endsection
