@extends('layouts.admin')

@section('title', 'Edit Layanan - Admin Panel')

@section('page-title', 'Edit Layanan')

@section('content')
<div class="breadcrumb">
    <a href="{{ route('admin.dashboard') }}">Dashboard</a>
    <span>/</span>
    <a href="{{ route('admin.services.index') }}">Kelola Layanan</a>
    <span>/</span>
    <span>Edit Layanan</span>
</div>

<div style="max-width: 800px; margin: 0 auto;">
    <div style="background: white; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); padding: 30px;">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
            <h1 style="color: #0a3d91; font-size: 2rem; margin: 0;">Edit Layanan</h1>
            <a href="{{ route('admin.services.index') }}" style="color: #6c757d; text-decoration: none;">
                ← Kembali
            </a>
        </div>

        <form action="{{ route('admin.services.update', $service) }}" method="POST">
            @csrf
            @method('PUT')

            <div style="margin-bottom: 20px;">
                <label for="title" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Judul Layanan *</label>
                <input type="text" id="title" name="title" value="{{ old('title', $service->title) }}" required
                       style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                @error('title')
                    <div style="color: #dc3545; font-size: 0.9rem; margin-top: 4px;">{{ $message }}</div>
                @enderror
            </div>

            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
                <div>
                    <label for="icon" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Icon (Emoji)</label>
                    <input type="text" id="icon" name="icon" value="{{ old('icon', $service->icon) }}" placeholder="📋"
                           style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                    <small style="color: #666; font-size: 0.8rem;">Gunakan emoji sebagai icon layanan</small>
                </div>

                <div>
                    <label for="sort_order" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Urutan Tampilan</label>
                    <input type="number" id="sort_order" name="sort_order" value="{{ old('sort_order', $service->sort_order) }}" min="0"
                           style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                    <small style="color: #666; font-size: 0.8rem;">Angka kecil akan tampil lebih dulu</small>
                </div>
            </div>

            <div style="margin-bottom: 20px;">
                <label for="description" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Deskripsi Layanan *</label>
                <textarea id="description" name="description" rows="4" required
                          style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px; resize: vertical;"
                          placeholder="Jelaskan layanan yang Anda tawarkan...">{{ old('description', $service->description) }}</textarea>
                @error('description')
                    <div style="color: #dc3545; font-size: 0.9rem; margin-top: 4px;">{{ $message }}</div>
                @enderror
            </div>

            <div style="margin-bottom: 20px;">
                <label for="features" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Fitur Layanan</label>
                <textarea id="features" name="features" rows="6"
                          style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px; resize: vertical; font-family: monospace;"
                          placeholder="• Sertifikasi ISO 9001
• Sertifikasi Produk
• Sertifikasi Jasa
• Konsultasi Mutu">{{ old('features', is_array($service->features) ? implode("\n", $service->features) : '') }}</textarea>
                <small style="color: #666; font-size: 0.8rem;">Satu fitur per baris, awali dengan •</small>
            </div>

            <div style="margin-bottom: 30px;">
                <label style="display: flex; align-items: center; cursor: pointer;">
                    <input type="checkbox" name="is_active" value="1" {{ old('is_active', $service->is_active) ? 'checked' : '' }}
                           style="margin-right: 10px; width: 18px; height: 18px;">
                    <span style="font-weight: bold; color: #333;">Aktifkan Layanan</span>
                </label>
                <small style="color: #666; font-size: 0.8rem; margin-left: 28px; display: block;">Layanan akan ditampilkan di halaman publik jika dicentang</small>
            </div>

            <div style="display: flex; gap: 15px;">
                <button type="submit" style="background: #0a3d91; color: white; border: none; padding: 12px 30px; border-radius: 8px; font-size: 16px; font-weight: bold; cursor: pointer;">
                    💾 Update Layanan
                </button>
                <a href="{{ route('admin.services.index') }}" style="background: #6c757d; color: white; padding: 12px 30px; text-decoration: none; border-radius: 8px; font-size: 16px; font-weight: bold;">
                    ❌ Batal
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
