@extends('layouts.admin')

@section('title', 'Detail Layanan - Admin Panel')

@section('page-title', 'Detail Layanan')

@section('content')
<div class="breadcrumb">
    <a href="{{ route('admin.dashboard') }}">Dashboard</a>
    <span>/</span>
    <a href="{{ route('admin.services.index') }}">Kelola Layanan</a>
    <span>/</span>
    <span>{{ $service->title }}</span>
</div>

<div style="max-width: 800px; margin: 0 auto;">
    <div style="background: white; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); padding: 30px;">
        <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
            <h1 style="color: #0a3d91; font-size: 2rem; margin: 0;">Detail Layanan</h1>
            <div style="display: flex; gap: 10px;">
                <a href="{{ route('admin.services.edit', $service) }}" style="background: #ffc107; color: #212529; padding: 8px 16px; text-decoration: none; border-radius: 6px; font-weight: bold;">
                    ✏️ Edit
                </a>
                <a href="{{ route('admin.services.index') }}" style="background: #6c757d; color: white; padding: 8px 16px; text-decoration: none; border-radius: 6px; font-weight: bold;">
                    ← Kembali
                </a>
            </div>
        </div>

        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 30px; margin-bottom: 30px;">
            <div>
                <h3 style="color: #0a3d91; margin-bottom: 15px; border-bottom: 2px solid #0a3d91; padding-bottom: 8px;">Informasi Layanan</h3>

                <div style="margin-bottom: 15px;">
                    <strong style="color: #333;">Judul:</strong><br>
                    <span style="font-size: 1.1rem;">{{ $service->title }}</span>
                </div>

                <div style="margin-bottom: 15px;">
                    <strong style="color: #333;">Slug:</strong><br>
                    <code style="background: #f8f9fa; padding: 4px 8px; border-radius: 4px;">{{ $service->slug }}</code>
                </div>

                <div style="margin-bottom: 15px;">
                    <strong style="color: #333;">Icon:</strong><br>
                    <span style="font-size: 2rem;">{{ $service->icon ?: '📋' }}</span>
                </div>

                <div style="margin-bottom: 15px;">
                    <strong style="color: #333;">Urutan Tampilan:</strong><br>
                    <span>{{ $service->sort_order }}</span>
                </div>

                <div style="margin-bottom: 15px;">
                    <strong style="color: #333;">Status:</strong><br>
                    @if($service->is_active)
                        <span style="background: #28a745; color: white; padding: 4px 8px; border-radius: 12px; font-size: 0.9rem;">
                            ✅ Aktif
                        </span>
                    @else
                        <span style="background: #dc3545; color: white; padding: 4px 8px; border-radius: 12px; font-size: 0.9rem;">
                            ❌ Nonaktif
                        </span>
                    @endif
                </div>
            </div>

            <div>
                <h3 style="color: #0a3d91; margin-bottom: 15px; border-bottom: 2px solid #0a3d91; padding-bottom: 8px;">Metadata</h3>

                <div style="margin-bottom: 15px;">
                    <strong style="color: #333;">Dibuat:</strong><br>
                    <span>{{ $service->created_at->format('d F Y, H:i') }}</span>
                </div>

                <div style="margin-bottom: 15px;">
                    <strong style="color: #333;">Terakhir Diubah:</strong><br>
                    <span>{{ $service->updated_at->format('d F Y, H:i') }}</span>
                </div>
            </div>
        </div>

        <div style="margin-bottom: 30px;">
            <h3 style="color: #0a3d91; margin-bottom: 15px; border-bottom: 2px solid #0a3d91; padding-bottom: 8px;">Deskripsi Layanan</h3>
            <div style="background: #f8f9fa; padding: 20px; border-radius: 8px; line-height: 1.6;">
                {{ $service->description }}
            </div>
        </div>

        @if($service->features && count($service->features) > 0)
        <div style="margin-bottom: 30px;">
            <h3 style="color: #0a3d91; margin-bottom: 15px; border-bottom: 2px solid #0a3d91; padding-bottom: 8px;">Fitur Layanan</h3>
            <div style="background: #f8f9fa; padding: 20px; border-radius: 8px;">
                <ul style="margin: 0; padding-left: 20px;">
                    @foreach($service->features as $feature)
                        <li style="margin-bottom: 8px; line-height: 1.5;">{{ $feature }}</li>
                    @endforeach
                </ul>
            </div>
        </div>
        @endif

        <div style="border-top: 1px solid #eee; padding-top: 20px;">
            <div style="display: flex; gap: 10px;">
                <a href="{{ route('admin.services.edit', $service) }}" style="background: #ffc107; color: #212529; padding: 10px 20px; text-decoration: none; border-radius: 6px; font-weight: bold;">
                    ✏️ Edit Layanan
                </a>
                <form method="POST" action="{{ route('admin.services.destroy', $service) }}" style="display: inline;" onsubmit="return confirm('Apakah Anda yakin ingin menghapus layanan ini? Semua data akan hilang permanen.')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" style="background: #dc3545; color: white; border: none; padding: 10px 20px; border-radius: 6px; cursor: pointer; font-weight: bold;">
                        🗑️ Hapus Layanan
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
