@extends('layouts.app')

@section('content')
<div style="background: linear-gradient(135deg, #0a3d91 0%, #1e5f99 100%); color: white; padding: 60px 0; text-align: center; margin-top: 80px;">
    <div style="max-width: 1200px; margin: 0 auto; padding: 0 20px;">
        <h1 style="font-size: 3rem; font-weight: bold; margin-bottom: 20px; text-shadow: 2px 2px 4px rgba(0,0,0,0.3);">
            {{ $article->title }}
        </h1>
        <div style="display: flex; justify-content: center; gap: 20px; flex-wrap: wrap; margin-bottom: 20px;">
            @if($article->category)
                <span style="background: rgba(255,255,255,0.2); padding: 8px 16px; border-radius: 20px; font-size: 0.9rem;">
                    {{ ucwords(str_replace('-', ' ', $article->category)) }}
                </span>
            @endif
            @if($article->is_featured)
                <span style="background: #ffc107; color: #212529; padding: 8px 16px; border-radius: 20px; font-size: 0.9rem; font-weight: bold;">
                    ⭐ ARTIKEL UNGGULAN
                </span>
            @endif
        </div>
        @if($article->excerpt)
        <p style="font-size: 1.2rem; opacity: 0.9; max-width: 800px; margin: 0 auto;">
            {{ $article->excerpt }}
        </p>
        @endif
        <div style="margin-top: 20px; opacity: 0.8;">
            <p style="margin: 0; font-size: 0.9rem;">
                📅 {{ $article->published_at ? $article->published_at->format('l, d F Y') : 'Draft' }}
                @if($article->author)
                    | ✍️ {{ $article->author }}
                @endif
            </p>
        </div>
    </div>
</div>

<div style="max-width: 1200px; margin: 0 auto; padding: 60px 20px;">
    <div style="display: grid; grid-template-columns: 1fr 300px; gap: 40px;">

        <!-- Main Content -->
        <div style="background: white; border-radius: 12px; padding: 40px; box-shadow: 0 8px 32px rgba(0,0,0,0.1);">
            @if($article->image)
                <div style="text-align: center; margin-bottom: 40px;">
                    <img src="{{ asset($article->image) }}" alt="{{ $article->title }}" style="max-width: 100%; height: auto; border-radius: 12px; box-shadow: 0 4px 16px rgba(0,0,0,0.1);">
                </div>
            @endif

            <div style="line-height: 1.8; font-size: 1.1rem; color: #333;">
                {!! nl2br(e($article->content)) !!}
            </div>

            <!-- Share Buttons -->
            <div style="margin-top: 50px; padding-top: 30px; border-top: 1px solid #eee;">
                <h4 style="color: #0a3d91; margin-bottom: 15px;">Bagikan Artikel:</h4>
                <div style="display: flex; gap: 10px; flex-wrap: wrap;">
                    <a href="https://www.facebook.com/sharer/sharer.php?u={{ url()->current() }}" target="_blank"
                       style="background: #1877f2; color: white; padding: 10px 15px; border-radius: 6px; text-decoration: none; font-size: 0.9rem;">
                        📘 Facebook
                    </a>
                    <a href="https://twitter.com/intent/tweet?url={{ url()->current() }}&text={{ urlencode($article->title) }}" target="_blank"
                       style="background: #1da1f2; color: white; padding: 10px 15px; border-radius: 6px; text-decoration: none; font-size: 0.9rem;">
                        🐦 Twitter
                    </a>
                    <a href="https://wa.me/?text={{ urlencode($article->title . ' - ' . url()->current()) }}" target="_blank"
                       style="background: #25d366; color: white; padding: 10px 15px; border-radius: 6px; text-decoration: none; font-size: 0.9rem;">
                        💬 WhatsApp
                    </a>
                </div>
            </div>
        </div>

        <!-- Sidebar -->
        <div>
            <!-- Article Info -->
            <div style="background: white; border-radius: 12px; padding: 25px; box-shadow: 0 4px 16px rgba(0,0,0,0.1); margin-bottom: 30px;">
                <h4 style="color: #0a3d91; margin-bottom: 20px;">ℹ️ Info Artikel</h4>
                <div style="space-y: 12px;">
                    <div style="margin-bottom: 12px;">
                        <strong style="color: #495057;">Kategori:</strong><br>
                        <span style="color: #0a3d91;">{{ $article->category ? ucwords(str_replace('-', ' ', $article->category)) : 'Umum' }}</span>
                    </div>
                    <div style="margin-bottom: 12px;">
                        <strong style="color: #495057;">Penulis:</strong><br>
                        <span style="color: #0a3d91;">{{ $article->author ?: 'Admin SPM ATK' }}</span>
                    </div>
                    <div style="margin-bottom: 12px;">
                        <strong style="color: #495057;">Diterbitkan:</strong><br>
                        <span style="color: #0a3d91;">{{ $article->published_at ? $article->published_at->format('d F Y') : 'Belum diterbitkan' }}</span>
                    </div>
                    <div style="margin-bottom: 12px;">
                        <strong style="color: #495057;">Status:</strong><br>
                        @if($article->is_featured)
                            <span style="background: #ffc107; color: #212529; padding: 4px 8px; border-radius: 4px; font-size: 0.8rem; font-weight: bold;">⭐ Unggulan</span>
                        @else
                            <span style="background: #28a745; color: white; padding: 4px 8px; border-radius: 4px; font-size: 0.8rem;">📄 Publik</span>
                        @endif
                    </div>
                </div>
            </div>

            <!-- Navigation -->
            <div style="background: white; border-radius: 12px; padding: 25px; box-shadow: 0 4px 16px rgba(0,0,0,0.1); margin-bottom: 30px;">
                <h4 style="color: #0a3d91; margin-bottom: 20px;">🧭 Navigasi</h4>
                <div style="space-y: 10px;">
                    <a href="{{ route('artikel') }}" style="display: block; color: #0a3d91; text-decoration: none; padding: 8px 0; border-bottom: 1px solid #eee; transition: color 0.3s ease;"
                       onmouseover="this.style.color='#1e5f99'"
                       onmouseout="this.style.color='#0a3d91'">
                        ← Kembali ke Artikel
                    </a>
                    <a href="{{ route('home') }}" style="display: block; color: #0a3d91; text-decoration: none; padding: 8px 0; transition: color 0.3s ease;"
                       onmouseover="this.style.color='#1e5f99'"
                       onmouseout="this.style.color='#0a3d91'">
                        🏠 Halaman Utama
                    </a>
                </div>
            </div>

            <!-- Related Articles -->
            @php
                $relatedArticles = \App\Models\Article::where('category', $article->category)
                                                      ->where('id', '!=', $article->id)
                                                      ->where('is_active', true)
                                                      ->where('published_at', '<=', now())
                                                      ->orderBy('published_at', 'desc')
                                                      ->take(3)
                                                      ->get();
            @endphp

            @if($relatedArticles->count() > 0)
            <div style="background: white; border-radius: 12px; padding: 25px; box-shadow: 0 4px 16px rgba(0,0,0,0.1);">
                <h4 style="color: #0a3d91; margin-bottom: 20px;">📚 Artikel Terkait</h4>
                <div style="space-y: 15px;">
                    @foreach($relatedArticles as $related)
                        <div style="border-bottom: 1px solid #eee; padding-bottom: 12px;">
                            <a href="{{ route('artikel.show', $related->slug) }}" style="color: #0a3d91; text-decoration: none; font-weight: 500; display: block; margin-bottom: 5px; transition: color 0.3s ease;"
                               onmouseover="this.style.color='#1e5f99'"
                               onmouseout="this.style.color='#0a3d91'">
                                {{ Str::limit($related->title, 50) }}
                            </a>
                            <small style="color: #666;">
                                {{ $related->published_at ? $related->published_at->format('d M Y') : 'Draft' }}
                            </small>
                        </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>
</div>

<style>
    /* Responsive Styles for Article Detail Page */
    @media (max-width: 768px) {
        .article-container {
            padding: 20px 15px;
        }

        .article-header {
            padding: 20px 0;
        }

        .article-title {
            font-size: 2rem;
        }

        .article-meta {
            font-size: 0.9rem;
        }

        .article-image img {
            max-width: 100%;
            height: auto;
        }

        .article-content {
            padding: 20px;
            font-size: 1rem;
        }
    }

    @media (max-width: 480px) {
        .article-title {
            font-size: 1.8rem;
        }

        .article-content {
            padding: 15px;
            font-size: 0.95rem;
        }

        .article-meta {
            flex-direction: column;
            gap: 10px;
            text-align: center;
        }
    }
</style>

@endsection

