@extends('layouts.app')

@section('content')
<div style="padding: 40px 20px; width: 100%;">
    <h1 style="color: #0a3d91; text-align: center; margin-bottom: 20px; font-size: 2.5rem;">
        ARTIKEL & BERITA
    </h1>
    <p style="text-align: center; color: #666; font-size: 1.2rem; margin-bottom: 60px;">
        Informasi terkini seputar penjaminan mutu dan perkembangan standar kualitas.
    </p>

    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)); gap: 30px;">
        @php
            $articles = \App\Models\Article::where('is_active', true)
                                          ->where('published_at', '<=', now())
                                          ->orderBy('published_at', 'desc')
                                          ->take(9)
                                          ->get();
        @endphp

        @forelse($articles as $article)
        <article style="background: white; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); overflow: hidden; transition: transform 0.3s ease, box-shadow 0.3s ease;"
                 onmouseover="this.style.transform='translateY(-5px)'; this.style.boxShadow='0 8px 25px rgba(0,0,0,0.15)'"
                 onmouseout="this.style.transform='translateY(0)'; this.style.boxShadow='0 4px 6px rgba(0,0,0,0.1)'">

            @if($article->image)
                <div style="height: 200px; overflow: hidden;">
                    <img src="{{ asset($article->image) }}" alt="{{ $article->title }}" style="width: 100%; height: 100%; object-fit: cover;">
                </div>
            @else
                <div style="height: 200px; background: linear-gradient(135deg, #0a3d91 0%, #1e5bc6 100%); display: flex; align-items: center; justify-content: center;">
                    @if($article->is_featured)
                        <span style="color: white; font-size: 48px;">⭐</span>
                    @elseif($article->category == 'akreditasi')
                        <span style="color: white; font-size: 48px;">🏆</span>
                    @elseif($article->category == 'workshop')
                        <span style="color: white; font-size: 48px;">🎓</span>
                    @elseif($article->category == 'audit')
                        <span style="color: white; font-size: 48px;">🔍</span>
                    @else
                        <span style="color: white; font-size: 48px;">📄</span>
                    @endif
                </div>
            @endif

            <div style="padding: 25px;">
                <div style="display: flex; gap: 10px; margin-bottom: 10px;">
                    @if($article->is_featured)
                        <span style="background: #ffc107; color: #212529; padding: 3px 8px; border-radius: 12px; font-size: 0.75rem; font-weight: bold;">
                            FEATURED
                        </span>
                    @endif
                    @if($article->category)
                        <span style="background: #0a3d91; color: white; padding: 3px 8px; border-radius: 12px; font-size: 0.75rem;">
                            {{ strtoupper($article->category) }}
                        </span>
                    @endif
                </div>

                <h3 style="color: #0a3d91; margin-bottom: 15px; font-size: 1.3rem; line-height: 1.3;">
                    {{ $article->title }}
                </h3>

                <p style="color: #666; line-height: 1.6; margin-bottom: 15px;">
                    {{ Str::limit($article->excerpt, 120) }}
                </p>

                <div style="display: flex; justify-content: space-between; align-items: center;">
                    <div style="display: flex; flex-direction: column;">
                        <span style="color: #999; font-size: 0.85rem;">
                            {{ $article->published_at ? $article->published_at->format('d M Y') : 'Draft' }}
                        </span>
                        @if($article->author)
                            <span style="color: #0a3d91; font-size: 0.8rem; font-weight: 500;">
                                Oleh: {{ $article->author }}
                            </span>
                        @endif
                    </div>
                    <a href="{{ route('artikel.show', $article->slug) }}" style="color: #0a3d91; text-decoration: none; font-weight: bold; transition: color 0.3s ease;"
                       onmouseover="this.style.color='#1e5f99'"
                       onmouseout="this.style.color='#0a3d91'">
                        Baca Selengkapnya →
                    </a>
                </div>
            </div>
        </article>
        @empty
        <div style="grid-column: 1 / -1; text-align: center; padding: 60px; color: #666;">
            <div style="font-size: 4rem; margin-bottom: 20px;">📄</div>
            <h3 style="color: #0a3d91; margin-bottom: 15px;">Belum Ada Artikel</h3>
            <p>Artikel akan segera dipublikasikan. Silakan kembali lagi nanti.</p>
        </div>
        @endforelse
    </div>
</div>

    @include('partials.footer')
@endsection
