@extends('layouts.app')

@section('content')
<div class="home-container" style="width: 100%;">
    <!-- Image Slider -->
    <div style="width:100%; max-width:auto; margin:0px auto; overflow:hidden; position:relative;">
        <!-- SLIDER -->
        <div id="slider" style="display:flex; gap:16px; overflow-x:auto; scroll-behavior:smooth; scrollbar-width:none;">
            <img src="{{ asset('images/gambar1.jpg') }}" style="min-width:100%; height:650px; object-fit:cover; object-position:center top; border-radius:0; flex-shrink:0;" alt="{{ __('messages.quality_assurance') }} 1">
            <img src="{{ asset('images/gambar2.jpg') }}" style="min-width:100%; height:650px; object-fit:cover; object-position:center; border-radius:0; flex-shrink:0;" alt="{{ __('messages.quality_assurance') }} 2">
            <img src="{{ asset('images/gambar3.jpg') }}" style="min-width:100%; height:650px; object-fit:cover; object-position:center; border-radius:0; flex-shrink:0;" alt="{{ __('messages.quality_assurance') }} 3">
        </div>

        <!-- Navigation Dots -->
        <div style="position:absolute; bottom:20px; left:50%; transform:translateX(-50%); display:flex; gap:10px;">
            <div class="slider-dot active" onclick="goToSlide(0)" style="width:12px; height:12px; border-radius:50%; background:#0a3d91; cursor:pointer; opacity:0.7;"></div>
            <div class="slider-dot" onclick="goToSlide(1)" style="width:12px; height:12px; border-radius:50%; background:#0a3d91; cursor:pointer; opacity:0.7;"></div>
            <div class="slider-dot" onclick="goToSlide(2)" style="width:12px; height:12px; border-radius:50%; background:#0a3d91; cursor:pointer; opacity:0.7;"></div>
        </div>
    </div>

    <!-- SPM ATK Excellence Section -->
    <div class="atk-container" style="background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 50%, #1e40af 100%); width:100%; padding:20px 0; margin-top: 20px; text-align:center; font-family:Arial, Helvetica, sans-serif; position: relative; overflow: hidden; min-height: 200px;">

        <!-- Background Pattern -->
        <div style="position: absolute; top: 0; left: 0; right: 0; bottom: 0; opacity: 0.1;">
            <svg width="100%" height="100%" viewBox="0 0 100 100" preserveAspectRatio="none">
                <defs>
                    <pattern id="grid" width="10" height="10" patternUnits="userSpaceOnUse">
                        <path d="M 10 0 L 0 0 0 10" fill="none" stroke="#ffffff" stroke-width="0.5"/>
                    </pattern>
                </defs>
                <rect width="100%" height="100%" fill="url(#grid)" />
            </svg>
        </div>

        <!-- Main Title -->
        <div style="position: relative; z-index: 2; margin-bottom: 15px;">
            <h2 style="color: #ffffff; font-size: 1.8rem; font-weight: 300; margin-bottom: 6px; letter-spacing: 1.5px;">
                Sistem Penjaminan Mutu Politeknik ATK Yogyakarta
            </h2>
            <div style="width: 80px; height: 3px; background: #fbbf24; margin: 0 auto; border-radius: 2px;"></div>
        </div>

        <!-- SPM ATK Letters -->
        <div class="atk-letters" style="display:inline-flex; gap:8px; align-items:center; margin-bottom: 15px;">

          <!-- S P M -->
          <div class="atk-group" style="display:inline-flex; gap:8px;">
            <div class="atk-letter" style="width:60px; height:60px; background:#ffffff; color:#1e3a8a; font-size:28px; display:flex; align-items:center; justify-content:center; font-weight:700; border-radius:6px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); transform: rotate(-1deg);">S</div>
            <div class="atk-letter" style="width:60px; height:60px; background:#ffffff; color:#1e3a8a; font-size:28px; display:flex; align-items:center; justify-content:center; font-weight:700; border-radius:6px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); transform: rotate(1deg);">P</div>
            <div class="atk-letter" style="width:60px; height:60px; background:#ffffff; color:#1e3a8a; font-size:28px; display:flex; align-items:center; justify-content:center; font-weight:700; border-radius:6px; box-shadow: 0 4px 15px rgba(0,0,0,0.1); transform: rotate(-1deg);">M</div>
          </div>

          <!-- A T K -->
          <div class="atk-group" style="display:inline-flex; gap:12px; margin-left:25px;">
            <div class="atk-letter" style="width:60px; height:60px; background:#fbbf24; color:#1e3a8a; font-size:28px; display:flex; align-items:center; justify-content:center; font-weight:700; border-radius:6px; box-shadow: 0 4px 15px rgba(251,191,36,0.2); transform: rotate(1deg);">A</div>
            <div class="atk-letter" style="width:60px; height:60px; background:#fbbf24; color:#1e3a8a; font-size:28px; display:flex; align-items:center; justify-content:center; font-weight:700; border-radius:6px; box-shadow: 0 4px 15px rgba(251,191,36,0.2); transform: rotate(-1deg);">T</div>
            <div class="atk-letter" style="width:60px; height:60px; background:#fbbf24; color:#1e3a8a; font-size:28px; display:flex; align-items:center; justify-content:center; font-weight:700; border-radius:6px; box-shadow: 0 4px 15px rgba(251,191,36,0.2); transform: rotate(0.5deg);">K</div>
          </div>

        </div>

        <!-- Institution Name -->
        <div class="atk-subtitle" style="position: relative; z-index: 2; margin-bottom: 10px;">
            <h3 style="font-size: 1.3rem; color: #fbbf24; font-weight: 600; letter-spacing: 1px; margin: 0;">
                POLITEKNIK ATK
            </h3>
        </div>

        <!-- Quality Statement -->
        <div style="position: relative; z-index: 2;">
            <p style="font-size: 0.9rem; color: #e2e8f0; font-weight: 300; letter-spacing: 0.3px; margin: 0; line-height: 1.4;">
                Berkomitmen untuk mencapai standar mutu tertinggi dalam pendidikan vokasi
            </p>
        </div>

    </div>


    <!-- SPM Menu -->
    <div class="spm-menu" style="background:#0a3a7a; display:flex; justify-content:space-around; align-items:center; padding:18px 10px; color:#fff; text-align:center; flex-wrap:nowrap; gap:20px;">

        <!-- ITEM 1 - DOKUMEN SPM -->
        <a href="{{ route('download') }}" style="text-decoration: none; color: inherit;">
            <div class="spm-menu-item" style="cursor: pointer;">
                <div class="spm-menu-icon">
                    <!-- Graduation Icon -->
                    <svg width="48" height="48" fill="#fff" viewBox="0 0 24 24">
                        <path d="M12 3L1 9l11 6 9-4.91V17h2V9L12 3z"/>
                        <path d="M11 12.65L3.24 9 11 5.35 18.76 9 11 12.65z"/>
                    </svg>
                </div>
                <div class="spm-menu-text spm-menu-text-long">
                    <span>DOKUMEN SPM</span>
                </div>
            </div>
        </a>

        <!-- ITEM 2 - RAPAT TINJAUAN MANAJEMEN -->
        <div class="spm-menu-item">
            <div class="spm-menu-icon">
                <!-- Chart Icon -->
                <svg width="48" height="48" fill="#fff" viewBox="0 0 24 24">
                    <path d="M3 17h2v-7H3v7zm4 0h2V7H7v10zm4 0h2v-4h-2v4zm4 0h2V4h-2v13zm4 0h2v-9h-2v9z"/>
                </svg>
            </div>
            <div class="spm-menu-text spm-menu-text-long">
                <span>RAPAT TINJAUAN MANAJEMEN</span>
            </div>
        </div>


        <!-- ITEM 4 - APRESIASI BIDANG SPM -->
        <div class="spm-menu-item">
            <div class="spm-menu-icon">
                <!-- Trophy Icon -->
                <svg width="48" height="48" fill="#fff" viewBox="0 0 24 24">
                    <path d="M18 2H6v2H2v3c0 3.31 2.69 6 6 6 .46 1.72 1.93 3 3.78 3h.44c1.85 0 3.32-1.28 3.78-3 3.31 0 6-2.69 6-6V4h-4V2z"/>
                    <path d="M8 20h8v2H8z"/>
                </svg>
            </div>
            <div class="spm-menu-text spm-menu-text-long">
                <span>APRESIASI BIDANG SPM</span>
            </div>
        </div>

    </div>

    <!-- Sertifikat Surveilans ISO Section -->
    <div class="iso-certificate-section" style="max-width:1400px; margin:1px auto 40px; background:#fff; padding:30px; box-sizing:border-box;">

        <h2 style="color:#0a3a8f; margin:0 0 10px; font-size: 1.8rem;">Sertifikat Surveilans ISO</h2>
        <div style="height:2px; background:#f2b705; margin-bottom:20px;"></div>

        <div style="text-align:center;">
            <p style="color:#555; font-size:16px; line-height:1.6; margin-bottom:30px;">
                Badan Penjaminan Mutu Universitas Islam Indonesia telah memperoleh sertifikasi 
                untuk Sistem Manajemen Mutu dalam penyelenggaraan pendidikan tinggi.
            </p>

            <div style="border:3px solid #f2b705; padding:20px; display:inline-block; background:#f9f9f9; border-radius:10px;">
                <img src="{{ asset('images/Sertifikat_TPPK.webp') }}"    
                     style="max-width:600px; width:100%; height:auto; display:block;"
                     alt="Sertifikat Surveilans ISO">
            </div>

            <div style="margin-top:20px;">
                <p style="color:#666; font-size:14px; margin:10px 0;">
                    <strong>Sertifikat No:</strong> 8368/SK/BAN-PT/Ak/D3/XI/2025<br>
                    <strong>Masa Berlaku:</strong> 25 November 2025 - 25 November 2028<br>
                    <!-- <strong>Lembaga Sertifikasi:</strong> TUV Rheinland Indonesia -->
                </p>
            </div>
        </div>

    </div>

    <!-- Banner Kunjungan Perguruan Tinggi Sahabat -->
    <div class="banner-kunjungan" style="background:#0b2f78; padding:50px 20px; text-align:center; color:#fff; margin:40px 0;">
        <h1 style="margin:0 0 20px; font-size:32px; letter-spacing:2px; font-weight:bold;">
            KUNJUNGAN&nbsp;&nbsp;PERGURUAN&nbsp;TINGGI&nbsp;SAHABAT
        </h1>

        <a href="{{ route('kontak') }}"
           style="display:inline-block; background:#0a3a8f; color:#ffd200; padding:12px 30px; text-decoration:none; font-size:14px; border-radius:3px;">
            Klik untuk pengajuan kunjungan
        </a>
    </div>

    <!-- Additional Image Slider -->
    <div style="width:100%; max-width:auto; margin:40px auto; overflow:hidden; position:relative;">
        <!-- SLIDER BAWAH -->
        <div id="slider-bottom" style="display:flex; gap:16px; overflow-x:auto; scroll-behavior:smooth; scrollbar-width:none;">
            <img src="{{ asset('images/gambar4.jpg') }}" style="min-width:100%; height:500px; object-fit:cover; border-radius:12px; flex-shrink:0;" alt="{{ __('messages.quality_assurance') }} 1">
            <img src="{{ asset('images/gambar5.jpg') }}" style="min-width:100%; height:500px; object-fit:cover; border-radius:12px; flex-shrink:0;" alt="{{ __('messages.quality_assurance') }} 2">
            <img src="{{ asset('images/gambar6.jpg') }}" style="min-width:100%; height:500px; object-fit:cover; border-radius:12px; flex-shrink:0;" alt="{{ __('messages.quality_assurance') }} 3">
        </div>

        <!-- Navigation Dots -->
        <div style="position:absolute; bottom:20px; left:50%; transform:translateX(-50%); display:flex; gap:10px;">
            <div class="slider-dot-bottom active" onclick="goToSlideBottom(0)" style="width:12px; height:12px; border-radius:50%; background:#0a3d91; cursor:pointer; opacity:0.7;"></div>
            <div class="slider-dot-bottom" onclick="goToSlideBottom(1)" style="width:12px; height:12px; border-radius:50%; background:#0a3d91; cursor:pointer; opacity:0.7;"></div>
            <div class="slider-dot-bottom" onclick="goToSlideBottom(2)" style="width:12px; height:12px; border-radius:50%; background:#0a3d91; cursor:pointer; opacity:0.7;"></div>
        </div>
    </div>


    @include('partials.footer')

</div>

<style>
    @media (max-width: 768px) {
        .grid {
            grid-template-columns: 1fr;
        }

        h1 {
            font-size: 2rem !important;
        }

        .cta-buttons {
            flex-direction: column;
            align-items: center;
        }
    }

    /* Slider Styles */
    #slider::-webkit-scrollbar,
    #slider-bottom::-webkit-scrollbar {
        display: none;
    }

    .slider-dot.active,
    .slider-dot-bottom.active {
        opacity: 1 !important;
    }

    .slider-dot:hover,
    .slider-dot-bottom:hover {
        opacity: 0.9 !important;
    }

    /* SPM Description Responsive */
    .spm-description {
        width: 100%;
        margin: 0;
    }

    /* SPM Menu Styles */
    .spm-menu-item {
        display: flex;
        flex-direction: column;
        align-items: center;
        min-width: 120px;
    }

    .spm-menu-icon {
        width: 110px;
        height: 110px;
        border: 3px solid #fff;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 25px;
        transition: all 0.3s ease;
    }

    .spm-menu-icon:hover {
        transform: scale(1.05);
        border-color: #ffd700;
    }

    .spm-menu-icon svg {
        transition: all 0.3s ease;
    }

    .spm-menu-icon:hover svg {
        transform: scale(1.1);
    }

    .spm-menu-text {
        font-size: 12px;
        letter-spacing: 0.5px;
        font-weight: 500;
        line-height: 1.2;
        text-align: center;
        max-width: 160px;
        display: flex;
        flex-direction: column;
        gap: 3px;
        justify-content: center;
    }

    .spm-menu-text span {
        display: block;
        line-height: 1.1;
    }

    .spm-menu-text-long {
        flex-direction: row !important;
        gap: 2px !important;
        flex-wrap: wrap !important;
        justify-content: center !important;
        max-width: 200px !important;
    }

        .spm-menu-text-long span {
            display: inline !important;
            white-space: nowrap !important;
        }

        /* Banner Kunjungan Responsive */
        @media (max-width: 768px) {
            .banner-kunjungan {
                padding: 30px 15px !important;
            }

            .banner-kunjungan h1 {
                font-size: 24px !important;
                letter-spacing: 1px !important;
            }

            .banner-kunjungan a {
                padding: 10px 20px !important;
                font-size: 13px !important;
            }
        }

        /* Section Icon Responsive */
        @media (max-width: 768px) {
            .section-icon {
                height: auto !important;
                padding: 30px 20px !important;
                gap: 40px !important;
                flex-direction: column !important;
            }

            .section-icon-item {
                margin-bottom: 20px !important;
            }

            .section-icon-circle {
                width: 80px !important;
                height: 80px !important;
            }

            .section-icon-text {
                font-size: 13px !important;
            }
        }

        @media (max-width: 480px) {
            .section-icon {
                padding: 20px 15px !important;
                gap: 30px !important;
            }

            .section-icon-circle {
                width: 70px !important;
                height: 70px !important;
            }

            .section-icon-text {
                font-size: 12px !important;
            }
        }

    /* SPM ATK Responsive */
    @media (max-width: 768px) {
        .atk-container {
            padding: 25px 15px;
            min-height: 250px;
        }

        .atk-letters {
            flex-wrap: wrap;
            justify-content: center;
            gap: 8px;
        }

        .atk-group {
            margin-left: 0 !important;
            margin-bottom: 10px;
        }

        .atk-letter {
            width: 60px !important;
            height: 60px !important;
            font-size: 28px !important;
            transform: rotate(0deg) !important;
        }

        .atk-container h2 {
            font-size: 1.8rem !important;
            letter-spacing: 1.5px !important;
        }

        .atk-container h3 {
            font-size: 1.3rem !important;
        }

        .atk-container p {
            font-size: 1rem !important;
            padding: 0 20px;
        }
    }

    @media (max-width: 480px) {
        .atk-container {
            padding: 20px 10px;
            min-height: 220px;
        }

        .atk-letters {
            gap: 6px;
        }

        .atk-letter {
            width: 50px !important;
            height: 50px !important;
            font-size: 22px !important;
        }

        .atk-container h2 {
            font-size: 1.5rem !important;
            letter-spacing: 1px !important;
        }

        .atk-container h3 {
            font-size: 1.1rem !important;
            letter-spacing: 0.5px !important;
        }

        .atk-container p {
            font-size: 0.9rem !important;
            padding: 0 15px;
        }
    }

        .spm-description {
            padding: 20px 15px !important;
            font-size: 16px !important;
        }

        /* SPM Menu Responsive - Force horizontal on tablets too */
        @media (min-width: 769px) {
            .spm-menu {
                flex-direction: row !important;
                justify-content: space-around !important;
                flex-wrap: nowrap !important;
                gap: 20px !important;
            }

            .spm-menu-item {
                min-width: 120px !important;
            }
        }

        /* News & Events Responsive */
        .news-events-section {
            flex-direction: column !important;
        }

        .news-content, .events-sidebar {
            width: 100% !important;
        }

        .news-content {
            padding: 20px 15px !important;
        }

        .events-sidebar {
            padding: 20px 15px !important;
            background: #f8f8f8 !important;
        }

        .main-news {
            width: 100% !important;
            margin-bottom: 30px !important;
        }

        .news-list {
            width: 100% !important;
        }

        .news-item, .event-item {
            flex-direction: column !important;
            text-align: center !important;
            gap: 10px !important;
        }

        .news-item img {
            width: 100% !important;
            height: 150px !important;
        }
    }

        .spm-menu {
            flex-direction: row !important;
            flex-wrap: wrap !important;
            justify-content: auto !important;
            gap: 20px !important;
            padding: 20px 20px !important;
        }

        .spm-menu-item {
            min-width: 200px !important;
            margin-bottom: 20px !important;
        }

        .spm-menu-item {
            min-width: auto !important;
        }

        .spm-menu-icon {
            width: 90px !important;
            height: 90px !important;
            margin-bottom: 15px !important;
        }

        .spm-menu-icon svg {
            width: 36px !important;
            height: 36px !important;
        }

        .spm-menu-text {
            font-size: 14px !important;
            max-width: 100px !important;
        }
    }

    /* Footer Responsive */
    @media (max-width: 768px) {
        .footer-section {
            flex-direction: column !important;
            padding: 30px 20px !important;
            min-height: auto !important;
            gap: 30px !important;
        }

        .footer-section > div {
            width: 100% !important;
        }

        .footer-section > div:last-child {
            flex-direction: row !important;
        }
    }

    @media (max-width: 480px) {
        .footer-section {
            padding: 20px 15px !important;
            gap: 20px !important;
        }

        .footer-section > div:first-child {
            font-size: 14px !important;
        }

        .footer-section > div:first-child > div:first-child {
            font-size: 16px !important;
        }

        .footer-section > div:last-child {
            font-size: 14px !important;
            flex-direction: column !important;
            gap: 10px !important;
        }

        .footer-section > div:last-child > div:first-child {
            width: 6px !important;
            height: 60px !important;
            margin-right: 15px !important;
        }
    }
</style>

<!-- SCRIPT AUTO SLIDE -->
<script>
    // Slider Atas
    const slider = document.getElementById('slider');
    const dots = document.querySelectorAll('.slider-dot');
    let index = 0;
    let autoSlideInterval;

    function updateDots() {
        dots.forEach((dot, i) => {
            dot.classList.toggle('active', i === index);
        });
    }

    function goToSlide(slideIndex) {
        index = slideIndex;
        slider.scrollTo({
            left: slider.clientWidth * index,
            behavior: 'smooth'
        });
        updateDots();
        resetAutoSlide();
    }

    function nextSlide() {
        index++;
        if (index >= slider.children.length) {
            index = 0;
        }
        slider.scrollTo({
            left: slider.clientWidth * index,
            behavior: 'smooth'
        });
        updateDots();
    }

    function resetAutoSlide() {
        clearInterval(autoSlideInterval);
        autoSlideInterval = setInterval(nextSlide, 5000); // 5 detik
    }

    // Initialize slider atas
    if (slider) {
        updateDots();
        resetAutoSlide();

        // Handle manual scrolling
        slider.addEventListener('scroll', () => {
            const scrollLeft = slider.scrollLeft;
            const slideWidth = slider.clientWidth;
            const newIndex = Math.round(scrollLeft / slideWidth);
            if (newIndex !== index) {
                index = newIndex;
                updateDots();
                resetAutoSlide();
            }
        });
    }

    // Slider Bawah
    const sliderBottom = document.getElementById('slider-bottom');
    const dotsBottom = document.querySelectorAll('.slider-dot-bottom');
    let indexBottom = 0;
    let autoSlideIntervalBottom;

    function updateDotsBottom() {
        dotsBottom.forEach((dot, i) => {
            dot.classList.toggle('active', i === indexBottom);
        });
    }

    function goToSlideBottom(slideIndex) {
        indexBottom = slideIndex;
        sliderBottom.scrollTo({
            left: sliderBottom.clientWidth * indexBottom,
            behavior: 'smooth'
        });
        updateDotsBottom();
        resetAutoSlideBottom();
    }

    function nextSlideBottom() {
        indexBottom++;
        if (indexBottom >= sliderBottom.children.length) {
            indexBottom = 0;
        }
        sliderBottom.scrollTo({
            left: sliderBottom.clientWidth * indexBottom,
            behavior: 'smooth'
        });
        updateDotsBottom();
    }

    function resetAutoSlideBottom() {
        clearInterval(autoSlideIntervalBottom);
        autoSlideIntervalBottom = setInterval(nextSlideBottom, 6000); // 6 detik untuk slider bawah
    }

    // Initialize slider bawah
    if (sliderBottom) {
        updateDotsBottom();
        resetAutoSlideBottom();

        // Handle manual scrolling
        sliderBottom.addEventListener('scroll', () => {
            const scrollLeft = sliderBottom.scrollLeft;
            const slideWidth = sliderBottom.clientWidth;
            const newIndex = Math.round(scrollLeft / slideWidth);
            if (newIndex !== indexBottom) {
                indexBottom = newIndex;
                updateDotsBottom();
                resetAutoSlideBottom();
            }
        });
    }

    /* Responsive Styles for Home Page */
    @media (max-width: 1200px) {
        .home-container {
            padding: 0 10px;
        }

        .hero-slider, .hero-slider-bottom {
            max-width: 100%;
        }

        #slider img, #slider-bottom img {
            height: 500px !important;
        }

        .hero-text h1 {
            font-size: 3.5rem;
        }

        .hero-text p {
            font-size: 1.3rem;
        }

        .spm-container {
            padding: 20px;
        }

        .spm-letters .atk-letter {
            width: 50px;
            height: 50px;
            font-size: 24px;
        }

        .news-events-section {
            margin: 1px auto 30px;
            max-width: 100%;
        }
    }

    @media (max-width: 1024px) {
        .hero-text h1 {
            font-size: 3rem;
        }

        .hero-text p {
            font-size: 1.2rem;
        }

        .spm-letters .atk-letter {
            width: 45px;
            height: 45px;
            font-size: 22px;
        }

        .news-events-section {
            flex-direction: column;
        }

        .news-content, .events-sidebar {
            width: 100%;
            padding: 20px;
        }

        .news-content {
            border-bottom: 1px solid #ddd;
            margin-bottom: 20px;
        }
    }

    @media (max-width: 768px) {
        .home-container {
            padding: 0 5px !important;
        }

        .hero-text h1 {
            font-size: 2.5rem !important;
            text-align: center !important;
        }

        .hero-text p {
            font-size: 1.1rem !important;
            text-align: center !important;
        }

        .hero-buttons {
            justify-content: center !important;
            flex-direction: column !important;
            gap: 15px !important;
        }

        .hero-button {
            width: 100% !important;
            max-width: 300px !important;
        }

        .spm-container {
            padding: 15px;
        }

        .spm-letters {
            justify-content: center;
        }

        .spm-letters .atk-letter {
            width: 40px;
            height: 40px;
            font-size: 20px;
        }

        .atk-excellence h2 {
            font-size: 1.8rem;
        }

        .atk-excellence p {
            font-size: 1rem;
        }

        .news-events-section {
            margin: 20px auto !important;
            padding: 0 !important;
            flex-direction: column !important;
            max-width: 100% !important;
        }

        .news-content, .events-sidebar {
            padding: 15px !important;
            width: 100% !important;
        }

        .main-news, .news-list {
            width: 100%;
        }

        .news-list {
            margin-top: 20px;
        }

        .main-news img {
            height: 250px;
        }

        .iso-certificate-section {
            padding: 20px;
        }

        .iso-certificate-section h2 {
            font-size: 1.5rem;
        }

        .slider-bottom img {
            height: 400px;
        }
    }

    @media (max-width: 480px) {
        .home-container {
            padding: 0 !important;
        }

        #slider img, #slider-bottom img {
            height: 300px !important;
        }

        .hero-text h1 {
            font-size: 2rem !important;
            text-align: center !important;
        }

        .hero-text p {
            font-size: 1rem !important;
            text-align: center !important;
        }

        .hero-button {
            padding: 12px 24px !important;
            font-size: 14px !important;
            width: 100% !important;
            max-width: 250px !important;
        }

        .spm-container {
            padding: 10px !important;
        }

        .spm-letters .atk-letter {
            width: 35px !important;
            height: 35px !important;
            font-size: 18px !important;
        }

        .atk-excellence {
            padding: 30px 15px;
        }

        .atk-excellence h2 {
            font-size: 1.5rem;
        }

        .news-content, .events-sidebar {
            padding: 10px;
        }

        .main-news img {
            height: 200px;
        }

        .news-item {
            flex-direction: column;
            text-align: center;
        }

        .news-item img {
            width: 60px;
            height: 60px;
        }

        .iso-certificate-section {
            padding: 15px;
        }

        .iso-certificate-section h2 {
            font-size: 1.3rem;
        }

        .iso-certificate-section p {
            font-size: 14px;
        }

        .slider-bottom img {
            height: 300px;
        }

        .banner-kunjungan {
            padding: 30px 15px;
        }

        .banner-kunjungan h1 {
            font-size: 24px;
        }
    }
</script>
@endsection
