@extends('layouts.app')

@section('content')
<div style="padding: 40px 20px; width: 100%;">
    <h1 style="color: #0a3d91; text-align: center; margin-bottom: 20px; font-size: 2.5rem;">
        LAYANAN KAMI
    </h1>
    <p style="text-align: center; color: #666; font-size: 1.2rem; margin-bottom: 60px; max-width: 800px; margin-left: auto; margin-right: auto;">
        Kami menyediakan berbagai layanan penjaminan mutu untuk membantu Anda mencapai standar kualitas tertinggi.
    </p>

    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(350px, 1fr)); gap: 30px; margin-bottom: 60px;">
        @forelse($services as $service)
        <div style="background: white; padding: 30px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
            <div style="display: flex; align-items: center; margin-bottom: 20px;">
                <div style="width: 50px; height: 50px; background: #0a3d91; border-radius: 50%; display: flex; align-items: center; justify-content: center; margin-right: 20px;">
                    <span style="color: white; font-size: 20px; font-weight: bold;">{{ $service->icon ?: '📋' }}</span>
                </div>
                <h3 style="color: #0a3d91; font-size: 1.3rem;">{{ $service->title }}</h3>
            </div>
            <p style="color: #666; line-height: 1.6; margin-bottom: 20px;">
                {{ $service->description }}
            </p>
            @if($service->features && is_array($service->features) && count($service->features) > 0)
            <ul style="color: #666; padding-left: 20px;">
                @foreach($service->features as $feature)
                <li>{{ $feature }}</li>
                @endforeach
            </ul>
            @endif
        </div>
        @empty
        <div style="grid-column: 1 / -1; text-align: center; padding: 60px; background: white; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
            <div style="font-size: 4rem; margin-bottom: 20px;">📋</div>
            <h3 style="color: #0a3d91; margin-bottom: 15px;">Layanan Belum Tersedia</h3>
            <p style="color: #666;">Mohon maaf, layanan kami sedang dalam pengembangan. Silakan hubungi kami untuk informasi lebih lanjut.</p>
        </div>
        @endforelse
    </div>

    <!-- Contact Section -->
    <div style="background: linear-gradient(135deg, #0a3d91 0%, #1e5bc6 100%); color: white; padding: 40px; border-radius: 15px; text-align: center;">
        <h2 style="margin-bottom: 20px; font-size: 2rem;">Butuh Bantuan?</h2>
        <p style="margin-bottom: 30px; font-size: 1.1rem; opacity: 0.9;">
            Tim ahli kami siap membantu Anda dalam mengimplementasikan sistem penjaminan mutu.
        </p>
        <a href="{{ route('kontak') }}" style="background: #ffd700; color: #0a3d91; padding: 12px 30px; border-radius: 25px; text-decoration: none; font-weight: bold; display: inline-block;">
            Hubungi Kami
        </a>
    </div>
</div>
    @include('partials.footer')
@endsection
