@extends('layouts.app')

@section('content')
<div style="padding: 40px 20px; width: 100%; max-width: 1200px; margin: 0 auto;">
    <h1 style="color: #0a3d91; text-align: center; margin-bottom: 40px; font-size: 2.5rem;">
        PROFIL BADAN PENJAMINAN MUTU
    </h1>

    <div style="background: white; padding: 40px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); margin-bottom: 40px;">
        <h2 style="color: #0a3d91; margin-bottom: 30px; font-size: 1.8rem;">Tentang BPM ATK</h2>
        
        <div class="profil-content-wrapper" style="display: flex; gap: 30px; align-items: flex-start; flex-wrap: wrap;">
            <!-- Gambar Sertifikat -->
            <div class="profil-certificate" style="flex: 0 0 250px; min-width: 200px;">
                <div style="border: 3px solid #0a3d91; padding: 15px; background: #f9f9f9; border-radius: 8px; text-align: center;">
                    <div style="background: white; padding: 20px; border: 2px solid #ddd; border-radius: 5px; min-height: 300px; display: flex; align-items: center; justify-content: center;">
                        <div style="color: #0a3d91; font-weight: bold; font-size: 16px;">
                            <div style="margin-bottom: 10px;">CERTIFICATE</div>
                            <div style="font-size: 14px; color: #666;">ISO 9001:2008</div>
                            <div style="font-size: 12px; color: #666; margin-top: 10px;">TUV Rheiland</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Konten Teks -->
            <div class="profil-text" style="flex: 1; min-width: 300px; color: #666; line-height: 1.8; text-align: justify;">
                <p style="margin-bottom: 20px;">
                    Berlandaskan kebutuhan sistem manajemen organisasi berbasis pada kualitas yang mampu memenuhi kebutuhan dan harapan stakeholders. maka Politeknik ATK Yogyakarta menerapkan Sistem Penjaminan Mutu berbasis ISO 9001:2015 dan Prinsip Penjaminan Mutu Dikti dengan lingkup penerapan di bidang akademik dan non akademik.
                </p>

                <p style="margin-bottom: 20px;">
                    Sistem Penjaminan Mutu (SPM) yang diterapkan di ATK berfungsi untuk mengelola, mengevaluasi, memonitor dan mengawal kinerja lembaga pendidikan tinggi secara sistematis. Penjaminan Mutu ATK memastikan/menjamin input, proses dan output sesuai dengan standar mutu yang ditetapkan. Salah satu caranya adalah dengan menjadikan Mutu di ATK sebagai budaya yang ditunjukkan oleh sikap, kebiasaan, perilaku berorganisasi, etos bekerja, berkarya, melayani, berinteraksi dengan kolega, pimpinan dan masyarakat dengan hasil yang terbaik. Budaya mutu bisa dibangun dan dikembangkan dengan komitmen semua warga ATK.
                </p>

                <p style="margin-bottom: 20px;">
                    Unit Pelaksana SPM di lingkungan ATK adalah Badan Penjaminan Mutu (BPM), tercermin dalam Struktur Organisasi ATK. Badan Penjaminan Mutu Politeknik ATK Yogyakarta dididirikan untuk menjalankan fungsi penjaminan mutu dalam pendidikan vokasi. BPM ATK mempunyai tugas utama antara lain pembuatan, penerapan dan pengembangan Sistem Manajemen Mutu (SMM) serta pengembangan konsep-konsep dan disain pendidikan di Politeknik ATK Yogyakarta. SMM yang dikembangkan berbasis pada ISO 9001: 2015.
                </p>

                <p style="margin-bottom: 20px;">
                    Dalam perkembangannya, BPM ATK terus berkembang dan beradaptasi dengan perkembangan sistem penjaminan mutu terkini. BPM ATK mengembangkan orientasi SMM berbasis pada ISO 9001:2015 dan standar mutu pendidikan vokasi terkini.
                </p>

                <p style="margin-bottom: 20px;">
                    BPM ATK mengacu pada peraturan perundang-undangan terkini tentang standar nasional pendidikan dan istilah Sistem Manajemen Mutu yang diubah menjadi Sistem Penjaminan Mutu (SPM). Model yang digunakan mengacu pada ISO 9001:2015 yang dikombinasikan dengan Sistem Penjaminan Mutu Perguruan Tinggi dari Direktorat Jenderal Pendidikan Tinggi (DIKTI).
                </p>

                <p style="margin-bottom: 20px;">
                    ATK memutuskan dan merencanakan untuk memperoleh sertifikasi Quality Management Systems (QMS) ISO 9001. Untuk itu BPM melakukan penyesuaian-penyesuaian dokumen Sistem Penjaminan Mutu yang dipersyaratkan oleh QMS ISO 9001:2015. Sertifikasi Quality Management Systems for Higher Education Services ISO 9001:2015 diperoleh untuk seluruh unit di lingkungan ATK dari lembaga sertifikasi terakreditasi.
                </p>

                <p style="margin-bottom: 20px;">
                    Di tahun 2009, UII ditetapkan sebagai Perguruan Tinggi yang memperoleh skor tertinggi untuk Hasil Evaluasi Implementasi Sistem Penjaminan Mutu Internal Perguruan Tinggi tahun 2008 berdasarkan site verification dan technical assistance dari DIKTI.
                </p>

                <p style="margin-bottom: 20px;">
                    Untuk meningkatkan kualitas pelayanan dan kinerja laboratorium pengujian, ATK mengimplementasikan penjaminan mutu untuk laboratorium pengujian dengan menggunakan standar ISO/IEC 17025 serta menilai pentingnya pengakuan eksternal berupa adanya sertifikat akreditasi laboratorium dari Komite Akreditasi Nasional (KAN). Laboratorium pengujian yang sudah terakreditasi KAN di lingkungan ATK menggunakan standar ISO/IEC 17025 (Standar Umum Kompetensi Pengujian dan Kalibrasi untuk Laboratorium). Dalam hal ini BPM turut mengawal serta mendampingi agar konsistensi implementasi sistem tersebut dapat terjaga dan mampu terintegrasi dengan SPM ATK.
                </p>
            </div>
        </div>
    </div>
</div>

<!-- Footer Section -->
<div class="footer-section" style="background:#0a3d91; width:100%; min-height:420px; padding:50px 70px; box-sizing:border-box; display:flex; justify-content:space-between; align-items:flex-start;">

    <!-- KONTEN KIRI -->
    <div style="width:55%; color:#000; line-height:1.7; font-size:16px;">
        <div style="font-weight:bold; font-size:18px; margin-bottom:12px;">
            Badan Penjaminan Mutu Universitas Islam Indonesia
        </div>

        <div>Gedung GBPH Prabuningrat Lantai III</div>
        <div>Jl. Kaliurang km 14,5 Sleman Yogyakarta 55283</div>
        <div>Telepon: +62 274 898444 ext. 1313</div>
        <div>Whatsapp: +62 813-2622-6312</div>
        <div>Email: bpm[at]uii.ac.id</div>
    </div>

    <!-- KONTEN KANAN -->
    <div style="width:40%; display:flex; align-items:flex-start; color:#000; line-height:1.7; font-size:16px;">

        <!-- GARIS VERTIKAL -->
        <div style="width:6px; height:100%; background:#000; margin-right:18px;"></div>

        <!-- TEKS -->
        <div>
            <strong>Akreditasi Institusi Unggul.</strong>
            Universitas Islam Indonesia telah mendapatkan Akreditasi
            Institusi Unggul dari Badan Akreditasi Nasional Perguruan Tinggi
            (BAN-PT) pada tahun 2022
            (Surat Keputusan BAN-PT No.
            2003/SK/BAN-PT/AK-Ppj/PT/XII/2022).
        </div>
    </div>

</div>

@include('partials.footer')

<style>
    /* Footer Full Width */
    .footer-section,
    .footer-copyright {
        margin-left: calc(-50vw + 50%) !important;
        margin-right: calc(-50vw + 50%) !important;
        width: 100vw !important;
        max-width: 100vw !important;
    }

    @media (max-width: 768px) {
        .profil-content-wrapper {
            flex-direction: column !important;
        }
        
        .profil-certificate {
            flex: 1 1 100% !important;
            max-width: 100% !important;
            margin: 0 auto 30px !important;
        }
        
        .profil-text {
            flex: 1 1 100% !important;
        }

        /* Footer Responsive */
        .footer-section {
            flex-direction: column !important;
            padding: 30px 20px !important;
            min-height: auto !important;
            gap: 30px !important;
            margin-left: calc(-50vw + 50%) !important;
            margin-right: calc(-50vw + 50%) !important;
            width: 100vw !important;
        }

        .footer-section > div {
            width: 100% !important;
        }

        .footer-section > div:last-child {
            flex-direction: row !important;
        }
    }

    @media (max-width: 480px) {
        .footer-section {
            padding: 20px 15px !important;
            gap: 20px !important;
        }

        .footer-section > div:first-child {
            font-size: 14px !important;
        }

        .footer-section > div:first-child > div:first-child {
            font-size: 16px !important;
        }

        .footer-section > div:last-child {
            font-size: 14px !important;
            flex-direction: column !important;
            gap: 10px !important;
        }

        .footer-section > div:last-child > div:first-child {
            width: 6px !important;
            height: 60px !important;
            margin-right: 15px !important;
        }
    }

    /* Responsive Styles for Profil Page */
    @media (max-width: 768px) {
        .profile-header {
            padding: 20px 0;
        }

        .profile-title {
            font-size: 2rem;
        }

        .profile-subtitle {
            font-size: 1rem;
        }

        .profile-content {
            padding: 20px;
            font-size: 0.95rem;
        }

        .profile-image img {
            max-width: 100%;
            height: auto;
        }
    }

    @media (max-width: 480px) {
        .profile-title {
            font-size: 1.8rem;
        }

        .profile-content {
            padding: 15px;
            font-size: 0.9rem;
        }
    }
</style>
@endsection
