

<?php $__env->startSection('title', 'Kelola Dokumen - Admin Panel'); ?>

<?php $__env->startSection('page-title', 'Kelola Dokumen'); ?>

<?php $__env->startSection('content'); ?>
<div class="breadcrumb">
    <a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
    <span>/</span>
    <span>Kelola Dokumen</span>
</div>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
    <h1 style="color: #0a3d91; font-size: 2rem; margin: 0;">Kelola Dokumen</h1>
    <a href="<?php echo e(route('admin.documents.create')); ?>" style="background: #0a3d91; color: white; padding: 12px 24px; text-decoration: none; border-radius: 8px; font-weight: bold;">
        + Tambah Dokumen
    </a>
</div>

        <?php if(session('success')): ?>
            <div style="background: #d4edda; color: #155724; padding: 15px; border-radius: 8px; margin-bottom: 20px; border: 1px solid #c3e6cb;">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div style="background: #f8d7da; color: #721c24; padding: 15px; border-radius: 8px; margin-bottom: 20px; border: 1px solid #f5c6cb;">
                <?php echo e(session('error')); ?>

            </div>
        <?php endif; ?>

        <div style="background: white; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); overflow: hidden;">
            <div style="padding: 20px;">
                <table style="width: 100%; border-collapse: collapse;">
                    <thead>
                        <tr style="border-bottom: 2px solid #eee;">
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Judul Dokumen</th>
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Kategori</th>
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Ukuran File</th>
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Download</th>
                            <th style="padding: 12px; text-align: left; font-weight: bold; color: #0a3d91;">Status</th>
                            <th style="padding: 12px; text-align: center; font-weight: bold; color: #0a3d91;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr style="border-bottom: 1px solid #eee;">
                                <td style="padding: 12px;">
                                    <div style="font-weight: bold; color: #333;"><?php echo e($document->title); ?></div>
                                    <div style="font-size: 0.9rem; color: #666; margin-top: 4px;">
                                        <?php echo e(Str::limit($document->description, 50)); ?>

                                    </div>
                                    <div style="font-size: 0.8rem; color: #999; margin-top: 2px;">
                                        <?php echo e($document->file_name); ?>

                                    </div>
                                </td>
                                <td style="padding: 12px;">
                                    <span style="background: #f8f9fa; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                        <?php echo e($document->category); ?>

                                    </span>
                                </td>
                                <td style="padding: 12px;">
                                    <?php echo e($document->formatted_file_size); ?>

                                </td>
                                <td style="padding: 12px;">
                                    <span style="background: #e9ecef; color: #495057; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                        <?php echo e($document->download_count); ?> kali
                                    </span>
                                </td>
                                <td style="padding: 12px;">
                                    <?php if($document->is_active): ?>
                                        <span style="background: #d4edda; color: #155724; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                            Aktif
                                        </span>
                                    <?php else: ?>
                                        <span style="background: #f8d7da; color: #721c24; padding: 4px 8px; border-radius: 4px; font-size: 0.9rem;">
                                            Tidak Aktif
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td style="padding: 12px; text-align: center;">
                                    <div style="display: flex; gap: 8px; justify-content: center; flex-wrap: wrap;">
                                        <a href="<?php echo e($document->download_url); ?>" target="_blank" style="background: #28a745; color: white; padding: 6px 12px; text-decoration: none; border-radius: 4px; font-size: 0.9rem;">
                                            Download
                                        </a>
                                        <a href="<?php echo e(route('admin.documents.show', $document)); ?>" style="background: #17a2b8; color: white; padding: 6px 12px; text-decoration: none; border-radius: 4px; font-size: 0.9rem;">
                                            Lihat
                                        </a>
                                        <a href="<?php echo e(route('admin.documents.edit', $document)); ?>" style="background: #ffc107; color: #212529; padding: 6px 12px; text-decoration: none; border-radius: 4px; font-size: 0.9rem;">
                                            Edit
                                        </a>
                                        <form action="<?php echo e(route('admin.documents.destroy', $document)); ?>" method="POST" style="display: inline;" onsubmit="return confirm('Apakah Anda yakin ingin menghapus dokumen ini?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" style="background: #dc3545; color: white; padding: 6px 12px; border: none; border-radius: 4px; font-size: 0.9rem; cursor: pointer;">
                                                Hapus
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" style="padding: 40px; text-align: center; color: #666;">
                                    Belum ada data dokumen.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <?php if($documents->hasPages()): ?>
            <div style="margin-top: 20px;">
                <?php echo e($documents->links()); ?>

            </div>
        <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Spm1\resources\views/admin/documents/index.blade.php ENDPATH**/ ?>