<?php $__env->startSection('title', 'Tambah Dokumen - Admin Panel'); ?>

<?php $__env->startSection('content'); ?>
<div style="padding: 40px 20px; width: 100%;">
    <div style="max-width: 800px; margin: 0 auto;">
        <div style="background: white; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); padding: 30px;">
            <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
                <h1 style="color: #0a3d91; font-size: 2rem; margin: 0;">Tambah Dokumen Baru</h1>
                <a href="<?php echo e(route('admin.documents.index')); ?>" style="color: #6c757d; text-decoration: none;">
                    ← Kembali
                </a>
            </div>

            <form action="<?php echo e(route('admin.documents.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <div style="margin-bottom: 20px;">
                    <label for="title" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Judul Dokumen *</label>
                    <input type="text" id="title" name="title" value="<?php echo e(old('title')); ?>" required
                           style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                    <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div style="color: #dc3545; font-size: 0.9rem; margin-top: 4px;"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div style="margin-bottom: 20px;">
                    <label for="description" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Deskripsi Dokumen</label>
                    <textarea id="description" name="description" rows="4"
                              style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px; resize: vertical;"><?php echo e(old('description')); ?></textarea>
                    <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div style="color: #dc3545; font-size: 0.9rem; margin-top: 4px;"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div style="margin-bottom: 20px;">
                    <label for="category" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Kategori Dokumen *</label>
                    <select id="category" name="category" required style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                        <option value="">Pilih Kategori</option>
                        <option value="dokumen-mutu" <?php echo e(old('category') == 'dokumen-mutu' ? 'selected' : ''); ?>>Dokumen Mutu</option>
                        <option value="standar" <?php echo e(old('category') == 'standar' ? 'selected' : ''); ?>>Standar</option>
                        <option value="prosedur" <?php echo e(old('category') == 'prosedur' ? 'selected' : ''); ?>>Prosedur</option>
                        <option value="formulir" <?php echo e(old('category') == 'formulir' ? 'selected' : ''); ?>>Formulir</option>
                        <option value="laporan" <?php echo e(old('category') == 'laporan' ? 'selected' : ''); ?>>Laporan</option>
                        <option value="lainnya" <?php echo e(old('category') == 'lainnya' ? 'selected' : ''); ?>>Lainnya</option>
                    </select>
                    <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div style="color: #dc3545; font-size: 0.9rem; margin-top: 4px;"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
                    <div>
                        <label for="file" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">File Dokumen *</label>
                        <input type="file" id="file" name="file" required accept=".pdf,.doc,.docx,.xls,.xlsx,.ppt,.pptx"
                               style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                        <div style="font-size: 0.9rem; color: #666; margin-top: 4px;">
                            Format yang didukung: PDF, DOC, DOCX, XLS, XLSX, PPT, PPTX. Maksimal 20MB.
                        </div>
                        <?php $__errorArgs = ['file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: #dc3545; font-size: 0.9rem; margin-top: 4px;"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div>
                        <label for="image" style="display: block; font-weight: bold; margin-bottom: 8px; color: #333;">Gambar Preview (Opsional)</label>
                        <input type="file" id="image" name="image" accept=".jpg,.jpeg,.png,.gif"
                               style="width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 8px; font-size: 16px;">
                        <div style="font-size: 0.9rem; color: #666; margin-top: 4px;">
                            Format yang didukung: JPG, JPEG, PNG, GIF. Maksimal 2MB. <br>
                            <em>Gambar ini akan ditampilkan sebagai preview di halaman download.</em>
                        </div>
                        <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div style="color: #dc3545; font-size: 0.9rem; margin-top: 4px;"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>

                <div style="margin-bottom: 20px;">
                    <label style="display: flex; align-items: center; font-weight: bold; color: #333; cursor: pointer;">
                        <input type="checkbox" name="is_active" value="1" <?php echo e(old('is_active') ? 'checked' : 'checked'); ?>

                               style="margin-right: 10px; width: 18px; height: 18px;">
                        Dokumen Aktif (dapat diakses publik)
                    </label>
                </div>

                <div style="display: flex; gap: 15px; margin-top: 30px;">
                    <button type="submit" style="background: #0a3d91; color: white; padding: 12px 30px; border: none; border-radius: 8px; font-size: 16px; font-weight: bold; cursor: pointer;">
                        Simpan Dokumen
                    </button>
                    <a href="<?php echo e(route('admin.documents.index')); ?>" style="background: #6c757d; color: white; padding: 12px 30px; text-decoration: none; border-radius: 8px; font-size: 16px; font-weight: bold;">
                        Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Spm1\resources\views/admin/documents/create.blade.php ENDPATH**/ ?>