<?php

namespace App\Http\Controllers;

use App\Models\Unit;
use Illuminate\Http\Request;

class UnitController extends Controller
{
    public function index()
    {
        $units = Unit::orderBy('prodi', 'asc')->get();
        return view('units.index', compact('units'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'prodi' => 'required',
            'nama_lab' => 'required|string|max:255'
        ]);

        Unit::create($request->all());
        return redirect()->route('units.index')->with('success', 'Unit berhasil ditambahkan.');
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'prodi' => 'required',
            'nama_lab' => 'required|string|max:255'
        ]);

        $unit = Unit::findOrFail($id);
        $unit->update($request->all());

        return redirect()->route('units.index')->with('success', 'Unit berhasil diperbarui.');
    }

    public function destroy($id)
    {
        $unit = Unit::findOrFail($id);
        $unit->delete();

        return redirect()->route('units.index')->with('success', 'Unit berhasil dihapus.');
    }
}